/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZObject;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

class PropertyManager
extends AbstractFile {
    List<Statistic> list = new ArrayList<Statistic>();
    Header header;

    PropertyManager(String name, byte[] buffer, Header header) {
        super(name, buffer);
        this.header = header;
        int propertyNo = 1;
        while (propertyNo <= 31) {
            Statistic statistic = new Statistic(propertyNo);
            this.list.add(statistic);
            ++propertyNo;
        }
    }

    public void addNodes(DefaultMutableTreeNode node, FormattedDisk disk) {
        node.setAllowsChildren(true);
        for (Statistic stat : this.list) {
            if (stat.list.size() <= 0) continue;
            String title = "Property " + this.header.getPropertyName(stat.id).trim();
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(new DefaultAppleFileSource(title, stat.getText(), disk));
            node.add(child);
            child.setAllowsChildren(false);
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Property   Type    Frequency\n");
        text.append("--------   -----   ---------\n");
        for (Statistic stat : this.list) {
            text.append(String.format("%s%n", stat));
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private class Statistic {
        int id;
        List<ZObject> list = new ArrayList<ZObject>();

        public Statistic(int id) {
            this.id = id;
            for (ZObject o : PropertyManager.this.header.objectManager) {
                ZObject.Property p = o.getProperty(id);
                if (p == null) continue;
                this.list.add(o);
            }
        }

        String getText() {
            StringBuilder text = new StringBuilder(String.format("Objects with property %d %s set:%n%n", this.id, PropertyManager.this.header.propertyNames[this.id]));
            for (ZObject o : this.list) {
                ZObject.Property p = o.getProperty(this.id);
                text.append(String.format("%02X  %-29s%s%n", o.getId(), o.getName(), p.toString().substring(11)));
            }
            if (text.length() > 0) {
                text.deleteCharAt(text.length() - 1);
            }
            return text.toString();
        }

        public String toString() {
            return String.format("   %2d      %-6s    %3d", this.id, PropertyManager.this.header.getPropertyName(this.id), this.list.size());
        }
    }
}

