/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.InfocomAbstractFile;
import com.bytezone.diskbrowser.infocom.ObjectAnalyser;
import com.bytezone.diskbrowser.infocom.ZObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

class ObjectManager
extends InfocomAbstractFile
implements Iterable<ZObject> {
    private final List<ZObject> list;
    private List<ZObject> sortedList;
    private final int defaultsPtr;
    private final int defaultsSize;
    private final int tablePtr;
    private final int tableSize;
    private final int propertyPtr;
    private final int propertySize;
    private final ObjectAnalyser analyser;

    ObjectManager(Header header) {
        super("Objects", header.buffer);
        this.defaultsPtr = header.objectTableOffset;
        this.defaultsSize = 62;
        this.tablePtr = header.objectTableOffset + 62;
        this.propertyPtr = header.getWord(this.tablePtr + 7);
        this.propertySize = header.globalsOffset - this.propertyPtr;
        this.tableSize = this.propertyPtr - this.tablePtr;
        int totalObjects = this.tableSize / 9;
        this.list = new ArrayList<ZObject>(this.tableSize);
        int objectNo = 0;
        while (objectNo < totalObjects) {
            this.list.add(new ZObject(null, this.buffer, this.tablePtr + objectNo * 9, objectNo + 1, header));
            ++objectNo;
        }
        this.analyser = new ObjectAnalyser(header, this);
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this.defaultsPtr, this.defaultsSize, "Property defaults:"));
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this.tablePtr, this.tableSize, "Objects table:"));
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this.propertyPtr, this.propertySize, "Properties:"));
    }

    List<ZObject> getObjects() {
        return this.list;
    }

    ZObject getObject(int index) {
        if (index < 0 || index >= this.list.size()) {
            System.out.printf("Invalid index: %d / %d%n", index, this.list.size());
            return null;
        }
        return this.list.get(index);
    }

    public void addNodes(DefaultMutableTreeNode root, FormattedDisk disk) {
        root.setAllowsChildren(true);
        for (ZObject zo : this.list) {
            if (zo.parent != 0) continue;
            this.buildObjectTree(zo, root, disk);
        }
    }

    private void buildObjectTree(ZObject object, DefaultMutableTreeNode parentNode, FormattedDisk disk) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(new DefaultAppleFileSource(object.getName(), object, disk));
        parentNode.add(child);
        if (object.sibling > 0) {
            this.buildObjectTree(this.list.get(object.sibling - 1), parentNode, disk);
        }
        if (object.child > 0) {
            this.buildObjectTree(this.list.get(object.child - 1), child, disk);
        } else {
            child.setAllowsChildren(false);
        }
    }

    public List<Integer> getCodeRoutines() {
        return this.analyser.routines;
    }

    @Override
    public String getText() {
        String underline = " ----------------------------------------";
        String[] titles = new String[]{"ID  ", "Title                                    ", "Parent                                   ", "Sibling                                  ", "Child                                    ", "Attributes   Prop\n"};
        String header2 = String.valueOf(titles[0]) + titles[1] + titles[2] + titles[3] + titles[4] + titles[5] + "-- " + underline + underline + underline + underline + " -----------  -----\n";
        StringBuilder text = new StringBuilder(header2);
        if (this.sortedList == null) {
            this.sortedList = new ArrayList<ZObject>(this.list);
        }
        Collections.sort(this.sortedList);
        for (ZObject zo : this.list) {
            text.append(String.format("%02X %s%n", zo.getId(), zo.getDescription(this.list)));
        }
        text.append("\n\n");
        text.append(header2);
        for (ZObject zo : this.sortedList) {
            text.append(String.format("%02X %s%n", zo.getId(), zo.getDescription(this.list)));
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    @Override
    public Iterator<ZObject> iterator() {
        return this.list.iterator();
    }
}

