/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.List;

class InfocomAbstractFile
extends AbstractFile {
    protected List<HexBlock> hexBlocks = new ArrayList<HexBlock>();

    InfocomAbstractFile(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getHexDump() {
        if (this.hexBlocks.size() > 0) {
            StringBuilder text = new StringBuilder();
            for (HexBlock hb : this.hexBlocks) {
                if (hb.title != null) {
                    text.append(String.valueOf(hb.title) + "\n\n");
                }
                text.append(String.valueOf(HexFormatter.format(this.buffer, hb.ptr, hb.size)) + "\n\n");
            }
            text.deleteCharAt(text.length() - 1);
            text.deleteCharAt(text.length() - 1);
            return text.toString();
        }
        if (this.buffer == null || this.buffer.length == 0) {
            return "No buffer";
        }
        if (this.buffer.length <= 99999) {
            return HexFormatter.format(this.buffer, 0, this.buffer.length);
        }
        return HexFormatter.format(this.buffer, 0, 99999);
    }

    protected class HexBlock {
        public int ptr;
        public int size;
        public String title;

        public HexBlock(int ptr, int size, String title) {
            this.ptr = ptr;
            this.size = size;
            this.title = title;
        }
    }
}

