/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.InfocomAbstractFile;
import com.bytezone.diskbrowser.infocom.Instruction;
import com.bytezone.diskbrowser.infocom.Routine;
import java.util.ArrayList;
import java.util.List;

class Globals
extends InfocomAbstractFile {
    private static final int TOTAL_GLOBALS = 240;
    private final Header header;
    private final int globalsPtr;
    private final int globalsSize;
    private final int arrayPtr;
    private final int arraySize;
    private final List<List<Routine>> globalRoutines;

    Globals(Header header) {
        super("Globals", header.buffer);
        this.header = header;
        this.globalsPtr = header.globalsOffset;
        this.globalsSize = 480;
        this.arrayPtr = this.globalsPtr + this.globalsSize;
        this.arraySize = header.staticMemory - this.arrayPtr;
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this, this.globalsPtr, this.globalsSize, "Globals:"));
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this, this.arrayPtr, this.arraySize, "Arrays:"));
        this.globalRoutines = new ArrayList<List<Routine>>(240);
        int i = 0;
        while (i < 240) {
            this.globalRoutines.add(new ArrayList());
            ++i;
        }
    }

    void addRoutine(Routine routine, Instruction.Operand operand) {
        List<Routine> list = this.globalRoutines.get(operand.value - 16);
        if (!list.contains(routine)) {
            list.add(routine);
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("GLB   Value   Routines\n");
        int i = 0;
        while (i < 240) {
            int value = this.header.getWord(this.globalsPtr + i * 2);
            text.append(String.format("G%03d    %04X      %03d     ", i, value, this.globalRoutines.get(i).size()));
            int address = value * 2;
            if (address >= this.header.stringPointer && address < this.header.fileLength) {
                text.append(String.valueOf(this.header.stringManager.stringAt(address)) + "\n");
            } else {
                for (Routine routine : this.globalRoutines.get(i)) {
                    text.append(String.format("%05X  ", routine.startPtr));
                }
                text.append("\n");
            }
            ++i;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

