/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZObject;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

class AttributeManager
extends AbstractFile {
    List<Statistic> list = new ArrayList<Statistic>();
    Header header;

    public AttributeManager(String name, byte[] buffer, Header header) {
        super(name, buffer);
        this.header = header;
        int attrNo = 0;
        while (attrNo < 32) {
            this.list.add(new Statistic(attrNo));
            ++attrNo;
        }
    }

    public void addNodes(DefaultMutableTreeNode node, FormattedDisk disk) {
        node.setAllowsChildren(true);
        int count = 0;
        for (Statistic stat : this.list) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(new DefaultAppleFileSource("Attribute " + count++, stat.getText(), disk));
            node.add(child);
            child.setAllowsChildren(false);
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Attribute  Frequency\n");
        text.append("---------  ---------\n");
        for (Statistic stat : this.list) {
            text.append(String.format("%s%n", stat));
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private class Statistic {
        int id;
        List<ZObject> list = new ArrayList<ZObject>();

        public Statistic(int id) {
            this.id = id;
            for (ZObject o : AttributeManager.this.header.objectManager) {
                if (!o.attributes.get(id)) continue;
                this.list.add(o);
            }
        }

        String getText() {
            StringBuilder text = new StringBuilder("Objects with attribute " + this.id + " set:\n\n");
            for (ZObject o : this.list) {
                text.append(String.format("%3d  %-28s%n", o.getId(), o.getName()));
            }
            if (text.length() > 0) {
                text.deleteCharAt(text.length() - 1);
            }
            return text.toString();
        }

        public String toString() {
            return String.format("   %2d        %3d", this.id, this.list.size());
        }
    }
}

