/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.InfocomAbstractFile;
import com.bytezone.diskbrowser.infocom.ZString;
import java.util.ArrayList;
import java.util.List;

class Abbreviations
extends InfocomAbstractFile {
    List<ZString> list;
    Header header;
    int dataPtr;
    int dataSize;
    int tablePtr;
    int tableSize;

    Abbreviations(Header header) {
        super("Abbreviations", header.buffer);
        this.header = header;
        this.dataPtr = header.getWord(header.abbreviationsTable) * 2;
        this.dataSize = header.abbreviationsTable - this.dataPtr;
        this.tablePtr = header.abbreviationsTable;
        this.tableSize = header.objectTableOffset - header.abbreviationsTable;
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this, this.dataPtr, this.dataSize, "Abbreviations data:"));
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this, this.tablePtr, this.tableSize, "Abbreviations table:"));
    }

    private void populate() {
        this.list = new ArrayList<ZString>();
        int i = this.header.abbreviationsTable;
        while (i < this.header.objectTableOffset) {
            this.list.add(new ZString(this.header, this.header.getWord(i) * 2));
            i += 2;
        }
    }

    String getAbbreviation(int abbreviationNumber) {
        if (this.list == null) {
            this.populate();
        }
        return this.list.get((int)abbreviationNumber).value;
    }

    @Override
    public String getText() {
        if (this.list == null) {
            this.populate();
        }
        StringBuilder text = new StringBuilder();
        int count = 0;
        for (ZString word : this.list) {
            text.append(String.format("%3d  %s%n", count++, word.value));
        }
        if (this.list.size() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }
}

