/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.gui.FileComparator;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

class TreeBuilder {
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd LLL yyyy");
    private final FileComparator fileComparator = new FileComparator();
    private final JTree tree;

    TreeBuilder(File rootFolder) {
        assert (rootFolder.exists());
        assert (rootFolder.isDirectory());
        FileNode fileNode = new FileNode(rootFolder);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(fileNode);
        fileNode.setTreeNode(root);
        this.addFiles(root, rootFolder);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel);
        treeModel.setAsksAllowsChildren(true);
        this.setDiskIcon("/com/bytezone/diskbrowser/icons/disk.png");
    }

    JTree getTree() {
        return this.tree;
    }

    private void addFiles(DefaultMutableTreeNode parentNode, File directory) {
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            System.out.println("Empty folder : " + directory.getAbsolutePath());
            return;
        }
        Arrays.sort(files, this.fileComparator);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isHidden()) {
                if (file.isDirectory()) {
                    parentNode.add(this.createNode(file, true));
                } else if (Utility.validFileType(file.getName()) && file.length() > 0L) {
                    parentNode.add(this.createNode(file, false));
                }
            }
            ++n2;
        }
    }

    private DefaultMutableTreeNode createNode(File file, boolean allowsChildren) {
        FileNode fileNode = new FileNode(file);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(fileNode);
        fileNode.setTreeNode(newNode);
        newNode.setAllowsChildren(allowsChildren);
        return newNode;
    }

    private void setDiskIcon(String iconName) {
        URL url = this.getClass().getResource(iconName);
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
            renderer.setLeafIcon(icon);
            this.tree.setCellRenderer(renderer);
            this.tree.setRowHeight(18);
        } else {
            System.out.println("Failed to set the disk icon : " + iconName);
        }
    }

    class FileNode
    implements DataSource {
        private static final int MAX_NAME_LENGTH = 36;
        private static final int SUFFIX_LENGTH = 12;
        private static final int PREFIX_LENGTH = 21;
        DefaultMutableTreeNode parentNode;
        public final File file;
        private FormattedDisk formattedDisk;
        int disks;
        boolean showDisks;

        FileNode(File file) {
            this.file = file;
        }

        void setTreeNode(DefaultMutableTreeNode node) {
            this.parentNode = node;
        }

        void readFiles() {
            TreeBuilder.this.addFiles(this.parentNode, this.file);
        }

        FormattedDisk getFormattedDisk() {
            if (this.formattedDisk == null) {
                try {
                    this.formattedDisk = DiskFactory.createDisk(this.file);
                }
                catch (FileFormatException e) {
                    System.out.println("Swallowing a FileFormatException in TreeBuilder");
                    System.out.println(e.getMessage());
                    return null;
                }
            }
            return this.formattedDisk;
        }

        boolean replaceDisk(FormattedDisk disk) {
            String path = disk.getDisk().getFile().getAbsolutePath();
            if (this.formattedDisk != null && path.equals(this.file.getAbsolutePath())) {
                this.formattedDisk = disk;
                return true;
            }
            return false;
        }

        public String toString() {
            String name = this.file.getName();
            if (name.length() > 36) {
                name = String.valueOf(name.substring(0, 21)) + "..." + name.substring(name.length() - 12);
            }
            if (this.showDisks && this.disks > 0) {
                return String.format("%s (%,d)", name, this.disks);
            }
            return name;
        }

        @Override
        public String getText() {
            StringBuilder text = new StringBuilder();
            String home = System.getProperty("user.home");
            String path = this.file.getAbsolutePath();
            if (path.startsWith(home)) {
                path = "~" + path.substring(home.length());
            }
            text.append("Directory : " + path + "\n\n");
            text.append("D         File names                             Date               Size  Type\n");
            text.append("-  ----------------------------------------  -----------  --------------  ---------\n");
            File[] files = this.file.listFiles();
            if (files != null) {
                Arrays.sort(files, TreeBuilder.this.fileComparator);
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.isHidden()) {
                        String name = f.getName();
                        Date d = new Date(f.lastModified());
                        int pos = name.lastIndexOf(46);
                        String type = pos > 0 && !f.isDirectory() ? name.substring(pos) : "";
                        String size = f.isDirectory() ? "" : String.format("%,14d", f.length());
                        text.append(String.format("%s  %-40.40s  %s  %-14s  %s%n", f.isDirectory() ? "D" : " ", name, sdf.format(d), size, type));
                    }
                    ++n2;
                }
            }
            if (text.length() > 0) {
                text.deleteCharAt(text.length() - 1);
            }
            return text.toString();
        }

        @Override
        public String getAssembler() {
            return null;
        }

        @Override
        public String getHexDump() {
            return null;
        }

        @Override
        public BufferedImage getImage() {
            return null;
        }

        @Override
        public byte[] getBuffer() {
            return null;
        }

        @Override
        public JComponent getComponent() {
            return null;
        }
    }
}

