/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorListConverter;
import java.util.EventObject;
import java.util.List;

class SectorSelectedEvent
extends EventObject {
    private final List<DiskAddress> sectors;
    private final FormattedDisk owner;
    boolean redo;

    SectorSelectedEvent(Object source, List<DiskAddress> sectors, FormattedDisk owner) {
        super(source);
        this.sectors = sectors;
        this.owner = owner.getParent() == null ? owner : owner.getParent();
    }

    public List<DiskAddress> getSectors() {
        return this.sectors;
    }

    public FormattedDisk getFormattedDisk() {
        return this.owner;
    }

    public String toText() {
        StringBuilder text = new StringBuilder();
        SectorListConverter sectorListConverter = new SectorListConverter(this.sectors);
        text.append(sectorListConverter.sectorText);
        return text.toString();
    }

    public static SectorSelectedEvent create(Object source, FormattedDisk owner, String sectorsText) {
        if (sectorsText.startsWith("$")) {
            sectorsText = sectorsText.substring(3);
        }
        SectorListConverter slc = new SectorListConverter(sectorsText, owner.getDisk());
        return new SectorSelectedEvent(source, slc.sectors, owner);
    }
}

