/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.gui.DiskLayoutImage;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import com.bytezone.diskbrowser.utilities.FontUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

class ScrollRuler
extends JComponent {
    public static final int HEIGHT = 20;
    public static final int WIDTH = 40;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private final Font font = FontUtility.getFont(FontUtility.FontType.SANS_SERIF, FontUtility.FontSize.BASE);
    private final int orientation;
    private boolean isHex = true;
    private boolean isTrackMode = true;
    private DiskLayoutPanel.LayoutDetails layoutDetails;
    private final DiskLayoutImage diskLayoutImage;

    ScrollRuler(DiskLayoutImage diskLayoutImage, int orientation) {
        this.orientation = orientation;
        this.diskLayoutImage = diskLayoutImage;
        if (orientation == 0) {
            this.setPreferredSize(new Dimension(0, 20));
        } else {
            this.setPreferredSize(new Dimension(40, 0));
        }
    }

    public void setLayout(DiskLayoutPanel.LayoutDetails layoutDetails) {
        this.layoutDetails = layoutDetails;
        if (this.orientation == 0) {
            this.setPreferredSize(new Dimension(layoutDetails.block.width * layoutDetails.grid.width + 1, 20));
        } else {
            this.setPreferredSize(new Dimension(40, layoutDetails.block.height * layoutDetails.grid.height + 1));
        }
        this.setTrackMode(layoutDetails.grid.width == 16 || layoutDetails.grid.width == 13);
    }

    public void setTrackMode(boolean trackMode) {
        this.isTrackMode = trackMode;
        this.repaint();
    }

    public void setHex(boolean hex) {
        this.isHex = hex;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        g.setColor(Color.WHITE);
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        if (this.layoutDetails == null) {
            return;
        }
        g.setFont(this.font);
        g.setColor(Color.black);
        if (this.orientation == 0) {
            this.drawHorizontal(g, clipRect, this.layoutDetails.block.width);
        } else {
            this.drawVertical(g, clipRect, this.layoutDetails.block.height);
        }
    }

    private void drawHorizontal(Graphics g, Rectangle clipRect, int width) {
        int offset;
        String format;
        int start = clipRect.x / width;
        int end = start + clipRect.width / width;
        end = Math.min(end, this.diskLayoutImage.getWidth() / width - 1);
        if (this.layoutDetails.block.width <= 16) {
            format = this.isHex ? "%1X" : "%1d";
            offset = this.isHex ? 4 : 0;
        } else {
            format = this.isHex ? "%02X" : "%02d";
            offset = 7;
        }
        int i = start;
        while (i <= end) {
            g.drawString(String.format(format, i), i * width + offset, 15);
            ++i;
        }
    }

    private void drawVertical(Graphics g, Rectangle clipRect, int height) {
        int start = clipRect.y / height;
        int end = start + clipRect.height / height;
        end = Math.min(end, this.diskLayoutImage.getHeight() / height - 1);
        String format = this.isHex ? "%04X" : "%04d";
        int i = start;
        while (i <= end) {
            int value = this.isTrackMode ? i : i * this.layoutDetails.grid.width;
            g.drawString(String.format(format, value), 4, i * height + 13);
            ++i;
        }
    }
}

