/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.gui.AbstractSaveAction;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;

class SaveSectorsAction
extends AbstractSaveAction
implements SectorSelectionListener {
    SectorSelectedEvent event;

    SaveSectorsAction() {
        super("Save sectors...", "Save currently selected sectors", "Save sectors");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.event == null) {
            JOptionPane.showMessageDialog(null, "No sectors selected");
            return;
        }
        List<DiskAddress> blocks = this.event.getSectors();
        Disk disk = this.event.getFormattedDisk().getDisk();
        byte[] buffer = blocks.size() == 1 ? disk.readBlock(blocks.get(0)) : disk.readBlocks(blocks);
        this.setSelectedFile(new File("SavedSectors.bin"));
        this.saveBuffer(buffer);
    }

    @Override
    public void sectorSelected(SectorSelectedEvent event) {
        this.event = event;
        this.setEnabled(true);
    }
}

