/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.gui.QuitListener;
import com.bytezone.diskbrowser.utilities.DefaultAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

class RootDirectoryAction
extends DefaultAction
implements QuitListener {
    private static final String prefsRootDirectory = "Root directory";
    private File rootFolder;

    RootDirectoryAction() {
        super("Set HOME folder...", "Defines root folder where the disk images are kept", "/com/bytezone/diskbrowser/icons/");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt H"));
        this.putValue("MnemonicKey", 72);
        this.setIcon("SmallIcon", "folder_explore_16.png");
        this.setIcon("SwingLargeIconKey", "folder_explore_32.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
        chooser.setDialogTitle("Select FOLDER containing disk images");
        chooser.setFileSelectionMode(1);
        if (this.rootFolder != null) {
            chooser.setSelectedFile(this.rootFolder);
        }
        if ((result = chooser.showDialog(null, "Accept")) == 0) {
            File rootDirectoryFile = chooser.getSelectedFile();
            if (!rootDirectoryFile.isDirectory()) {
                rootDirectoryFile = rootDirectoryFile.getParentFile();
            }
            if (rootDirectoryFile != null) {
                this.notifyListeners(rootDirectoryFile);
            }
        }
    }

    @Override
    public void quit(Preferences prefs) {
        prefs.put(prefsRootDirectory, this.rootFolder == null ? "" : this.rootFolder.getAbsolutePath());
    }

    @Override
    public void restore(Preferences prefs) {
        File rootDirectoryFile = new File(prefs.get(prefsRootDirectory, ""));
        if (!rootDirectoryFile.exists() || !rootDirectoryFile.isDirectory()) {
            System.out.println("No root directory");
            return;
        }
        this.notifyListeners(rootDirectoryFile);
    }

    private void notifyListeners(File newRootFolder) {
        File oldRootFolder = this.rootFolder;
        this.rootFolder = newRootFolder;
        this.firePropertyChange("RootDirectory", oldRootFolder, newRootFolder);
    }
}

