/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileNodeSelectedEvent;
import com.bytezone.diskbrowser.gui.FileNodeSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

class RedoHandler
implements FileSelectionListener,
DiskSelectionListener,
SectorSelectionListener,
FileNodeSelectionListener {
    private static final String base = "/com/bytezone/diskbrowser/icons/";
    EventListenerList listenerList = new EventListenerList();
    Action leftAction = new LeftAction();
    Action rightAction = new RightAction();
    RedoData redoData = new RedoData(this.leftAction, this.rightAction);
    static int id = 0;

    public RedoHandler(JRootPane jRootPane, JToolBar toolBar) {
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 512), "LeftAction");
        actionMap.put("LeftAction", this.leftAction);
        inputMap.put(KeyStroke.getKeyStroke(39, 512), "RightAction");
        actionMap.put("RightAction", this.rightAction);
        toolBar.add(this.leftAction);
        toolBar.add(this.rightAction);
    }

    public RedoData createData() {
        RedoData data;
        this.redoData = data = new RedoData(this.leftAction, this.rightAction);
        return data;
    }

    public void setCurrentData(RedoData data) {
        this.redoData = data;
        RedoEvent event = this.redoData.getCurrentEvent();
        if (event != null) {
            this.fireRedoEvent(event);
        }
    }

    private void fireRedoEvent(RedoEvent event) {
        RedoListener[] listeners;
        RedoListener[] redoListenerArray = listeners = (RedoListener[])this.listenerList.getListeners(RedoListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            RedoListener listener = redoListenerArray[n2];
            listener.redo(event);
            ++n2;
        }
    }

    public void addRedoListener(RedoListener listener) {
        this.listenerList.add(RedoListener.class, listener);
    }

    public void removeRedoListener(RedoListener listener) {
        this.listenerList.remove(RedoListener.class, listener);
    }

    @Override
    public void diskSelected(DiskSelectedEvent event) {
        if (!event.redo) {
            this.addEvent(new RedoEvent("DiskEvent", event));
        }
    }

    @Override
    public void fileNodeSelected(FileNodeSelectedEvent event) {
        if (!event.redo) {
            this.addEvent(new RedoEvent("FileNodeEvent", event));
        }
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        if (!event.redo) {
            this.addEvent(new RedoEvent("FileEvent", event));
        }
    }

    @Override
    public void sectorSelected(SectorSelectedEvent event) {
        if (!event.redo) {
            this.addEvent(new RedoEvent("SectorEvent", event));
        }
    }

    private void addEvent(RedoEvent event) {
        this.redoData.addEvent(event);
    }

    class LeftAction
    extends AbstractAction {
        public LeftAction() {
            super("Back");
            this.putValue("ShortDescription", "Undo selection");
            URL url = this.getClass().getResource("/com/bytezone/diskbrowser/icons/Symbol-Left-32.png");
            if (url != null) {
                this.putValue("SwingLargeIconKey", new ImageIcon(url));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RedoHandler.this.fireRedoEvent(RedoHandler.this.redoData.getPreviousEvent());
        }
    }

    class RedoData {
        List<RedoEvent> events = new ArrayList<RedoEvent>();
        int currentEvent = -1;
        Action leftAction;
        Action rightAction;
        final int seq = id++;

        public RedoData(Action left, Action right) {
            this.leftAction = left;
            this.rightAction = right;
            this.setArrows();
        }

        RedoEvent getCurrentEvent() {
            if (this.currentEvent < 0) {
                return null;
            }
            this.setArrows();
            return this.events.get(this.currentEvent);
        }

        RedoEvent getNextEvent() {
            RedoEvent event = this.events.get(++this.currentEvent);
            this.setArrows();
            return event;
        }

        RedoEvent getPreviousEvent() {
            RedoEvent event = this.events.get(--this.currentEvent);
            this.setArrows();
            return event;
        }

        void addEvent(RedoEvent event) {
            while (this.currentEvent < this.events.size() - 1) {
                this.events.remove(this.events.size() - 1);
            }
            ++this.currentEvent;
            this.events.add(event);
            this.setArrows();
        }

        private void setArrows() {
            this.rightAction.setEnabled(this.currentEvent < this.events.size() - 1);
            this.leftAction.setEnabled(this.currentEvent > 0);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append("Current event (" + this.seq + ") : " + this.currentEvent + "\n");
            for (RedoEvent event : this.events) {
                text.append("  - " + event + "\n");
            }
            return text.toString();
        }
    }

    public class RedoEvent
    extends EventObject {
        String type;
        EventObject value;

        public RedoEvent(String type, EventObject value) {
            super(RedoHandler.this);
            this.type = type;
            this.value = value;
        }

        @Override
        public String toString() {
            return "[type=" + this.type + ", value=" + this.value + "]";
        }
    }

    public static interface RedoListener
    extends EventListener {
        public void redo(RedoEvent var1);
    }

    class RightAction
    extends AbstractAction {
        public RightAction() {
            super("Forward");
            this.putValue("ShortDescription", "Redo selection");
            URL url = this.getClass().getResource("/com/bytezone/diskbrowser/icons/Symbol-Right-32.png");
            if (url != null) {
                this.putValue("SwingLargeIconKey", new ImageIcon(url));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RedoHandler.this.fireRedoEvent(RedoHandler.this.redoData.getNextEvent());
        }
    }
}

