/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Vector;

class PrintDocument
extends Component
implements Printable {
    String[] lines;
    int lineHeight;
    int pages;
    Font font = new Font("Lucida Sans Typewriter", 0, 7);
    int linesPerPage;
    int x = 50;
    int y = 20;

    PrintDocument(String text) {
        this.lines = PrintDocument.wrapText(text, 112);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.lineHeight == 0) {
            LineMetrics lm = this.font.getLineMetrics("0", g2.getFontRenderContext());
            this.lineHeight = (int)lm.getHeight();
            this.linesPerPage = (int)pageFormat.getImageableHeight() / this.lineHeight - 5;
            this.pages = (this.lines.length - 1) / this.linesPerPage;
        }
        if (this.pages < page) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.setPaint(Color.black);
        g2.setStroke(new BasicStroke(2.0f));
        g2.setFont(this.font);
        int first = page * this.linesPerPage;
        int last = first + this.linesPerPage;
        if (last > this.lines.length) {
            last = this.lines.length;
        }
        int line = first;
        while (line < last) {
            g2.drawString(this.lines[line], this.x, this.y + (line % this.linesPerPage + 2) * this.lineHeight);
            ++line;
        }
        return 0;
    }

    static String[] wrapText(String text, int len) {
        if (text == null) {
            return new String[0];
        }
        if (len <= 0) {
            return new String[]{text};
        }
        if (text.length() <= len) {
            return new String[]{text};
        }
        char[] chars = text.toCharArray();
        Vector<String> lines = new Vector<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\n') {
                line.append((CharSequence)word);
                word.delete(0, word.length());
                lines.add(line.toString());
                line.delete(0, line.length());
            } else {
                word.append(chars[i]);
                if (chars[i] == ' ') {
                    if (line.length() + word.length() > len) {
                        lines.add(line.toString());
                        line.delete(0, line.length());
                    }
                    line.append((CharSequence)word);
                    word.delete(0, word.length());
                }
            }
            ++i;
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        String[] ret = new String[lines.size()];
        int c = 0;
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            ret[c] = (String)e.nextElement();
            ++c;
        }
        return ret;
    }
}

