/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.gui.OutputPanel;
import com.bytezone.diskbrowser.gui.PrintDocument;
import com.bytezone.diskbrowser.utilities.DefaultAction;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.KeyStroke;

class PrintAction
extends DefaultAction {
    OutputPanel owner;

    public PrintAction(OutputPanel owner) {
        super("Print...", "Print the contents of the output panel", "/com/bytezone/diskbrowser/icons/");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, mask));
        this.owner = owner;
        this.setIcon("SmallIcon", "printer_16.png");
        this.setIcon("SwingLargeIconKey", "printer_32.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setPrintable(new PrintDocument(PrintAction.this.owner.getCurrentText()));
                    if (job.printDialog()) {
                        job.print();
                    }
                }
                catch (PrinterException e) {
                    System.out.println("printer error");
                }
            }
        };
        EventQueue.invokeLater(runner);
    }
}

