/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BasicTextFile;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.Palette;
import com.bytezone.diskbrowser.applefile.PaletteFactory;
import com.bytezone.diskbrowser.applefile.QuickDrawFont;
import com.bytezone.diskbrowser.applefile.SHRPictureFile2;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.SectorList;
import com.bytezone.diskbrowser.gui.AnimationWorker;
import com.bytezone.diskbrowser.gui.AssemblerPreferences;
import com.bytezone.diskbrowser.gui.AssemblerPreferencesListener;
import com.bytezone.diskbrowser.gui.BasicPreferences;
import com.bytezone.diskbrowser.gui.BasicPreferencesListener;
import com.bytezone.diskbrowser.gui.ColourQuirksAction;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.gui.DebuggingAction;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileNodeSelectedEvent;
import com.bytezone.diskbrowser.gui.FileNodeSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.FontAction;
import com.bytezone.diskbrowser.gui.ImagePanel;
import com.bytezone.diskbrowser.gui.LineWrapAction;
import com.bytezone.diskbrowser.gui.MenuHandler;
import com.bytezone.diskbrowser.gui.MonochromeAction;
import com.bytezone.diskbrowser.gui.NextPaletteAction;
import com.bytezone.diskbrowser.gui.PaletteAction;
import com.bytezone.diskbrowser.gui.PreviousPaletteAction;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import com.bytezone.diskbrowser.gui.TextPreferences;
import com.bytezone.diskbrowser.gui.TextPreferencesListener;
import com.bytezone.diskbrowser.wizardry.MazeLevel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OutputPanel
extends JTabbedPane
implements DiskSelectionListener,
FileSelectionListener,
SectorSelectionListener,
FileNodeSelectionListener,
FontAction.FontChangeListener,
BasicPreferencesListener,
AssemblerPreferencesListener,
TextPreferencesListener,
PropertyChangeListener {
    private static final int TEXT_WIDTH = 65;
    private final JTextArea formattedText;
    private final JTextArea hexText;
    private final JTextArea disassemblyText;
    private final JScrollPane formattedPane;
    private final JScrollPane imagePane;
    private boolean imageVisible = false;
    private final ImagePanel imagePanel = new ImagePanel();
    private AnimationWorker animation;
    private boolean debugMode;
    private DataSource currentDataSource;
    private boolean formattedTextValid;
    private boolean hexTextValid;
    private boolean assemblerTextValid;
    private DebuggingAction debuggingAction = new DebuggingAction();
    private MonochromeAction monochromeAction = new MonochromeAction();
    private ColourQuirksAction colourQuirksAction = new ColourQuirksAction();
    private LineWrapAction lineWrapAction = new LineWrapAction();

    public OutputPanel(MenuHandler menuHandler) {
        this.setTabPlacement(3);
        this.formattedText = new JTextArea(10, 65);
        this.formattedPane = this.setPanel(this.formattedText, "Formatted");
        this.formattedText.setText("Please use the 'File->Set HOME folder...' command to \ntell DiskBrowser where your Apple disks are located.\n\nTo see the contents of a disk in more detail, double-click\nthe disk. You will then be able to select individual files to view them.");
        this.hexText = new JTextArea(10, 65);
        this.setPanel(this.hexText, "Hex dump");
        this.disassemblyText = new JTextArea(10, 65);
        this.setPanel(this.disassemblyText, "Disassembly");
        this.imagePane = new JScrollPane(this.imagePanel, 22, 30);
        this.imagePane.setBorder(null);
        this.imagePane.getVerticalScrollBar().setUnitIncrement(50);
        this.imagePane.getHorizontalScrollBar().setUnitIncrement(25);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                switch (OutputPanel.this.getSelectedIndex()) {
                    case 0: {
                        if (OutputPanel.this.formattedTextValid) break;
                        if (OutputPanel.this.currentDataSource == null) {
                            OutputPanel.this.formattedText.setText("");
                        } else {
                            OutputPanel.this.setText(OutputPanel.this.formattedText, OutputPanel.this.currentDataSource.getText());
                        }
                        OutputPanel.this.formattedTextValid = true;
                        break;
                    }
                    case 1: {
                        if (OutputPanel.this.hexTextValid) break;
                        if (OutputPanel.this.currentDataSource == null) {
                            OutputPanel.this.hexText.setText("");
                        } else {
                            OutputPanel.this.setText(OutputPanel.this.hexText, OutputPanel.this.currentDataSource.getHexDump());
                        }
                        OutputPanel.this.hexTextValid = true;
                        break;
                    }
                    case 2: {
                        if (OutputPanel.this.assemblerTextValid) break;
                        if (OutputPanel.this.currentDataSource == null) {
                            OutputPanel.this.disassemblyText.setText("");
                        } else {
                            OutputPanel.this.setText(OutputPanel.this.disassemblyText, OutputPanel.this.currentDataSource.getAssembler());
                        }
                        OutputPanel.this.assemblerTextValid = true;
                        break;
                    }
                    default: {
                        System.out.println("Impossible - Invalid index selected in DataPanel");
                    }
                }
            }
        });
        menuHandler.lineWrapItem.setAction(this.lineWrapAction);
        this.lineWrapAction.addPropertyChangeListener(this);
        this.colourQuirksAction.addPropertyChangeListener(this);
        menuHandler.colourQuirksItem.setAction(this.colourQuirksAction);
        this.monochromeAction.addPropertyChangeListener(this);
        menuHandler.monochromeItem.setAction(this.monochromeAction);
        this.debuggingAction.addPropertyChangeListener(this);
        menuHandler.debuggingItem.setAction(this.debuggingAction);
        List<Palette> palettes = HiResImage.getPalettes();
        ButtonGroup buttonGroup = menuHandler.paletteGroup;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int ndx = 0;
        while (enumeration.hasMoreElements()) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)enumeration.nextElement();
            item.setAction(new PaletteAction(this, palettes.get(ndx++)));
        }
        menuHandler.nextPaletteItem.setAction(new NextPaletteAction(this, buttonGroup));
        menuHandler.prevPaletteItem.setAction(new PreviousPaletteAction(this, buttonGroup));
    }

    /*
     * WARNING - void declaration
     */
    public void selectPalette(Palette palette) {
        void var3_2;
        HiResImage hiResImage;
        HiResImage.getPaletteFactory().setCurrentPalette(palette);
        DataSource dataSource = this.currentDataSource;
        if (dataSource instanceof HiResImage && (hiResImage = (HiResImage)dataSource) == (HiResImage)var3_2) {
            void image;
            image.setPalette();
            this.imagePanel.setImage(image.getImage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Palette cyclePalette(PaletteFactory.CycleDirection direction) {
        Palette palette = HiResImage.getPaletteFactory().cyclePalette(direction);
        DataSource dataSource = this.currentDataSource;
        if (dataSource instanceof HiResImage var3_4) {
            void image;
            image.setPalette();
            this.imagePanel.setImage(image.getImage());
        }
        return palette;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.debuggingAction) {
            this.setDebug((Boolean)evt.getNewValue());
        } else if (evt.getSource() == this.monochromeAction) {
            this.setMonochrome((Boolean)evt.getNewValue());
        } else if (evt.getSource() == this.colourQuirksAction) {
            this.setColourQuirks((Boolean)evt.getNewValue());
        } else if (evt.getSource() == this.lineWrapAction) {
            this.setLineWrap((Boolean)evt.getNewValue());
        }
    }

    void setLineWrap(boolean lineWrap) {
        this.formattedText.setLineWrap(lineWrap);
    }

    /*
     * WARNING - void declaration
     */
    public void setColourQuirks(boolean value) {
        void var3_2;
        HiResImage hiResImage;
        DataSource dataSource = this.currentDataSource;
        if (dataSource instanceof HiResImage && (hiResImage = (HiResImage)dataSource) == (HiResImage)var3_2) {
            void image;
            image.setColourQuirks(value);
            this.imagePanel.setImage(image.getImage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMonochrome(boolean value) {
        void var3_2;
        HiResImage hiResImage;
        DataSource dataSource = this.currentDataSource;
        if (dataSource instanceof HiResImage && (hiResImage = (HiResImage)dataSource) == (HiResImage)var3_2) {
            void image;
            image.setMonochrome(value);
            this.imagePanel.setImage(image.getImage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setScale(double scale) {
        this.imagePanel.setScale(scale);
        DataSource dataSource = this.currentDataSource;
        if (dataSource instanceof HiResImage var3_3) {
            void image;
            this.imagePanel.setImage(image.getImage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void update() {
        void var2_1;
        HiResImage hiResImage;
        DataSource dataSource = this.currentDataSource;
        if (dataSource instanceof HiResImage && (hiResImage = (HiResImage)dataSource) == (HiResImage)var2_1) {
            void image;
            this.imagePanel.setImage(image.getImage());
        }
    }

    public void setDebug(boolean value) {
        this.debugMode = value;
        AbstractFile.setDebug(value);
        this.setText(this.formattedText, this.currentDataSource.getText());
        if (this.currentDataSource instanceof HiResImage || this.currentDataSource instanceof MazeLevel || this.currentDataSource instanceof QuickDrawFont) {
            this.setDataSource(this.currentDataSource);
        }
    }

    private void setTabsFont(Font font) {
        this.formattedText.setFont(font);
        this.hexText.setFont(font);
        this.disassemblyText.setFont(font);
        this.imagePane.getVerticalScrollBar().setUnitIncrement(font.getSize());
    }

    public String getCurrentText() {
        int index = this.getSelectedIndex();
        return index == 0 ? this.formattedText.getText() : (index == 1 ? this.hexText.getText() : this.disassemblyText.getText());
    }

    private JScrollPane setPanel(JTextArea outputPanel, String tabName) {
        outputPanel.setEditable(false);
        outputPanel.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane outputScrollPane = new JScrollPane(outputPanel, 22, 30);
        outputScrollPane.setBorder(null);
        this.add((Component)outputScrollPane, tabName);
        return outputScrollPane;
    }

    private void setDataSource(DataSource dataSource) {
        this.currentDataSource = dataSource;
        if (dataSource == null) {
            this.formattedText.setText("");
            this.hexText.setText("");
            this.disassemblyText.setText("");
            this.removeImage();
            return;
        }
        switch (TabType.values()[this.getSelectedIndex()]) {
            case FORMATTED: {
                try {
                    this.setText(this.formattedText, dataSource.getText());
                }
                catch (Exception e) {
                    this.setText(this.formattedText, e.toString());
                    e.printStackTrace();
                }
                this.hexTextValid = false;
                this.assemblerTextValid = false;
                break;
            }
            case HEX: {
                this.setText(this.hexText, dataSource.getHexDump());
                this.formattedTextValid = false;
                this.assemblerTextValid = false;
                break;
            }
            case DISASSEMBLED: {
                this.setText(this.disassemblyText, dataSource.getAssembler());
                this.hexTextValid = false;
                this.formattedTextValid = false;
                break;
            }
            default: {
                System.out.println("Unexpected Tab #" + this.getSelectedIndex());
            }
        }
        BufferedImage image = dataSource.getImage();
        if (image == null || this.debugMode) {
            this.removeImage();
        } else {
            if (dataSource instanceof HiResImage var3_5) {
                hri.checkPalette();
                image = dataSource.getImage();
                if (((HiResImage)dataSource).isAnimation()) {
                    if (this.animation != null) {
                        this.animation.cancel();
                    }
                    this.animation = new AnimationWorker(this, (SHRPictureFile2)dataSource);
                    this.animation.execute();
                }
            }
            this.imagePanel.setImage(image);
            this.imagePane.setViewportView(this.imagePanel);
            if (!this.imageVisible) {
                int selected = this.getSelectedIndex();
                this.remove(this.formattedPane);
                this.add(this.imagePane, "Formatted", 0);
                this.setSelectedIndex(selected);
                this.imageVisible = true;
            }
        }
    }

    private void removeImage() {
        if (this.imageVisible) {
            int selected = this.getSelectedIndex();
            this.remove(this.imagePane);
            this.add(this.formattedPane, "Formatted", 0);
            this.setSelectedIndex(selected);
            this.imageVisible = false;
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }

    private void setText(JTextArea textArea, String text) {
        textArea.setText(text);
        textArea.setCaretPosition(0);
    }

    @Override
    public void diskSelected(DiskSelectedEvent event) {
        this.setSelectedIndex(0);
        this.setDataSource(null);
        if (event.getFormattedDisk() != null) {
            this.setDataSource(event.getFormattedDisk().getCatalog().getDataSource());
        } else {
            System.out.println("bollocks in diskSelected()");
        }
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        DataSource dataSource = event.appleFileSource.getDataSource();
        this.setDataSource(dataSource);
    }

    @Override
    public void sectorSelected(SectorSelectedEvent event) {
        List<DiskAddress> sectors = event.getSectors();
        if (sectors == null || sectors.size() == 0) {
            return;
        }
        if (sectors.size() == 1) {
            DiskAddress da = sectors.get(0);
            if (da != null) {
                this.setDataSource(event.getFormattedDisk().getFormattedSector(da));
            }
        } else {
            this.setDataSource(new SectorList(event.getFormattedDisk(), sectors));
        }
    }

    @Override
    public void fileNodeSelected(FileNodeSelectedEvent event) {
        this.setSelectedIndex(0);
        this.setDataSource(event.getFileNode());
    }

    @Override
    public void changeFont(FontAction.FontChangeEvent fontChangeEvent) {
        this.setTabsFont(fontChangeEvent.font);
    }

    @Override
    public void setBasicPreferences(BasicPreferences basicPreferences) {
        if (this.currentDataSource instanceof ApplesoftBasicProgram) {
            this.setDataSource(this.currentDataSource);
        }
    }

    @Override
    public void setAssemblerPreferences(AssemblerPreferences assemblerPreferences) {
        if (this.currentDataSource instanceof AssemblerProgram || this.currentDataSource instanceof BootSector) {
            this.setDataSource(this.currentDataSource);
        }
    }

    @Override
    public void setTextPreferences(TextPreferences textPreferences) {
        if (this.currentDataSource instanceof BasicTextFile) {
            this.setDataSource(this.currentDataSource);
        }
    }

    private static enum TabType {
        FORMATTED,
        HEX,
        DISASSEMBLED;

    }
}

