/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.Palette;
import com.bytezone.diskbrowser.applefile.PaletteFactory;
import com.bytezone.diskbrowser.gui.OutputPanel;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;

class NextPaletteAction
extends AbstractAction {
    private final OutputPanel owner;
    private final ButtonGroup buttonGroup;

    NextPaletteAction(OutputPanel owner, ButtonGroup buttonGroup) {
        super("Next Palette");
        this.putValue("ShortDescription", "Select next color palette");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("meta alt N"));
        this.owner = owner;
        this.buttonGroup = buttonGroup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Palette palette = this.owner.cyclePalette(PaletteFactory.CycleDirection.FORWARDS);
        if (palette != null) {
            Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)enumeration.nextElement();
                if (!item.getText().equals(palette.getName())) continue;
                item.setSelected(true);
                break;
            }
        }
    }
}

