/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.gui.FontFrame;
import com.bytezone.diskbrowser.gui.QuitListener;
import com.bytezone.diskbrowser.utilities.DefaultAction;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class FontAction
extends DefaultAction
implements QuitListener {
    private static final String prefsFontName = "prefsFontName";
    private static final String prefsFontSize = "prefsFontSize";
    private static Canvas canvas;
    private final EventListenerList listenerList = new EventListenerList();
    private FontFrame frame;
    private String fontName;
    private String fontSize;
    private String text;

    public FontAction() {
        super("Set Font...", "Set display to a different font or font size", "/com/bytezone/loadlister/");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, mask));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.frame == null) {
            this.frame = new FontFrame(this);
            this.frame.setSelectedValue(this.fontName);
            this.frame.setSelectedSize(this.fontSize);
            this.frame.setText(this.text);
        }
        this.frame.setVisible(true);
    }

    @Override
    public void quit(Preferences preferences) {
        if (this.frame != null) {
            String fontName = this.frame.getSelectedValue();
            preferences.put(prefsFontName, fontName == null ? "Monospaced" : fontName);
            String fontSize = this.frame.getSelectedSize();
            preferences.put(prefsFontSize, fontSize == null ? "12 point" : fontSize);
        }
    }

    @Override
    public void restore(Preferences preferences) {
        String fontSize;
        String fontName = preferences.get(prefsFontName, "Monospaced");
        if (fontName.isEmpty()) {
            fontName = "Monospaced";
        }
        this.fontName = fontName;
        if (this.frame != null) {
            this.frame.setSelectedValue(fontName);
        }
        if ((fontSize = preferences.get(prefsFontSize, "12 point")).isEmpty()) {
            fontSize = "12 point";
        }
        this.fontSize = fontSize;
        if (this.frame != null) {
            this.frame.setSelectedSize(fontSize);
        }
        int pos = fontSize.indexOf(32);
        int size = Integer.parseInt(fontSize.substring(0, pos));
        this.fireFontChangeEvent(new Font(fontName, 0, size));
    }

    public void setSampleText(String text) {
        this.text = text;
        if (this.frame != null) {
            this.frame.setText(text);
        }
    }

    public void addFontChangeListener(FontChangeListener listener) {
        this.listenerList.add(FontChangeListener.class, listener);
    }

    public void removeFontChangeListener(FontChangeListener listener) {
        this.listenerList.remove(FontChangeListener.class, listener);
    }

    public void fireFontChangeEvent(Font font) {
        FontChangeListener[] listeners;
        FontChangeEvent fontChangeEvent = new FontChangeEvent(font);
        FontChangeListener[] fontChangeListenerArray = listeners = (FontChangeListener[])this.listenerList.getListeners(FontChangeListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FontChangeListener listener = fontChangeListenerArray[n2];
            listener.changeFont(fontChangeEvent);
            ++n2;
        }
    }

    public class FontChangeEvent {
        public final Font font;
        public final FontMetrics fontMetrics;

        public FontChangeEvent(Font font) {
            this.font = font;
            if (canvas == null) {
                canvas = new Canvas();
            }
            this.fontMetrics = canvas.getFontMetrics(font);
        }
    }

    public static interface FontChangeListener
    extends EventListener {
        public void changeFont(FontChangeEvent var1);
    }
}

