/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import com.bytezone.diskbrowser.gui.DiskPanel;
import com.bytezone.diskbrowser.utilities.FontUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;

class DiskLegendPanel
extends DiskPanel {
    private static final int LEFT = 3;
    private static final int TOP = 10;
    private final Font font = FontUtility.getFont(FontUtility.FontType.SANS_SERIF, FontUtility.FontSize.BASE);

    public DiskLegendPanel() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void setDisk(FormattedDisk disk, DiskLayoutPanel.LayoutDetails details) {
        super.setDisk(disk, details);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 160);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.formattedDisk == null) {
            return;
        }
        g.setFont(this.font);
        int count = 0;
        int lineHeight = 20;
        for (SectorType type : this.formattedDisk.getSectorTypeList()) {
            int x = 3 + (count % 2 == 0 ? 0 : 155);
            int y = 10 + count / 2 * lineHeight;
            ++count;
            g.setColor(this.backgroundColor);
            g.drawRect(x + 1, y + 1, this.blockWidth - 1, this.blockHeight - 1);
            g.setColor(type.colour);
            g.fillRect(x + 1, y + 1, this.blockWidth - 1, this.blockHeight - 1);
            g.setColor(Color.BLACK);
            g.drawString(type.name, x + this.blockWidth + 4, y + 12);
        }
        int y = ++count / 2 * lineHeight + 20 + 5;
        int val = this.formattedDisk.falseNegativeBlocks();
        if (val > 0) {
            g.drawString(String.valueOf(val) + " unused sector" + (val == 1 ? "" : "s") + " marked as unavailable", 10, y);
            y += lineHeight;
        }
        if ((val = this.formattedDisk.falsePositiveBlocks()) > 0) {
            g.drawString(String.valueOf(val) + " used sector" + (val == 1 ? "" : "s") + " marked as available", 10, y);
        }
    }
}

