/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.AppleDiskAddress;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class DiskLayoutSelection
implements Iterable<DiskAddress> {
    private final List<DiskAddress> highlights = new ArrayList<DiskAddress>();

    public void doClick(Disk disk, DiskAddress da, boolean extend, boolean append) {
        if (!extend && !append || this.highlights.size() == 0) {
            this.highlights.clear();
            this.addHighlight(da);
            return;
        }
        for (DiskAddress setDA : this.highlights) {
            if (!da.matches(setDA)) continue;
            this.highlights.remove(setDA);
            return;
        }
        if (append) {
            this.addHighlight(da);
            Collections.sort(this.highlights);
            return;
        }
        if (this.checkContiguous()) {
            this.extendHighlights(disk, da);
        } else {
            this.adjustHighlights(disk, da);
        }
        Collections.sort(this.highlights);
    }

    void cursorMove(FormattedDisk formattedDisk, KeyEvent e) {
        if (this.highlights.size() == 0) {
            System.out.println("Nothing to move");
            return;
        }
        Disk disk = formattedDisk.getDisk();
        DiskAddress first = this.highlights.get(0);
        DiskAddress last = this.highlights.get(this.highlights.size() - 1);
        if (!e.isShiftDown()) {
            this.highlights.clear();
        }
        int totalBlocks = disk.getTotalBlocks();
        Dimension gridLayout = formattedDisk.getGridLayout();
        int rowSize = gridLayout.width;
        switch (e.getKeyCode()) {
            case 37: {
                int block = first.getBlockNo() - 1;
                if (block < 0) {
                    block = totalBlocks - 1;
                }
                this.addHighlight(disk.getDiskAddress(block));
                break;
            }
            case 39: {
                int block = last.getBlockNo() + 1;
                if (block >= totalBlocks) {
                    block = 0;
                }
                this.addHighlight(disk.getDiskAddress(block));
                break;
            }
            case 38: {
                int block = first.getBlockNo() - rowSize;
                if (block < 0) {
                    block += totalBlocks;
                }
                this.addHighlight(disk.getDiskAddress(block));
                break;
            }
            case 40: {
                int block = last.getBlockNo() + rowSize;
                if (block >= totalBlocks) {
                    block -= totalBlocks;
                }
                this.addHighlight(disk.getDiskAddress(block));
            }
        }
        Collections.sort(this.highlights);
    }

    private void addHighlight(DiskAddress da) {
        assert (da != null);
        this.highlights.add(da);
    }

    @Override
    public Iterator<DiskAddress> iterator() {
        return this.highlights.iterator();
    }

    public List<DiskAddress> getHighlights() {
        return new ArrayList<DiskAddress>(this.highlights);
    }

    public boolean isSelected(DiskAddress da) {
        for (DiskAddress selection : this.highlights) {
            if (selection == null || !da.matches(selection)) continue;
            return true;
        }
        return false;
    }

    public void setSelection(List<DiskAddress> list) {
        this.highlights.clear();
        if (list != null) {
            for (DiskAddress da : list) {
                if (da == null || da.getBlockNo() <= 0 && !((AppleDiskAddress)da).zeroFlag()) continue;
                this.highlights.add(da);
            }
        }
    }

    private boolean checkContiguous() {
        int range = this.highlights.get(this.highlights.size() - 1).getBlockNo() - this.highlights.get(0).getBlockNo() + 1;
        return range == this.highlights.size();
    }

    private void extendHighlights(Disk disk, DiskAddress da) {
        int hi;
        int lo;
        if (this.highlights.get(0).getBlockNo() > da.getBlockNo()) {
            lo = da.getBlockNo();
            hi = this.highlights.get(0).getBlockNo() - 1;
        } else {
            lo = this.highlights.get(this.highlights.size() - 1).getBlockNo() + 1;
            hi = da.getBlockNo();
        }
        int i = lo;
        while (i <= hi) {
            this.addHighlight(disk.getDiskAddress(i));
            ++i;
        }
    }

    private void adjustHighlights(Disk disk, DiskAddress da) {
        if (da.getBlockNo() < this.highlights.get(0).getBlockNo() || da.getBlockNo() > this.highlights.get(this.highlights.size() - 1).getBlockNo()) {
            this.extendHighlights(disk, da);
            return;
        }
        this.addHighlight(da);
    }
}

