/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.HybridDisk;
import com.bytezone.diskbrowser.gui.DiskLayoutImage;
import com.bytezone.diskbrowser.gui.DiskLegendPanel;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.ScrollRuler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DiskLayoutPanel
extends JPanel
implements DiskSelectionListener,
FileSelectionListener,
RedoHandler.RedoListener,
PropertyChangeListener {
    private static final int SIZE = 15;
    private final DiskLayoutImage diskLayoutImage = new DiskLayoutImage();
    private final ScrollRuler verticalRuler = new ScrollRuler(this.diskLayoutImage, 1);
    private final ScrollRuler horizontalRuler = new ScrollRuler(this.diskLayoutImage, 0);
    private final DiskLegendPanel legendPanel = new DiskLegendPanel();
    private final JScrollPane sp;
    private LayoutDetails layout;

    public DiskLayoutPanel() {
        super(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.sp = new JScrollPane(this.diskLayoutImage, 22, 32);
        this.sp.getViewport().setBackground(Color.WHITE);
        this.sp.setColumnHeaderView(this.horizontalRuler);
        this.sp.setRowHeaderView(this.verticalRuler);
        this.sp.setBorder(null);
        this.sp.setCorner("UPPER_LEFT_CORNER", new Corner(true));
        this.sp.setCorner("LOWER_LEFT_CORNER", new Corner(false));
        this.sp.setCorner("UPPER_RIGHT_CORNER", new Corner(false));
        this.sp.setCorner("LOWER_RIGHT_CORNER", new Corner(false));
        this.add((Component)this.sp, "Center");
        this.add((Component)this.legendPanel, "South");
    }

    public void setDisk(final FormattedDisk disk) {
        this.layout = new LayoutDetails(disk);
        this.diskLayoutImage.setDisk(disk, this.layout);
        this.verticalRuler.setLayout(this.layout);
        this.horizontalRuler.setLayout(this.layout);
        this.legendPanel.setDisk(disk, this.layout);
        this.sp.setViewportView(this.diskLayoutImage);
        this.setLayout(new BorderLayout());
        if (disk.getGridLayout().height == 35) {
            this.add((Component)this.sp, "North");
            this.add((Component)this.legendPanel, "Center");
        } else {
            this.add((Component)this.sp, "Center");
            this.add((Component)this.legendPanel, "South");
        }
        disk.getDisk().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutDetails layout = new LayoutDetails(disk);
                DiskLayoutPanel.this.diskLayoutImage.setDisk(disk, layout);
                DiskLayoutPanel.this.legendPanel.setDisk(disk, layout);
                DiskLayoutPanel.this.verticalRuler.setLayout(layout);
                DiskLayoutPanel.this.horizontalRuler.setLayout(layout);
            }
        });
        this.repaint();
    }

    public void setHex(boolean hex) {
        this.verticalRuler.setHex(hex);
        this.horizontalRuler.setHex(hex);
    }

    public void setBlock(boolean block) {
        this.verticalRuler.setTrackMode(block);
        this.horizontalRuler.setTrackMode(block);
    }

    public void setFree(boolean free) {
        this.diskLayoutImage.setShowFreeSectors(free);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setFree((Boolean)evt.getNewValue());
    }

    public void addSectorSelectionListener(SectorSelectionListener listener) {
        this.diskLayoutImage.addSectorSelectionListener(listener);
    }

    public void addSectorSelectionListener(SectorSelectionListener ... listeners) {
        SectorSelectionListener[] sectorSelectionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SectorSelectionListener sectorSelectionListener = sectorSelectionListenerArray[n2];
            this.diskLayoutImage.addSectorSelectionListener(sectorSelectionListener);
            ++n2;
        }
    }

    public void removeSectorSelectionListener(SectorSelectionListener listener) {
        this.diskLayoutImage.removeSectorSelectionListener(listener);
    }

    @Override
    public void diskSelected(DiskSelectedEvent event) {
        this.setDisk(event.getFormattedDisk());
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        this.checkCorrectDisk(event.appleFileSource.getFormattedDisk());
        this.diskLayoutImage.setSelection(event.appleFileSource.getSectors());
    }

    @Override
    public void redo(RedoHandler.RedoEvent event) {
        if (!event.type.equals("SectorEvent")) {
            return;
        }
        this.checkCorrectDisk(((SectorSelectedEvent)event.value).getFormattedDisk());
        this.diskLayoutImage.redo(event);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCorrectDisk(FormattedDisk newDisk) {
        void var3_2;
        HybridDisk hybridDisk;
        FormattedDisk formattedDisk = newDisk;
        if (formattedDisk instanceof HybridDisk && (hybridDisk = (HybridDisk)formattedDisk) == (HybridDisk)var3_2) {
            void hybridDisk2;
            newDisk = hybridDisk2.getCurrentDisk();
        }
        if (newDisk != this.diskLayoutImage.getDisk()) {
            LayoutDetails layout = new LayoutDetails(newDisk);
            this.diskLayoutImage.setDisk(newDisk, layout);
            this.legendPanel.setDisk(newDisk, layout);
        }
    }

    class Corner
    extends JComponent {
        Color backgroundColor = Color.WHITE;
        boolean showHex = true;

        public Corner(boolean allowClick) {
            if (allowClick) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Corner.this.showHex = !Corner.this.showHex;
                        ((Corner)Corner.this).DiskLayoutPanel.this.verticalRuler.setHex(Corner.this.showHex);
                        ((Corner)Corner.this).DiskLayoutPanel.this.horizontalRuler.setHex(Corner.this.showHex);
                    }
                });
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    class LayoutDetails {
        Dimension block;
        Dimension grid;

        public LayoutDetails(FormattedDisk formattedDisk) {
            Disk disk = formattedDisk.getDisk();
            this.block = new Dimension(disk.getBlockSize() == 256 ? 15 : 30, 15);
            this.grid = formattedDisk.getGridLayout();
        }

        public Rectangle getLocation(DiskAddress da) {
            int y = da.getBlockNo() / this.grid.width;
            int x = da.getBlockNo() % this.grid.width;
            Rectangle r = new Rectangle(x * this.block.width, y * this.block.height, this.block.width, this.block.height);
            return r;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append("Block " + this.block + "\n");
            text.append("Grid  " + this.grid);
            return text.toString();
        }
    }
}

