/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.HybridDisk;
import com.bytezone.diskbrowser.duplicates.DiskDetails;
import com.bytezone.diskbrowser.gui.AbstractTab;
import com.bytezone.diskbrowser.gui.AppleDiskTab;
import com.bytezone.diskbrowser.gui.CloseTabAction;
import com.bytezone.diskbrowser.gui.DiskAndFileSelector;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.DuplicateAction;
import com.bytezone.diskbrowser.gui.FileNodeSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.FileSystemTab;
import com.bytezone.diskbrowser.gui.FontAction;
import com.bytezone.diskbrowser.gui.QuitListener;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import com.bytezone.diskbrowser.gui.Tab;
import com.bytezone.diskbrowser.gui.TreeBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class CatalogPanel
extends JTabbedPane
implements RedoHandler.RedoListener,
SectorSelectionListener,
QuitListener,
FontAction.FontChangeListener,
DuplicateAction.DiskTableSelectionListener,
PropertyChangeListener {
    private static final String prefsLastDiskUsed = "Last disk used";
    private static final String prefsLastDosUsed = "Last dos used";
    private static final String prefsLastFileUsed = "Last file used";
    private static final String prefsLastSectorsUsed = "Last sectors used";
    private Font font;
    private FileSystemTab fileTab;
    private final List<AppleDiskTab> diskTabs = new ArrayList<AppleDiskTab>();
    private final DiskAndFileSelector selector = new DiskAndFileSelector();
    private final RedoHandler redoHandler;
    private CloseTabAction closeTabAction;
    private File rootFolder;
    private boolean restored = false;

    public CatalogPanel(RedoHandler redoHandler) {
        this.redoHandler = redoHandler;
        this.setTabPlacement(3);
        this.setPreferredSize(new Dimension(360, 802));
    }

    private void rootDirectoryChanged(File oldRootFolder, File newRootFolder) {
        this.rootFolder = newRootFolder;
        if (!this.restored) {
            return;
        }
        if (this.fileTab != null) {
            this.removeTabAt(0);
        }
        this.insertFileSystemTab(null);
        this.setSelectedIndex(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("RootDirectory")) {
            this.rootDirectoryChanged((File)evt.getOldValue(), (File)evt.getNewValue());
        }
    }

    private void insertFileSystemTab(DiskSelectedEvent diskEvent) {
        this.fileTab = new FileSystemTab(this.rootFolder, this.selector, this.redoHandler, this.font, diskEvent);
        this.fileTab.addTreeMouseListener(new MouseListener());
        this.insertTab("Disk Tree", null, this.fileTab, "Display Apple disks", 0);
    }

    public void activate() {
        if (this.fileTab == null) {
            System.out.println("No file tab");
            return;
        }
        if (this.diskTabs.size() > 0) {
            this.setSelectedIndex(1);
        } else if (this.fileTab != null) {
            this.setSelectedIndex(0);
        }
    }

    void setCloseTabAction(CloseTabAction action) {
        this.closeTabAction = action;
    }

    public void addDiskPanel(FormattedDisk disk, boolean activate) {
        AppleDiskTab tab2;
        int tabNo = 1;
        for (AppleDiskTab tab2 : this.diskTabs) {
            if (tab2.contains(disk)) {
                this.setSelectedIndex(tabNo);
                return;
            }
            ++tabNo;
        }
        tab2 = new AppleDiskTab(disk, this.selector, this.redoHandler, this.font);
        this.diskTabs.add(tab2);
        this.add((Component)tab2, "D" + this.diskTabs.size());
        if (activate) {
            this.setSelectedIndex(this.diskTabs.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void refreshTree() {
        void var3_2;
        AppleDiskTab appleDiskTab;
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        tab.refresh();
        Tab tab2 = tab;
        if (tab2 instanceof AppleDiskTab && (appleDiskTab = (AppleDiskTab)tab2) == (AppleDiskTab)var3_2) {
            void appleDiskTab2;
            this.fileTab.replaceDisk(appleDiskTab2.disk);
        }
    }

    public void closeCurrentTab() {
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        if (!(tab instanceof AppleDiskTab) || this.diskTabs.size() < 2) {
            return;
        }
        int index = this.getSelectedIndex();
        this.remove(index);
        this.diskTabs.remove(tab);
        int i = 1;
        while (i <= this.diskTabs.size()) {
            this.setTitleAt(i, "D" + i);
            ++i;
        }
        this.checkCloseTabAction();
    }

    private void checkCloseTabAction() {
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        this.closeTabAction.setEnabled(this.diskTabs.size() > 1 && tab instanceof AppleDiskTab);
    }

    @Override
    public void quit(Preferences prefs) {
        if (this.fileTab == null) {
            prefs.put(prefsLastDiskUsed, "");
            prefs.putInt(prefsLastDosUsed, -1);
            prefs.put(prefsLastFileUsed, "");
            prefs.put(prefsLastSectorsUsed, "");
        } else if (this.diskTabs.size() == 0) {
            RedoHandler.RedoEvent redoEvent = this.fileTab.redoData.getCurrentEvent();
            if (redoEvent != null) {
                DiskSelectedEvent event = (DiskSelectedEvent)redoEvent.value;
                prefs.put(prefsLastDiskUsed, event.getFormattedDisk().getAbsolutePath());
            }
            prefs.put(prefsLastFileUsed, "");
            prefs.put(prefsLastSectorsUsed, "");
        } else {
            AbstractTab selectedTab = (AbstractTab)this.getSelectedComponent();
            if (selectedTab instanceof FileSystemTab) {
                selectedTab = this.diskTabs.get(this.diskTabs.size() - 1);
            }
            FormattedDisk fd = ((AppleDiskTab)selectedTab).disk;
            prefs.put(prefsLastDiskUsed, fd.getAbsolutePath());
            if (fd instanceof HybridDisk var4_7) {
                prefs.putInt(prefsLastDosUsed, hybridDisk.getCurrentDiskNo());
            } else {
                prefs.putInt(prefsLastDosUsed, -1);
            }
            RedoHandler.RedoEvent redoEvent = selectedTab.redoData.getCurrentEvent();
            if (redoEvent != null) {
                EventObject event = redoEvent.value;
                if (event instanceof FileSelectedEvent var8_11) {
                    AppleFileSource afs = fileSelectedEvent.appleFileSource;
                    prefs.put(prefsLastFileUsed, afs == null ? "" : afs.getUniqueName());
                    prefs.put(prefsLastSectorsUsed, "");
                } else {
                    if (event instanceof SectorSelectedEvent afs) {
                        prefs.put(prefsLastFileUsed, "");
                        prefs.put(prefsLastSectorsUsed, sectorSelectedEvent.toText());
                    }
                }
            }
        }
    }

    @Override
    public void restore(Preferences prefs) {
        String lastDiskUsed = prefs.get(prefsLastDiskUsed, "");
        int lastDosUsed = prefs.getInt(prefsLastDosUsed, -1);
        String lastFileUsed = prefs.get(prefsLastFileUsed, "");
        String lastSectorsUsed = prefs.get(prefsLastSectorsUsed, "");
        FormattedDisk fd1 = null;
        DiskSelectedEvent diskEvent = null;
        if (!lastDiskUsed.isEmpty()) {
            diskEvent = DiskSelectedEvent.create(this, lastDiskUsed);
            if (diskEvent != null) {
                fd1 = diskEvent.getFormattedDisk();
                if (lastDosUsed >= 0 && fd1 instanceof HybridDisk var8_9) {
                    hybridDisk.setCurrentDiskNo(lastDosUsed);
                }
            }
        } else {
            System.out.println("no disk selected");
        }
        if (this.rootFolder != null) {
            this.insertFileSystemTab(diskEvent);
        }
        if (diskEvent != null) {
            AppleDiskTab tab = null;
            FormattedDisk fd = diskEvent.getFormattedDisk();
            assert (fd == fd1);
            if (!lastFileUsed.isEmpty()) {
                AppleFileSource afs = fd.getFile(lastFileUsed);
                if (afs != null) {
                    FileSelectedEvent fileEvent = new FileSelectedEvent(this, afs);
                    tab = new AppleDiskTab(fd, this.selector, this.redoHandler, this.font, fileEvent);
                } else {
                    tab = new AppleDiskTab(fd, this.selector, this.redoHandler, this.font, lastFileUsed);
                }
            } else if (!lastSectorsUsed.isEmpty()) {
                SectorSelectedEvent sectorEvent = SectorSelectedEvent.create(this, fd, lastSectorsUsed);
                tab = new AppleDiskTab(fd, this.selector, this.redoHandler, this.font, sectorEvent);
            } else {
                tab = new AppleDiskTab(fd, this.selector, this.redoHandler, this.font);
            }
            if (tab != null) {
                this.diskTabs.add(tab);
                this.add((Component)tab, "D" + this.diskTabs.size());
            } else {
                System.out.println("No disk tab created");
            }
        }
        this.addChangeListener(new TabChangeListener());
        this.restored = true;
    }

    public void addDiskSelectionListener(DiskSelectionListener listener) {
        this.selector.addDiskSelectionListener(listener);
    }

    public void addDiskSelectionListener(DiskSelectionListener ... listeners) {
        DiskSelectionListener[] diskSelectionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            DiskSelectionListener diskSelectionListener = diskSelectionListenerArray[n2];
            this.selector.addDiskSelectionListener(diskSelectionListener);
            ++n2;
        }
    }

    public void addFileSelectionListener(FileSelectionListener listener) {
        this.selector.addFileSelectionListener(listener);
    }

    public void addFileSelectionListener(FileSelectionListener ... listeners) {
        FileSelectionListener[] fileSelectionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FileSelectionListener fileSelectionListener = fileSelectionListenerArray[n2];
            this.selector.addFileSelectionListener(fileSelectionListener);
            ++n2;
        }
    }

    public void addFileNodeSelectionListener(FileNodeSelectionListener listener) {
        this.selector.addFileNodeSelectionListener(listener);
    }

    public void addFileNodeSelectionListener(FileNodeSelectionListener ... listeners) {
        FileNodeSelectionListener[] fileNodeSelectionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FileNodeSelectionListener fileNodeSelectionListener = fileNodeSelectionListenerArray[n2];
            this.selector.addFileNodeSelectionListener(fileNodeSelectionListener);
            ++n2;
        }
    }

    @Override
    public void redo(RedoHandler.RedoEvent event) {
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        this.selector.redo = true;
        switch (event.type) {
            case "FileNodeEvent": 
            case "DiskEvent": {
                if (!(tab instanceof FileSystemTab var4_5)) break;
                fileSystemTab.redoEvent(event);
                break;
            }
            case "FileEvent": {
                if (!(tab instanceof AppleDiskTab var6_7)) break;
                appleDiskTab.redoEvent(event);
                break;
            }
            default: {
                System.out.println("Unknown event type : " + event.type);
            }
            case "SectorEvent": 
        }
        this.selector.redo = false;
    }

    @Override
    public void sectorSelected(SectorSelectedEvent event) {
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        if (tab instanceof AppleDiskTab var3_4) {
            appleDiskTab.tree.setSelectionPath(null);
        }
    }

    @Override
    public void changeFont(FontAction.FontChangeEvent fontChangeEvent) {
        this.font = fontChangeEvent.font;
        if (this.fileTab != null) {
            this.fileTab.setTreeFont(this.font);
        }
        for (AppleDiskTab tab : this.diskTabs) {
            tab.setTreeFont(this.font);
        }
    }

    @Override
    public void diskSelected(DiskDetails diskDetails) {
        if (this.getSelectedIndex() != 0) {
            this.setSelectedIndex(0);
        }
        this.fileTab.selectDisk(diskDetails.getRootName());
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            int selRow = tree.getRowForLocation(e.getX(), e.getY());
            if (selRow < 0) {
                return;
            }
            TreePath tp = tree.getPathForLocation(e.getX(), e.getY());
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
            TreeBuilder.FileNode node = (TreeBuilder.FileNode)selectedNode.getUserObject();
            if (!node.file.isDirectory() && e.getClickCount() == 2) {
                CatalogPanel.this.addDiskPanel(node.getFormattedDisk(), true);
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Tab tab = (Tab)((Object)CatalogPanel.this.getSelectedComponent());
            if (tab != null) {
                tab.activate();
                CatalogPanel.this.checkCloseTabAction();
            }
        }
    }
}

