/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.utilities.DefaultAction;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class AbstractSaveAction
extends DefaultAction {
    private JFileChooser fileChooser;
    private String dialogTitle;

    public AbstractSaveAction(String menuText, String tip, String dialogTitle) {
        super(menuText, tip);
        this.dialogTitle = dialogTitle;
    }

    void setSelectedFile(File file) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogTitle(this.dialogTitle);
        }
        this.fileChooser.setSelectedFile(file);
    }

    void saveBuffer(byte[] buffer) {
        if (this.fileChooser.showSaveDialog(null) != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        try {
            Files.write(file.toPath(), buffer, StandardOpenOption.CREATE_NEW);
            JOptionPane.showMessageDialog(null, String.format("File %s saved", file.getName()));
        }
        catch (FileAlreadyExistsException e) {
            JOptionPane.showMessageDialog(null, "File " + file.getName() + " already exists", "Failed", 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "File failed to save - " + e.getMessage(), "Failed", 0);
        }
    }
}

