/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.duplicates;

import com.bytezone.diskbrowser.duplicates.DiskDetails;
import com.bytezone.diskbrowser.duplicates.DisksWindow;
import com.bytezone.diskbrowser.duplicates.DuplicateSwingWorker;
import com.bytezone.diskbrowser.gui.DuplicateAction;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RootFolderData
implements PropertyChangeListener {
    private static final String header = "      type        uncmp      .gz     .zip    total";
    private static final String line = "--------------  -------  -------  -------  -------";
    private static final Font font = new Font("Monospaced", 1, 15);
    private File rootFolder;
    private int rootFolderNameLength;
    final Map<Long, DiskDetails> checksumMap = new HashMap<Long, DiskDetails>();
    final Map<String, DiskDetails> fileNameMap = new TreeMap<String, DiskDetails>();
    public DisksWindow disksWindow;
    public final List<DuplicateAction.DiskTableSelectionListener> listeners = new ArrayList<DuplicateAction.DiskTableSelectionListener>();
    public boolean doChecksums;
    int totalDisks;
    int totalFolders;
    int[][] typeTotals;
    ProgressPanel progressPanel;
    public JFrame dialogTotals;
    JPanel southPanel;
    JButton btnCancel;
    JButton btnOK;

    private void createWindows() {
        this.southPanel = new JPanel();
        this.btnCancel = new JButton("Cancel");
        this.btnOK = new JButton("OK");
        this.progressPanel = new ProgressPanel();
        this.progressPanel.setPreferredSize(new Dimension(560, 380));
        this.dialogTotals = new JFrame("Disk Totals");
        this.dialogTotals.add((Component)this.progressPanel, "Center");
        this.southPanel.add(this.btnCancel);
        this.dialogTotals.add((Component)this.southPanel, "South");
        this.dialogTotals.pack();
        this.dialogTotals.setLocationRelativeTo(null);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootFolderData.this.progressPanel.cancelled = true;
                RootFolderData.this.dialogTotals.setVisible(false);
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootFolderData.this.dialogTotals.setVisible(false);
            }
        });
    }

    public void count(boolean doChecksums) {
        if (this.dialogTotals == null) {
            this.createWindows();
        }
        this.clear();
        this.setButton(this.btnCancel);
        this.doChecksums = doChecksums;
        this.progressPanel.cancelled = false;
        this.disksWindow = new DisksWindow(this);
        this.dialogTotals.setVisible(true);
        new DuplicateSwingWorker(this).execute();
    }

    public void done() {
        this.print();
        this.dialogTotals.repaint();
        this.dialogTotals.setVisible(false);
        if (this.progressPanel.cancelled) {
            this.disksWindow = null;
        } else {
            this.disksWindow.setTableData(this);
            this.setButton(this.btnOK);
        }
    }

    private void setButton(JButton button) {
        this.southPanel.removeAll();
        this.southPanel.add(button);
        this.dialogTotals.revalidate();
        this.dialogTotals.repaint();
    }

    String getRootFolderPathText() {
        String homeDir;
        String text = this.rootFolder.getAbsolutePath();
        if (text.startsWith(homeDir = System.getProperty("user.home"))) {
            text = text.replace(homeDir, "~");
        }
        return text;
    }

    private void clear() {
        this.typeTotals = new int[4][Utility.getTotalSuffixes()];
        this.totalDisks = 0;
        this.totalFolders = 0;
        this.checksumMap.clear();
        this.fileNameMap.clear();
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public void incrementFolders() {
        ++this.totalFolders;
    }

    public void incrementType(File file, String fileName) {
        int pos = Utility.getSuffixNo(fileName);
        if (pos >= 0) {
            int cmp = fileName.endsWith(".zip") ? 2 : (fileName.endsWith(".gz") ? 1 : 0);
            int[] nArray = this.typeTotals[cmp];
            int n = pos;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.typeTotals[3];
            int n2 = pos;
            nArray2[n2] = nArray2[n2] + 1;
            ++this.totalDisks;
        } else {
            System.out.println("no suffix: " + fileName);
        }
        this.checkDuplicates(file, fileName);
    }

    private void checkDuplicates(File file, String fileName) {
        String rootName = file.getAbsolutePath().substring(this.rootFolderNameLength);
        DiskDetails diskDetails = new DiskDetails(file, rootName, fileName, this.doChecksums);
        if (this.fileNameMap.containsKey(fileName)) {
            this.fileNameMap.get(fileName).addDuplicateName(diskDetails);
        } else {
            this.fileNameMap.put(fileName, diskDetails);
        }
        if (this.doChecksums) {
            long checksum = diskDetails.getChecksum();
            if (this.checksumMap.containsKey(checksum)) {
                this.checksumMap.get(checksum).addDuplicateChecksum(diskDetails);
            } else {
                this.checksumMap.put(checksum, diskDetails);
            }
        }
    }

    public List<DiskDetails> listDuplicates(long checksum) {
        ArrayList<DiskDetails> list = new ArrayList<DiskDetails>();
        DiskDetails original = this.checksumMap.get(checksum);
        if (original != null) {
            list.add(original);
            for (DiskDetails dd : original.getDuplicateChecksums()) {
                list.add(dd);
            }
        }
        return list;
    }

    public int getTotalType(int type) {
        return this.typeTotals[0][type] + this.typeTotals[1][type] + this.typeTotals[2][type];
    }

    public void print() {
        System.out.printf("%nFolders ...... %,7d%n", this.totalFolders);
        System.out.printf("Disks ........ %,7d%n%n", this.totalDisks);
        int[] grandTotal = new int[4];
        System.out.println(header);
        System.out.println(line);
        int i = 0;
        while (i < this.typeTotals[0].length) {
            System.out.printf("%14.14s  ", String.valueOf(Utility.getSuffix(i)) + " ...........");
            int j = 0;
            while (j < this.typeTotals.length) {
                System.out.printf("%,7d  ", this.typeTotals[j][i]);
                int n = j;
                grandTotal[n] = grandTotal[n] + this.typeTotals[j][i];
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println(line);
        System.out.printf("Total           %,7d  %,7d  %,7d  %,7d%n%n", grandTotal[0], grandTotal[1], grandTotal[2], grandTotal[3]);
        if (this.doChecksums) {
            System.out.printf("Unique checksums: %,7d%n", this.checksumMap.size());
            System.out.printf("Duplicate disks : %,7d%n", this.totalDisks - this.checksumMap.size());
        }
    }

    private void rootDirectoryChanged(File oldRootFolder, File newRootFolder) {
        this.rootFolder = newRootFolder;
        this.rootFolderNameLength = this.rootFolder.getAbsolutePath().length();
        this.disksWindow = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("RootDirectory")) {
            this.rootDirectoryChanged((File)evt.getOldValue(), (File)evt.getNewValue());
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Root folder ....... %s%n", this.rootFolder));
        text.append(String.format("Disks ............. %,d%n", this.totalDisks));
        text.append(String.format("Folders ........... %,d", this.totalFolders));
        return text.toString();
    }

    class ProgressPanel
    extends JPanel {
        public volatile boolean cancelled;

        ProgressPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            String line;
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            g.setColor(Color.BLACK);
            g.setFont(font);
            int x = 55;
            int y = 25;
            int lineHeight = 23;
            g.drawString(RootFolderData.header, x, y);
            y += lineHeight + 10;
            int[] grandTotal = new int[4];
            int i = 0;
            while (i < RootFolderData.this.typeTotals[0].length) {
                if (RootFolderData.this.typeTotals[3][i] > 0) {
                    line = String.format("%14.14s  %,7d  %,7d  %,7d  %,7d", String.valueOf(Utility.getSuffix(i)) + " ...........", RootFolderData.this.typeTotals[0][i], RootFolderData.this.typeTotals[1][i], RootFolderData.this.typeTotals[2][i], RootFolderData.this.typeTotals[3][i]);
                    g.drawString(line, x, y);
                    int j = 0;
                    while (j < RootFolderData.this.typeTotals.length) {
                        int n = j;
                        grandTotal[n] = grandTotal[n] + RootFolderData.this.typeTotals[j][i];
                        ++j;
                    }
                    y += lineHeight;
                }
                ++i;
            }
            line = String.format("Total           %,7d  %,7d  %,7d  %,7d%n%n", grandTotal[0], grandTotal[1], grandTotal[2], grandTotal[3]);
            g.drawString(line, x, y += 10);
            if (RootFolderData.this.doChecksums) {
                line = String.format("duplicates ...                             %,7d%n", RootFolderData.this.totalDisks - RootFolderData.this.checksumMap.size());
                g.drawString(line, x, y += lineHeight + 10);
            }
        }
    }
}

