/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.duplicates;

import com.bytezone.diskbrowser.duplicates.RootFolderData;
import com.bytezone.diskbrowser.utilities.Utility;
import java.io.File;
import java.util.List;
import javax.swing.SwingWorker;

class DuplicateSwingWorker
extends SwingWorker<Void, RootFolderData> {
    private final RootFolderData rootFolderData;

    DuplicateSwingWorker(RootFolderData rootFolderData) {
        this.rootFolderData = rootFolderData;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.traverse(this.rootFolderData.getRootFolder());
        return null;
    }

    @Override
    protected void done() {
        this.rootFolderData.done();
    }

    @Override
    protected void process(List<RootFolderData> chunks) {
        this.rootFolderData.progressPanel.repaint();
    }

    private void traverse(File directory) {
        if (this.rootFolderData.progressPanel.cancelled) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.rootFolderData.progressPanel.cancelled) {
                return;
            }
            if (!file.isHidden()) {
                if (file.isDirectory()) {
                    if (file.getName().equalsIgnoreCase("emulators")) {
                        System.out.println("ignoring: " + file.getAbsolutePath());
                    } else {
                        this.rootFolderData.incrementFolders();
                        this.traverse(file);
                    }
                } else {
                    String fileName = file.getName().toLowerCase();
                    if (Utility.validFileType(fileName) && file.length() > 0L) {
                        this.rootFolderData.incrementType(file, fileName);
                        if (this.rootFolderData.totalDisks % 250 == 0) {
                            this.publish(this.rootFolderData);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

