/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.duplicates;

import com.bytezone.diskbrowser.duplicates.CSVFileWriter;
import com.bytezone.diskbrowser.duplicates.DeleteWindow;
import com.bytezone.diskbrowser.duplicates.DiskDetails;
import com.bytezone.diskbrowser.duplicates.DiskTableModel;
import com.bytezone.diskbrowser.duplicates.RootFolderData;
import com.bytezone.diskbrowser.gui.DuplicateAction;
import com.bytezone.diskbrowser.utilities.NumberRenderer;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class DisksWindow
extends JFrame {
    private final JTable table;
    private final JButton btnExport = new JButton("Export");
    private final JButton btnDelete = new JButton("Duplicates");
    private final JButton btnHide = new JButton("Close");
    private final JButton btnTotals = new JButton("Totals");
    private final JPanel topPanel = new JPanel();
    private final List<JCheckBox> boxes = new ArrayList<JCheckBox>();
    private TableRowSorter<DiskTableModel> sorter;
    private final CheckBoxActionListener checkBoxActionListener = new CheckBoxActionListener();
    private DiskTableModel diskTableModel;
    private final RootFolderData rootFolderData;
    private final DeleteWindow deleteWindow;

    public DisksWindow(RootFolderData rootFolderData) {
        super(rootFolderData.getRootFolderPathText());
        this.rootFolderData = rootFolderData;
        this.table = new JTable();
        JScrollPane scrollPane = new JScrollPane(this.table, 22, 31);
        this.table.setFillsViewportHeight(true);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        panel.add(this.btnTotals);
        panel.add(this.btnHide);
        panel.add(this.btnExport);
        panel.add(this.btnDelete);
        this.add((Component)panel, "South");
        this.topPanel.setLayout(new FlowLayout(0, 10, 5));
        this.add((Component)this.topPanel, "North");
        this.btnHide.setEnabled(true);
        this.btnExport.setEnabled(false);
        this.btnTotals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisksWindow.this.rootFolderData.dialogTotals.setVisible(true);
            }
        });
        this.btnHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisksWindow.this.setVisible(false);
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisksWindow.this.deleteWindow.setVisible(true);
            }
        });
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVFileWriter.write(DisksWindow.this.diskTableModel, DisksWindow.this.table);
            }
        });
        scrollPane.setPreferredSize(new Dimension(1200, 693));
        this.setDefaultCloseOperation(1);
        this.deleteWindow = new DeleteWindow(rootFolderData);
    }

    public void setTableData(final RootFolderData rootFolderData) {
        this.diskTableModel = new DiskTableModel(rootFolderData);
        this.table.setModel(this.diskTableModel);
        int[] columnWidths = new int[]{300, 300, 30, 50, 30, 100};
        TableColumnModel tcm = this.table.getColumnModel();
        int i = 0;
        while (i < columnWidths.length) {
            tcm.getColumn(i).setPreferredWidth(columnWidths[i]);
            ++i;
        }
        if (rootFolderData.doChecksums) {
            tcm.getColumn(6).setPreferredWidth(tcm.getColumn(4).getPreferredWidth());
        }
        tcm.getColumn(3).setCellRenderer(NumberRenderer.getIntegerRenderer());
        this.sorter = new TableRowSorter<DiskTableModel>((DiskTableModel)this.table.getModel());
        this.table.setRowSorter(this.sorter);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    return;
                }
                DisksWindow.this.table.scrollRectToVisible(new Rectangle(DisksWindow.this.table.getCellRect(lsm.getMinSelectionIndex(), 0, true)));
                int selectedRow = DisksWindow.this.table.getSelectedRow();
                int actualRow = DisksWindow.this.sorter.convertRowIndexToModel(selectedRow);
                DiskTableModel diskTableModel = (DiskTableModel)DisksWindow.this.table.getModel();
                DiskDetails diskDetails = diskTableModel.getDiskDetails(actualRow);
                long checksum = diskDetails.getChecksum();
                if (checksum == 0L) {
                    diskTableModel.updateChecksum(actualRow);
                }
                for (DuplicateAction.DiskTableSelectionListener listener : rootFolderData.listeners) {
                    listener.diskSelected(diskDetails);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DisksWindow.this.deleteWindow.setVisible(true);
                }
            }
        });
        int i2 = 0;
        while (i2 < Utility.getTotalSuffixes()) {
            int total = rootFolderData.getTotalType(i2);
            JCheckBox btn = new JCheckBox(String.format("%s (%,d)", Utility.getSuffix(i2), total));
            this.topPanel.add(btn);
            this.boxes.add(btn);
            if (total > 0) {
                btn.setSelected(true);
                btn.addActionListener(this.checkBoxActionListener);
            } else {
                btn.setEnabled(false);
            }
            ++i2;
        }
        JTableHeader header = this.table.getTableHeader();
        header.setFont(header.getFont().deriveFont(13.0f));
        this.pack();
        this.setLocationRelativeTo(null);
        this.btnExport.setEnabled(true);
        this.setVisible(true);
    }

    private String getFilterText() {
        StringBuilder filterText = new StringBuilder();
        for (JCheckBox box : this.boxes) {
            if (!box.isSelected()) continue;
            String text = box.getText();
            int pos = text.indexOf(32);
            filterText.append(String.valueOf(text.substring(0, pos)) + "|");
        }
        if (filterText.length() > 0) {
            filterText.deleteCharAt(filterText.length() - 1);
        }
        return filterText.toString();
    }

    class CheckBoxActionListener
    implements ActionListener {
        CheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowFilter rf = null;
            try {
                rf = RowFilter.regexFilter(DisksWindow.this.getFilterText(), 2);
            }
            catch (PatternSyntaxException exception) {
                return;
            }
            DisksWindow.this.sorter.setRowFilter(rf);
        }
    }
}

