/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.duplicates;

import com.bytezone.diskbrowser.duplicates.DiskDetails;
import com.bytezone.diskbrowser.duplicates.RootFolderData;
import com.bytezone.diskbrowser.gui.DuplicateAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class DeleteWindow
extends JFrame
implements DuplicateAction.DiskTableSelectionListener {
    private List<DiskDetails> lines = new ArrayList<DiskDetails>();
    private final JButton btnHide = new JButton("Close");
    private final RootFolderData rootFolderData;
    private final DeleteTableModel deleteTableModel = new DeleteTableModel();
    private final JTable table = new JTable(this.deleteTableModel);

    public DeleteWindow(RootFolderData rootFolderData) {
        super("Duplicate Disks");
        JScrollPane scrollPane = new JScrollPane(this.table, 22, 31);
        this.table.setFillsViewportHeight(true);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        panel.add(this.btnHide);
        this.add((Component)panel, "South");
        this.btnHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteWindow.this.setVisible(false);
            }
        });
        scrollPane.setPreferredSize(new Dimension(700, 400));
        this.setDefaultCloseOperation(1);
        this.rootFolderData = rootFolderData;
        rootFolderData.listeners.add(this);
        int[] columnWidths = new int[]{400, 30, 70, 100};
        TableColumnModel tcm = this.table.getColumnModel();
        int i = 0;
        while (i < columnWidths.length) {
            tcm.getColumn(i).setPreferredWidth(columnWidths[i]);
            ++i;
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void diskSelected(DiskDetails diskDetails) {
        this.lines = this.rootFolderData.listDuplicates(diskDetails.getChecksum());
        this.deleteTableModel.fireTableDataChanged();
    }

    class DeleteTableModel
    extends AbstractTableModel {
        final String[] headers = new String[]{"Name", "Type", "Size", "Checksum"};

        DeleteTableModel() {
        }

        @Override
        public int getRowCount() {
            return DeleteWindow.this.lines.size();
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DiskDetails diskDetails = DeleteWindow.this.lines.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(diskDetails.getRootName()) + File.separator + diskDetails.getFileName();
                }
                case 1: {
                    return diskDetails.getType();
                }
                case 2: {
                    return diskDetails.getSize();
                }
                case 3: {
                    return diskDetails.getChecksum();
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return DeleteWindow.this.lines.isEmpty() ? Object.class : this.getValueAt(0, columnIndex).getClass();
        }
    }
}

