/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.dos.CatalogEntry;
import com.bytezone.diskbrowser.dos.DeletedCatalogEntry;
import com.bytezone.diskbrowser.dos.DosCatalogSector;
import com.bytezone.diskbrowser.dos.DosTSListSector;
import com.bytezone.diskbrowser.dos.DosVTOCSector;
import com.bytezone.diskbrowser.gui.DataSource;
import java.awt.Color;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class DosDisk
extends AbstractFormattedDisk {
    private static final int ENTRY_SIZE = 35;
    private static final int CATALOG_TRACK = 17;
    private static final int VTOC_SECTOR = 0;
    final DosVTOCSector dosVTOCSector;
    private final Color green = new Color(0, 200, 0);
    private final DefaultMutableTreeNode volumeNode;
    private int freeSectors;
    private int usedSectors;
    private final int volumeNo;
    public final SectorType vtocSector = new SectorType("VTOC", Color.magenta);
    public final SectorType catalogSector = new SectorType("Catalog", this.green);
    public final SectorType tsListSector = new SectorType("TSList", Color.blue);
    public final SectorType dataSector = new SectorType("Data", Color.red);
    public final SectorType dosSector = new SectorType("DOS", Color.lightGray);
    protected List<AppleFileSource> deletedFileEntries = new ArrayList<AppleFileSource>();
    private static boolean debug = false;

    public DosDisk(Disk disk) {
        this(disk, 0);
    }

    public DosDisk(Disk disk, int volumeNo) {
        super(disk);
        int sector;
        int track;
        this.volumeNo = volumeNo;
        this.sectorTypesList.add(this.dosSector);
        this.sectorTypesList.add(this.vtocSector);
        this.sectorTypesList.add(this.catalogSector);
        this.sectorTypesList.add(this.tsListSector);
        this.sectorTypesList.add(this.dataSector);
        DiskAddress da = disk.getDiskAddress(0, 0);
        byte[] sectorBuffer = disk.readBlock(da);
        this.bootSector = new BootSector(disk, sectorBuffer, "DOS", da);
        da = disk.getDiskAddress(17, 0);
        sectorBuffer = disk.readBlock(da);
        ((AppleDisk)disk).setDosVersion(sectorBuffer[3] & 0xFF);
        this.dosVTOCSector = new DosVTOCSector(this, disk, sectorBuffer, da);
        this.sectorTypes[da.getBlockNo()] = this.vtocSector;
        DiskAddress catalogStart = disk.getDiskAddress(sectorBuffer[1], sectorBuffer[2]);
        if (this.dosVTOCSector.sectorSize != disk.getBlockSize()) {
            System.out.printf("%s - invalid sector size : %d%n", disk.getFile().getName(), this.dosVTOCSector.sectorSize);
        }
        if (this.dosVTOCSector.maxSectors != disk.getBlocksPerTrack()) {
            System.out.printf("%s - invalid sectors per track : %d%n", disk.getFile().getName(), this.dosVTOCSector.maxSectors);
        }
        DefaultMutableTreeNode rootNode = this.getCatalogTreeRoot();
        this.volumeNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode deletedFilesNode = new DefaultMutableTreeNode();
        rootNode.add(this.volumeNode);
        da = disk.getDiskAddress(catalogStart.getBlockNo());
        while (disk.isValidAddress(da) && disk.isValidAddress((sectorBuffer = disk.readBlock(da))[1], sectorBuffer[2])) {
            this.sectorTypes[da.getBlockNo()] = this.catalogSector;
            track = sectorBuffer[1] & 0xFF;
            sector = sectorBuffer[2] & 0xFF;
            if (disk.isValidAddress(track, sector) && !(da = disk.getDiskAddress(track, sector)).isZero() && da.isValidAddress()) continue;
        }
        da = disk.getDiskAddress(catalogStart.getBlockNo());
        block1: while (disk.isValidAddress(da) && disk.isValidAddress((sectorBuffer = disk.readBlock(da))[1], sectorBuffer[2])) {
            int ptr = 11;
            while (ptr < 256) {
                boolean deletedFlag;
                if (sectorBuffer[ptr] == 0) break block1;
                byte[] entryBuffer = new byte[35];
                System.arraycopy(sectorBuffer, ptr, entryBuffer, 0, 35);
                int track2 = entryBuffer[0] & 0xFF;
                boolean bl = deletedFlag = (entryBuffer[0] & 0x80) != 0;
                if (deletedFlag) {
                    DeletedCatalogEntry deletedCatalogEntry = new DeletedCatalogEntry(this, da, entryBuffer, this.dosVTOCSector.dosVersion);
                    this.deletedFileEntries.add(deletedCatalogEntry);
                    node = new DefaultMutableTreeNode(deletedCatalogEntry);
                    node.setAllowsChildren(false);
                    deletedFilesNode.add(node);
                } else {
                    CatalogEntry catalogEntry = new CatalogEntry(this, da, entryBuffer);
                    this.fileEntries.add(catalogEntry);
                    node = new DefaultMutableTreeNode(catalogEntry);
                    node.setAllowsChildren(false);
                    this.volumeNode.add(node);
                }
                ptr += 35;
            }
            track = sectorBuffer[1] & 0xFF;
            sector = sectorBuffer[2] & 0xFF;
            if (this.dosVTOCSector.dosVersion >= 65) {
                track &= 0x3F;
                sector &= 0x1F;
            }
            if (disk.isValidAddress(track, sector) && !(da = disk.getDiskAddress(sectorBuffer[1], sectorBuffer[2])).isZero()) continue;
        }
        for (AppleFileSource fe : this.fileEntries) {
            String name = fe.getUniqueName();
            if (!name.endsWith(".AUX")) continue;
            String partner1 = name.substring(0, name.length() - 4);
            String partner2 = String.valueOf(partner1) + ".BIN";
            for (AppleFileSource fe2 : this.fileEntries) {
                if (!fe2.getUniqueName().equals(partner1) && !fe2.getUniqueName().equals(partner2)) continue;
                ((CatalogEntry)fe2).link((CatalogEntry)fe);
                ((CatalogEntry)fe).link((CatalogEntry)fe2);
            }
        }
        int lastDosSector = this.dosVTOCSector.maxSectors * 3;
        for (DiskAddress da2 : disk) {
            int blockNo = da2.getBlockNo();
            if (blockNo < lastDosSector) {
                if (this.freeBlocks.get(blockNo)) {
                    ++this.freeSectors;
                } else {
                    ++this.usedSectors;
                    if (this.sectorTypes[blockNo] == this.usedSector) {
                        this.sectorTypes[blockNo] = this.dosSector;
                    }
                }
            } else if (this.stillAvailable(da2)) {
                ++this.freeSectors;
            } else {
                ++this.usedSectors;
            }
            if (this.freeBlocks.get(blockNo) && !this.stillAvailable(da2)) {
                ++this.falsePositives;
            }
            if (this.freeBlocks.get(blockNo) || !this.stillAvailable(da2)) continue;
            ++this.falseNegatives;
        }
        if (deletedFilesNode.getDepth() > 0) {
            rootNode.add(deletedFilesNode);
            deletedFilesNode.setUserObject(this.getDeletedList());
            this.makeNodeVisible(deletedFilesNode.getFirstLeaf());
        }
        this.volumeNode.setUserObject(this.getCatalog());
        this.makeNodeVisible(this.volumeNode.getFirstLeaf());
    }

    @Override
    public void setOriginalPath(Path path) {
        super.setOriginalPath(path);
        this.volumeNode.setUserObject(this.getCatalog());
    }

    public static boolean isCorrectFormat(AppleDisk disk) {
        int blocksPerTrack = disk.getBlocksPerTrack();
        if (blocksPerTrack > 16 && blocksPerTrack != 32) {
            if (debug) {
                System.out.printf("Blocks per track: %d", blocksPerTrack);
            }
            return false;
        }
        int[] cb = new int[3];
        int best = 0;
        int il = -1;
        int max = disk.getBlocksPerTrack() == 16 ? 3 : 1;
        int interleave = 0;
        while (interleave < max) {
            if (debug) {
                System.out.printf("Checking interleave %d%n", interleave);
            }
            disk.setInterleave(interleave);
            cb[interleave] = DosDisk.checkFormat(disk);
            if (cb[interleave] >= 15) {
                return true;
            }
            if (cb[interleave] > best) {
                best = cb[interleave];
                il = interleave;
            }
            ++interleave;
        }
        if (best <= 1) {
            return false;
        }
        disk.setInterleave(il);
        return true;
    }

    public String getVersionText() {
        switch (this.getVersion()) {
            case 1: {
                return "3.1";
            }
            case 2: {
                return "3.2";
            }
            case 3: {
                return "3.3";
            }
            case 65: {
                return "4.1";
            }
            case 66: {
                return "4.2";
            }
            case 67: {
                return "4.3";
            }
        }
        return "??";
    }

    public int getVersion() {
        return this.dosVTOCSector.dosVersion;
    }

    private static int checkFormat(AppleDisk disk) {
        byte[] buffer = disk.readBlock(17, 0);
        if (debug) {
            System.out.printf("Sectors per track: %02X%n", buffer[53]);
        }
        if (buffer[53] != 16 && buffer[53] != 13 && buffer[53] != 32) {
            if (debug) {
                System.out.printf("Bad sectors per track : %02X%n", buffer[53]);
            }
            return 0;
        }
        int version = buffer[3] & 0xFF;
        if (debug) {
            System.out.printf("Version: %02X%n", buffer[3]);
        }
        if (version == 0 || version > 67 && version != 255) {
            if (debug) {
                System.out.printf("Bad version : %02X%n", version);
            }
            return 0;
        }
        int catalogBlocks = DosDisk.countCatalogBlocks(disk, buffer);
        if (debug) {
            System.out.printf("Catalog blocks: %s%n", catalogBlocks);
        }
        if (catalogBlocks > 0) {
            disk.setDosVersion(version);
        }
        return catalogBlocks;
    }

    private static int countCatalogBlocks(AppleDisk disk, byte[] buffer) {
        if (!disk.isValidAddress(buffer[1], buffer[2])) {
            if (debug) {
                System.out.printf("Invalid address1: %02X %02X%n", buffer[1], buffer[2]);
            }
            return 0;
        }
        DiskAddress catalogStart = disk.getDiskAddress(buffer[1], buffer[2]);
        DiskAddress da = disk.getDiskAddress(catalogStart.getBlockNo());
        ArrayList<DiskAddress> catalogAddresses = new ArrayList<DiskAddress>();
        do {
            if (debug) {
                System.out.printf("Checking: %s%n", da);
            }
            if (!disk.isValidAddress(da)) {
                if (debug) {
                    System.out.printf("Invalid address: %s%n", da);
                }
                return 0;
            }
            if (DosDisk.isDuplicate(catalogAddresses, da)) {
                if (debug) {
                    System.out.println("Catalog looping");
                }
                return 0;
            }
            buffer = disk.readBlock(da);
            if (!disk.isValidAddress(buffer[1], buffer[2])) {
                if (debug) {
                    System.out.printf("Invalid address2: %02X %02X%n", buffer[1], buffer[2]);
                }
                return catalogAddresses.size();
            }
            catalogAddresses.add(da);
        } while (!(da = disk.getDiskAddress(buffer[1], buffer[2])).isZero());
        if (debug) {
            System.out.printf("Catalog blocks: %d%n", catalogAddresses.size());
        }
        return catalogAddresses.size();
    }

    private static boolean isDuplicate(List<DiskAddress> catalogAddresses, DiskAddress da) {
        for (DiskAddress diskAddress : catalogAddresses) {
            if (diskAddress.getBlockNo() != da.getBlockNo()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Disk name ............. %s%n", this.getDisplayPath()));
        text.append(String.format("DOS version ........... %s%n", this.dosVTOCSector.dosVersion));
        text.append(String.format("Sectors per track ..... %d%n", this.dosVTOCSector.maxSectors));
        text.append(String.format("Volume no ............. %d%n", this.volumeNo));
        text.append(String.format("Interleave ............ %d", this.disk.getInterleave()));
        return text.toString();
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        SectorType type = this.sectorTypes[da.getBlockNo()];
        if (type == this.vtocSector) {
            return this.dosVTOCSector;
        }
        if (da.isZero()) {
            return this.bootSector;
        }
        byte[] buffer = this.disk.readBlock(da);
        String address = String.format("%02X %02X", da.getTrackNo(), da.getSectorNo());
        if (type == this.tsListSector) {
            return new DosTSListSector(this.getSectorFilename(da), this.disk, buffer, da);
        }
        if (type == this.catalogSector) {
            return new DosCatalogSector(this, this.disk, buffer, da);
        }
        if (type == this.dataSector) {
            return new DefaultSector("Data Sector at " + address + " : " + this.getSectorFilename(da), this.disk, buffer, da);
        }
        if (type == this.dosSector) {
            return new DefaultSector("DOS sector at " + address, this.disk, buffer, da);
        }
        return super.getFormattedSector(da);
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        if (this.fileEntries.size() > 0 && this.fileEntries.size() > fileNo) {
            return ((AppleFileSource)this.fileEntries.get(fileNo)).getSectors();
        }
        return null;
    }

    private int countEntries(AppleFileSource catalogEntry) {
        int count = 0;
        for (AppleFileSource ce : this.fileEntries) {
            if (!ce.getUniqueName().equals(catalogEntry.getUniqueName())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public AppleFileSource getCatalog() {
        String newLine = String.format("%n", new Object[0]);
        String underline = "- --- ---  ------------------------------  -----  -------------  -- ----  -------------------" + newLine;
        StringBuilder text = new StringBuilder();
        text.append(String.format("File : %s%n%n", this.getDisplayPath()));
        text.append("L Typ Len  Name                            Addr   Length         TS Data  Comment" + newLine);
        text.append(underline);
        for (AppleFileSource fileEntry : this.fileEntries) {
            String entry = ((CatalogEntry)fileEntry).getDetails();
            if (this.countEntries(fileEntry) > 1) {
                entry = String.valueOf(entry) + "** duplicate **";
            }
            text.append(String.valueOf(entry) + newLine);
        }
        text.append(underline);
        text.append(String.format("           Free sectors: %3d    Used sectors: %3d    Total sectors: %3d", this.dosVTOCSector.freeSectors, this.dosVTOCSector.usedSectors, this.dosVTOCSector.freeSectors + this.dosVTOCSector.usedSectors));
        if (this.dosVTOCSector.freeSectors != this.freeSectors) {
            text.append(String.format("%nActual:    Free sectors: %3d    Used sectors: %3d    Total sectors: %3d", this.freeSectors, this.usedSectors, this.usedSectors + this.freeSectors));
        }
        String volumeText = this.volumeNo == 0 ? "" : "Side " + this.volumeNo + " ";
        return new DefaultAppleFileSource(String.valueOf(volumeText) + "DOS Volume " + this.dosVTOCSector.volume, text.toString(), (FormattedDisk)this);
    }

    private AppleFileSource getDeletedList() {
        StringBuilder text = new StringBuilder("List of files that were deleted from this disk\n");
        for (AppleFileSource afs : this.deletedFileEntries) {
            text.append(String.valueOf(((DeletedCatalogEntry)afs).getDetails()) + "\n");
        }
        return new DefaultAppleFileSource("Deleted files", text.toString(), (FormattedDisk)this);
    }

    static enum FileType {
        Text,
        ApplesoftBasic,
        IntegerBasic,
        Binary,
        SS,
        Relocatable,
        AA,
        BB;

    }
}

