/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.disk.AppleDiskAddress;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.dos.AbstractCatalogEntry;
import com.bytezone.diskbrowser.dos.DosDisk;
import com.bytezone.diskbrowser.utilities.Utility;

class CatalogEntry
extends AbstractCatalogEntry {
    private int textFileGaps;
    private int length;
    private int address;

    CatalogEntry(DosDisk dosDisk, DiskAddress catalogSector, byte[] entryBuffer) {
        super(dosDisk, catalogSector, entryBuffer);
        DiskAddress da;
        if (this.disk.isValidAddress(entryBuffer[0], entryBuffer[1])) {
            da = this.disk.getDiskAddress(entryBuffer[0], entryBuffer[1]);
            block3: while (!da.isZero() || ((AppleDiskAddress)da).zeroFlag()) {
                if (dosDisk.stillAvailable(da)) {
                    if (!this.isValidCatalogSector(da)) {
                        System.out.printf("Attempt to assign invalid TS sector : %s from %s%n", da, this.name);
                        break;
                    }
                } else {
                    System.out.printf("Attempt to assign TS sector to occupied sector : %s from %s%n", da, this.name);
                    break;
                }
                dosDisk.sectorTypes[da.getBlockNo()] = dosDisk.tsListSector;
                this.tsSectors.add(da);
                byte[] sectorBuffer = this.disk.readBlock(da);
                int startPtr = 12;
                DiskAddress thisDA = da;
                int i = startPtr;
                int max = this.disk.getBlockSize();
                while (i < max) {
                    da = this.getValidAddress(sectorBuffer, i);
                    if (da == null) {
                        System.out.printf("T/S list at offset %02X contains an invalid address : %02X, %02X (file %s)%n", i, sectorBuffer[i], sectorBuffer[i + 1], this.name.trim());
                        break block3;
                    }
                    if (da.isZero() && !((AppleDiskAddress)da).zeroFlag()) {
                        if (this.fileType != DosDisk.FileType.Text) break;
                        ++this.textFileGaps;
                        this.dataSectors.add(null);
                    } else {
                        this.dataSectors.add(da);
                        if (dosDisk.stillAvailable(da)) {
                            dosDisk.sectorTypes[da.getBlockNo()] = dosDisk.dataSector;
                        } else {
                            System.out.print("Attempt to assign Data sector to occupied sector : " + da);
                            System.out.println(" from " + this.name);
                        }
                    }
                    i += 2;
                }
                da = this.getValidAddress(sectorBuffer, 1);
                if (da == null) {
                    System.out.print("Next T/S list in sector " + thisDA);
                    System.out.printf(" is invalid : %02X, %02X%n", sectorBuffer[1], sectorBuffer[2]);
                    break;
                }
                if (!thisDA.matches(da) || ((AppleDiskAddress)thisDA).zeroFlag() != ((AppleDiskAddress)da).zeroFlag()) continue;
                System.out.printf("Next T/S list in sector %s points to itself%n", thisDA);
                break;
            }
        }
        if (this.fileType == DosDisk.FileType.Text) {
            while (this.dataSectors.size() > 0) {
                da = (DiskAddress)this.dataSectors.get(this.dataSectors.size() - 1);
                if (da == null) {
                    this.dataSectors.remove(this.dataSectors.size() - 1);
                    --this.textFileGaps;
                    continue;
                }
                break;
            }
        } else if (this.dataSectors.size() > 0) {
            byte[] buffer = this.disk.readBlock((DiskAddress)this.dataSectors.get(0));
            switch (this.fileType) {
                case ApplesoftBasic: 
                case IntegerBasic: {
                    this.length = Utility.getShort(buffer, 0);
                    break;
                }
                default: {
                    this.address = Utility.getShort(buffer, 0);
                    this.length = Utility.getShort(buffer, 2);
                }
            }
        }
    }

    private boolean isValidCatalogSector(DiskAddress da) {
        byte[] buffer = da.readBlock();
        if (!da.getDisk().isValidAddress(buffer[1], buffer[2])) {
            return false;
        }
        return buffer[3] == 0 && buffer[4] == 0 || da.getTrackNo() == (buffer[3] & 0xFF) || da.getSectorNo() == (buffer[4] & 0xFF);
    }

    String getDetails() {
        String lockedFlag;
        int actualSize = this.dataSectors.size() + this.tsSectors.size() - this.textFileGaps;
        String addressText = this.address == 0 ? "" : String.format("$%4X", this.address);
        String lengthText = this.length == 0 ? "" : String.format("$%4X  %,6d", this.length, this.length);
        String message = "";
        String string = lockedFlag = this.locked ? "*" : " ";
        if (this.dosDisk.dosVTOCSector.dosVersion >= 65) {
            message = this.lastModified.toString().replace('T', ' ');
        }
        if (this.reportedSize != actualSize) {
            message = String.valueOf(message) + "Actual size (" + actualSize + ") ";
        }
        if (this.reportedSize > 999) {
            message = String.valueOf(message) + "Reported " + this.reportedSize;
        }
        String text = String.format("%1s  %1s  %03d  %-30.30s  %-5s  %-13s %3d %3d   %s", lockedFlag, this.getFileType(), this.reportedSize % 1000, this.displayName, addressText, lengthText, this.tsSectors.size(), this.dataSectors.size() - this.textFileGaps, message.trim());
        return text;
    }
}

