/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class PrefixDiskCopy {
    private String name;
    private int dataSize;
    private int tagSize;
    private int dataChecksum;
    private int tagChecksum;
    private int diskFormat;
    private int format;
    private int id;

    public PrefixDiskCopy(byte[] buffer) {
        int nameLength = buffer[0] * 255;
        if (nameLength < 1 || nameLength > 63) {
            this.name = HexFormatter.getPascalString(buffer, 0);
        }
        this.dataSize = Utility.getLongBigEndian(buffer, 64);
        this.tagSize = Utility.getLongBigEndian(buffer, 68);
        this.dataChecksum = Utility.getLongBigEndian(buffer, 72);
        this.tagChecksum = Utility.getLongBigEndian(buffer, 76);
        this.diskFormat = buffer[80] & 0xFF;
        this.format = buffer[81] & 0xFF;
        this.id = Utility.getShortBigEndian(buffer, 82);
    }

    int getBlocks() {
        return this.dataSize / 512;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Name          : %s%n", this.name));
        text.append(String.format("Data size     : %08X (%<,d)%n", this.dataSize));
        text.append(String.format("Tag size      : %08X (%<,d)%n", this.tagSize));
        text.append(String.format("Data checksum : %08X (%<,d)%n", this.dataChecksum));
        text.append(String.format("Tag checksum  : %08X (%<,d)%n", this.tagChecksum));
        text.append(String.format("Disk format   : %02X%n", this.diskFormat));
        text.append(String.format("Format byte   : %02X%n", this.format));
        text.append(String.format("ID            : %04X%n", this.id));
        return text.toString();
    }
}

