/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultDataSource;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.DataSource;
import java.util.List;

public class DefaultAppleFileSource
implements AppleFileSource {
    final String title;
    final DataSource file;
    final FormattedDisk owner;
    List<DiskAddress> blocks;

    public DefaultAppleFileSource(String text, FormattedDisk owner) {
        this("", text, owner);
    }

    public DefaultAppleFileSource(String title, String text, FormattedDisk owner) {
        this(title, new DefaultDataSource(text), owner);
    }

    public DefaultAppleFileSource(String title, DataSource file, FormattedDisk owner) {
        this.title = title;
        this.file = file;
        this.owner = owner;
    }

    public DefaultAppleFileSource(String title, DataSource file, FormattedDisk owner, List<DiskAddress> blocks) {
        this(title, file, owner);
        this.blocks = blocks;
        if (file instanceof DefaultDataSource var5_6) {
            dds.buffer = owner.getDisk().readBlocks(blocks);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSectors(List<DiskAddress> blocks) {
        void var3_2;
        DefaultDataSource defaultDataSource;
        this.blocks = blocks;
        DataSource dataSource = this.file;
        if (dataSource instanceof DefaultDataSource && (defaultDataSource = (DefaultDataSource)dataSource) == (DefaultDataSource)var3_2) {
            dds.buffer = this.owner.getDisk().readBlocks(blocks);
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.file;
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.owner;
    }

    @Override
    public List<DiskAddress> getSectors() {
        return this.blocks;
    }

    public String toString() {
        int MAX_NAME_LENGTH = 40;
        int SUFFIX_LENGTH = 12;
        int PREFIX_LENGTH = 25;
        if (this.title.length() > 40) {
            return String.valueOf(this.title.substring(0, 25)) + "..." + this.title.substring(this.title.length() - 12);
        }
        return this.title;
    }

    @Override
    public String getUniqueName() {
        return this.title;
    }

    @Override
    public boolean contains(DiskAddress diskAddress) {
        for (DiskAddress da : this.blocks) {
            if (!da.matches(diskAddress)) continue;
            return true;
        }
        return false;
    }
}

