/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.disk.AppleDiskAddress;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.Prefix2mg;
import com.bytezone.diskbrowser.disk.PrefixDiskCopy;
import com.bytezone.diskbrowser.nib.NibFile;
import com.bytezone.diskbrowser.nib.V2dFile;
import com.bytezone.diskbrowser.nib.WozFile;
import com.bytezone.diskbrowser.nufx.Binary2;
import com.bytezone.diskbrowser.nufx.NuFX;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;

public class AppleDisk
implements Disk {
    private static final int MAX_INTERLEAVE = 3;
    private static final int SECTOR_SIZE = 256;
    private static final int BLOCK_SIZE = 512;
    public final File file;
    private final byte[] diskBuffer;
    private final int tracks;
    private int sectors;
    private int blocks;
    private int dosVersion;
    private final int trackSize;
    public int sectorSize;
    private NuFX nuFX;
    private Binary2 bin2;
    private WozFile wozFile;
    private PrefixDiskCopy prefixDiskCopy;
    private Prefix2mg prefix2mg;
    private int interleave = 0;
    private static int[][] interleaveSector;
    private boolean[] hasData;
    private byte emptyByte = 0;
    private ActionListener actionListenerList;
    private List<DiskAddress> blockList;
    private final boolean debug = false;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[32];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 26;
        nArray[27] = 27;
        nArray[28] = 28;
        nArray[29] = 29;
        nArray[30] = 30;
        nArray[31] = 31;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 14;
        nArray2[2] = 13;
        nArray2[3] = 12;
        nArray2[4] = 11;
        nArray2[5] = 10;
        nArray2[6] = 9;
        nArray2[7] = 8;
        nArray2[8] = 7;
        nArray2[9] = 6;
        nArray2[10] = 5;
        nArray2[11] = 4;
        nArray2[12] = 3;
        nArray2[13] = 2;
        nArray2[14] = 1;
        nArray2[15] = 15;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 13;
        nArray3[2] = 11;
        nArray3[3] = 9;
        nArray3[4] = 7;
        nArray3[5] = 5;
        nArray3[6] = 3;
        nArray3[7] = 1;
        nArray3[8] = 14;
        nArray3[9] = 12;
        nArray3[10] = 10;
        nArray3[11] = 8;
        nArray3[12] = 6;
        nArray3[13] = 4;
        nArray3[14] = 2;
        nArray3[15] = 15;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[16];
        nArray4[1] = 6;
        nArray4[2] = 12;
        nArray4[3] = 3;
        nArray4[4] = 9;
        nArray4[5] = 15;
        nArray4[6] = 14;
        nArray4[7] = 5;
        nArray4[8] = 11;
        nArray4[9] = 2;
        nArray4[10] = 8;
        nArray4[11] = 7;
        nArray4[12] = 13;
        nArray4[13] = 4;
        nArray4[14] = 10;
        nArray4[15] = 1;
        nArrayArray[3] = nArray4;
        interleaveSector = nArrayArray;
    }

    public AppleDisk(File file, int tracks, int sectors) throws FileFormatException {
        this(file, tracks, sectors, 0);
    }

    public AppleDisk(File file, int tracks, int sectors, int skip) throws FileFormatException {
        assert (file.exists()) : "No such path :" + file.getAbsolutePath();
        assert (!file.isDirectory()) : "File is directory :" + file.getAbsolutePath();
        assert (file.length() <= Integer.MAX_VALUE) : "File too large";
        assert (file.length() != 0L) : "File empty";
        String fileName = file.getName();
        int pos = fileName.lastIndexOf(46);
        String suffix = pos > 0 ? fileName.substring(pos + 1) : "";
        byte[] buffer = this.getPrefix(file);
        String prefix = new String(buffer, 0, 4);
        if ("2mg".equalsIgnoreCase(suffix) || "2IMG".equals(prefix)) {
            if ("2IMG".equals(prefix)) {
                this.prefix2mg = new Prefix2mg(buffer);
                if (this.prefix2mg.length > 0) {
                    this.blocks = this.prefix2mg.length / 4096 * 8;
                }
                this.sectorSize = 512;
                this.trackSize = 8 * this.sectorSize;
                skip = this.prefix2mg.headerSize;
                tracks = this.blocks / 8;
                sectors = 8;
            } else {
                System.out.println("Not a 2mg file");
                this.blocks = (int)file.length() / 4096 * 8;
                tracks = this.blocks / 8;
                sectors = 8;
                this.sectorSize = 512;
                this.trackSize = sectors * this.sectorSize;
            }
        } else if ("img".equals(suffix) || "dimg".equals(suffix)) {
            this.prefixDiskCopy = new PrefixDiskCopy(buffer);
            this.blocks = this.prefixDiskCopy.getBlocks();
            this.sectorSize = 512;
            this.trackSize = 8 * this.sectorSize;
            skip = 84;
            tracks = this.blocks / 8;
            sectors = 8;
        } else if (suffix.equalsIgnoreCase("HDV") || suffix.equalsIgnoreCase("po") && tracks > 50) {
            this.blocks = tracks * sectors;
            this.sectorSize = 512;
            this.trackSize = sectors * this.sectorSize;
        } else if (file.length() == 143360L && tracks == 256 && sectors == 8) {
            this.blocks = tracks * sectors;
            this.sectorSize = 512;
            this.trackSize = sectors * this.sectorSize;
        } else if (file.length() == 819200L && tracks == 50 && sectors == 32) {
            this.blocks = tracks * sectors;
            this.sectorSize = 256;
            this.trackSize = sectors * this.sectorSize;
        } else {
            this.blocks = tracks * sectors;
            this.sectorSize = (int)file.length() / this.blocks;
            this.trackSize = sectors * this.sectorSize;
        }
        if (this.sectorSize != 256 && this.sectorSize != 512) {
            throw new FileFormatException("Invalid sector size : " + this.sectorSize);
        }
        this.file = file;
        this.tracks = tracks;
        this.sectors = sectors;
        this.diskBuffer = new byte[this.blocks * this.sectorSize];
        this.hasData = new boolean[this.blocks];
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                if (skip > 0) {
                    in.skip(skip);
                }
                in.read(this.diskBuffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.checkSectorsForData();
    }

    void switchToDos() {
        this.sectorSize = 256;
        this.sectors = 16;
        this.blocks = 560;
        this.hasData = new boolean[this.blocks];
        this.checkSectorsForData();
    }

    void setNuFX(NuFX nufx) {
        this.nuFX = nufx;
    }

    void setBinary2(Binary2 bin2) {
        this.bin2 = bin2;
    }

    public AppleDisk(V2dFile disk, int tracks, int sectors) {
        this.tracks = tracks;
        this.sectors = sectors;
        this.file = disk.file;
        this.diskBuffer = disk.getDiskBuffer();
        this.trackSize = 4096;
        this.sectorSize = this.trackSize / sectors;
        this.blocks = tracks * sectors;
        this.hasData = new boolean[this.blocks];
        this.checkSectorsForData();
    }

    public AppleDisk(NibFile disk) {
        this.tracks = 35;
        this.trackSize = 4096;
        this.file = disk.file;
        this.diskBuffer = disk.getDiskBuffer();
    }

    public AppleDisk(WozFile wozFile, int tracks, int sectors) {
        this.wozFile = wozFile;
        this.tracks = tracks;
        this.sectors = sectors;
        this.file = wozFile.file;
        this.diskBuffer = wozFile.getDiskBuffer();
        if (sectors == 13) {
            this.trackSize = 3328;
            this.sectorSize = 256;
        } else {
            this.trackSize = 4096;
            this.sectorSize = this.trackSize / sectors;
        }
        this.blocks = tracks * sectors;
        this.hasData = new boolean[this.blocks];
        this.checkSectorsForData();
    }

    private byte[] getPrefix(File path) {
        byte[] buffer = new byte[84];
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream file = new BufferedInputStream(new FileInputStream(path));){
                file.read(buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return buffer;
    }

    private void checkSectorsForData() {
        this.blockList = null;
        for (DiskAddress da : this) {
            if (this.sectorSize == 256) {
                int diskOffset = this.getBufferOffset(da);
                this.hasData[da.getBlockNo()] = this.check(diskOffset);
                continue;
            }
            int diskOffset1 = this.getBufferOffset(da, 0);
            int diskOffset2 = this.getBufferOffset(da, 1);
            boolean bl = this.hasData[da.getBlockNo()] = this.check(diskOffset1) || this.check(diskOffset2);
        }
    }

    private boolean check(int diskOffset) {
        int i = diskOffset;
        int max = diskOffset + 256;
        while (i < max) {
            if (this.diskBuffer[i] != this.emptyByte) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDosVersion(int version) {
        this.dosVersion = version;
    }

    @Override
    public int getBlocksPerTrack() {
        return this.trackSize / this.sectorSize;
    }

    @Override
    public int getTrackSize() {
        return this.trackSize;
    }

    @Override
    public int getBlockSize() {
        return this.sectorSize;
    }

    @Override
    public int getTotalBlocks() {
        return this.blocks;
    }

    @Override
    public int getTotalTracks() {
        return this.tracks;
    }

    @Override
    public boolean isBlockEmpty(DiskAddress da) {
        return !this.hasData[da.getBlockNo()];
    }

    @Override
    public boolean isBlockEmpty(int block) {
        return !this.hasData[block];
    }

    @Override
    public boolean isBlockEmpty(int track, int sector) {
        return !this.hasData[this.getDiskAddress(track, sector).getBlockNo()];
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public byte[] readBlock(DiskAddress da) {
        byte[] buffer = new byte[this.sectorSize];
        if (da == null) {
            System.out.println("Disk address is null");
        } else {
            this.readBuffer(da, buffer, 0);
        }
        return buffer;
    }

    @Override
    public byte[] readBlocks(List<DiskAddress> daList) {
        byte[] buffer = new byte[daList.size() * this.sectorSize];
        int ptr = 0;
        for (DiskAddress da : daList) {
            if (da != null && (da.getBlockNo() > 0 || ((AppleDiskAddress)da).zeroFlag())) {
                this.readBuffer(da, buffer, ptr);
            }
            ptr += this.sectorSize;
        }
        return buffer;
    }

    @Override
    public byte[] readBlock(int track, int sector) {
        return this.readBlock(this.getDiskAddress(track, sector));
    }

    @Override
    public byte[] readBlock(int block) {
        return this.readBlock(this.getDiskAddress(block));
    }

    @Override
    public void writeBlock(DiskAddress da, byte[] buffer) {
        this.writeBuffer(da, buffer);
    }

    @Override
    public void setInterleave(int interleave) {
        assert (interleave >= 0 && interleave <= 3) : "Invalid interleave";
        this.interleave = interleave;
        this.checkSectorsForData();
        if (this.actionListenerList != null) {
            this.notifyListeners("Interleave changed");
        }
    }

    @Override
    public int getInterleave() {
        return this.interleave;
    }

    @Override
    public void setBlockSize(int size) {
        assert (size == 256 || size == 512) : "Invalid sector size : " + size;
        if (this.sectorSize == size) {
            return;
        }
        this.sectorSize = size;
        this.sectors = this.trackSize / this.sectorSize;
        this.blocks = this.tracks * this.sectors;
        this.hasData = new boolean[this.blocks];
        this.checkSectorsForData();
        if (this.actionListenerList != null) {
            this.notifyListeners("Sector size changed");
        }
    }

    @Override
    public DiskAddress getDiskAddress(int track, int sector) {
        if (!this.isValidAddress(track, sector)) {
            System.out.println("Invalid block : " + track + "/" + sector);
            return null;
        }
        return new AppleDiskAddress(this, track, sector);
    }

    @Override
    public DiskAddress getDiskAddress(int block) {
        if (!this.isValidAddress(block)) {
            System.out.printf("getDiskAddress: Invalid block : %d of %d%n", block, this.blocks);
            return null;
        }
        return new AppleDiskAddress(this, block);
    }

    @Override
    public List<DiskAddress> getDiskAddressList(int ... blocks) {
        ArrayList<DiskAddress> addressList = new ArrayList<DiskAddress>();
        int[] nArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            int block = nArray[n2];
            assert (this.isValidAddress(block)) : "Invalid block : " + block;
            addressList.add(new AppleDiskAddress(this, block));
            ++n2;
        }
        return addressList;
    }

    @Override
    public boolean isValidAddress(int block) {
        return block >= 0 && block < this.blocks;
    }

    @Override
    public boolean isValidAddress(int track, int sector) {
        if (this.dosVersion >= 65) {
            track &= 0x3F;
            sector &= 0x1F;
        }
        if (track < 0 || track >= this.tracks) {
            return false;
        }
        return sector >= 0 && sector < this.sectors;
    }

    @Override
    public boolean isValidAddress(DiskAddress da) {
        return da != null && this.isValidAddress(da.getTrackNo(), da.getSectorNo());
    }

    private void readBuffer(DiskAddress da, byte[] buffer, int bufferOffset) {
        assert (da.getDisk() == this) : "Disk address not applicable to this disk";
        assert (this.sectorSize == 256 || this.sectorSize == 512) : "Invalid sector size : " + this.sectorSize;
        assert (this.interleave >= 0 && this.interleave <= 3) : "Invalid interleave : " + this.interleave;
        if (this.sectorSize == 256) {
            int diskOffset = this.getBufferOffset(da);
            System.arraycopy(this.diskBuffer, diskOffset, buffer, bufferOffset, 256);
        } else {
            int diskOffset = this.getBufferOffset(da, 0);
            System.arraycopy(this.diskBuffer, diskOffset, buffer, bufferOffset, 256);
            diskOffset = this.getBufferOffset(da, 1);
            System.arraycopy(this.diskBuffer, diskOffset, buffer, bufferOffset + 256, 256);
        }
    }

    private void writeBuffer(DiskAddress da, byte[] buffer) {
        assert (da.getDisk() == this) : "Disk address not applicable to this disk";
        assert (this.sectorSize == 256 || this.sectorSize == 512) : "Invalid sector size : " + this.sectorSize;
        assert (this.interleave >= 0 && this.interleave <= 3) : "Invalid interleave : " + this.interleave;
        if (this.sectorSize == 256) {
            int diskOffset = this.getBufferOffset(da);
            System.arraycopy(buffer, 0, this.diskBuffer, diskOffset, 256);
        } else {
            int diskOffset = this.getBufferOffset(da, 0);
            System.arraycopy(buffer, 0, this.diskBuffer, diskOffset, 256);
            diskOffset = this.getBufferOffset(da, 1);
            System.arraycopy(buffer, 256, this.diskBuffer, diskOffset, 256);
        }
    }

    public byte[] getBuffer() {
        return this.diskBuffer;
    }

    private int getBufferOffset(DiskAddress da) {
        assert (this.sectorSize == 256);
        return da.getTrackNo() * this.trackSize + interleaveSector[this.interleave][da.getSectorNo()] * 256;
    }

    private int getBufferOffset(DiskAddress da, int seq) {
        assert (this.sectorSize == 512);
        assert (seq == 0 || seq == 1);
        return da.getTrackNo() * this.trackSize + interleaveSector[this.interleave][da.getSectorNo() * 2 + seq] * 256;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.add(this.actionListenerList, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.remove(this.actionListenerList, actionListener);
    }

    public void notifyListeners(String text) {
        if (this.actionListenerList != null) {
            this.actionListenerList.actionPerformed(new ActionEvent(this, 1001, text));
        }
    }

    public String toString() {
        String home;
        StringBuilder text = new StringBuilder();
        String path = this.file.getAbsolutePath();
        if (path.startsWith(home = System.getProperty("user.home"))) {
            path = "~" + path.substring(home.length());
        }
        text.append(String.format("Path ......... %s%n", path));
        text.append(String.format("File name .... %s%n", this.file.getName()));
        text.append(String.format("File size .... %,d%n", this.file.length()));
        text.append(String.format("Tracks ....... %d%n", this.tracks));
        text.append(String.format("Sectors ...... %d%n", this.sectors));
        text.append(String.format("Blocks ....... %,d%n", this.blocks));
        text.append(String.format("Track size ... %,d%n", this.trackSize));
        text.append(String.format("Sector size .. %d%n", this.sectorSize));
        text.append(String.format("Interleave ... %d%n%n", this.interleave));
        if (this.wozFile != null) {
            text.append(this.wozFile);
        } else if (this.nuFX != null) {
            text.append(this.nuFX);
        } else if (this.bin2 != null) {
            text.append(this.bin2);
        } else if (this.prefixDiskCopy != null) {
            text.append(this.prefixDiskCopy);
        } else if (this.prefix2mg != null) {
            text.append(this.prefix2mg);
        }
        return Utility.rtrim(text).toString();
    }

    @Override
    public Iterator<DiskAddress> iterator() {
        if (this.blockList == null) {
            this.blockList = new ArrayList<DiskAddress>(this.blocks);
            int block = 0;
            while (block < this.blocks) {
                this.blockList.add(new AppleDiskAddress(this, block));
                ++block;
            }
        }
        return this.blockList.iterator();
    }

    @Override
    public long getBootChecksum() {
        byte[] buffer = this.readBlock(0, 0);
        CRC32 checksum = new CRC32();
        checksum.update(buffer, 0, buffer.length);
        return checksum.getValue();
    }

    @Override
    public void setEmptyByte(byte value) {
        this.emptyByte = value;
        this.checkSectorsForData();
    }
}

