/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultDataSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractFormattedDisk
implements FormattedDisk {
    protected Disk disk;
    protected FormattedDisk parent;
    protected ActionListener actionListenerList;
    protected JTree catalogTree;
    protected Path originalPath;
    protected List<SectorType> sectorTypesList = new ArrayList<SectorType>();
    protected List<AppleFileSource> fileEntries = new ArrayList<AppleFileSource>();
    public SectorType[] sectorTypes;
    protected BootSector bootSector;
    public final SectorType emptySector = new SectorType("Unused (empty)", Color.white);
    public final SectorType usedSector = new SectorType("Unused (data)", Color.yellow);
    protected int falsePositives;
    protected int falseNegatives;
    protected Dimension gridLayout;
    protected BitSet freeBlocks;
    protected BitSet usedBlocks;

    public AbstractFormattedDisk(Disk disk) {
        this.disk = disk;
        this.freeBlocks = new BitSet(disk.getTotalBlocks());
        this.usedBlocks = new BitSet(disk.getTotalBlocks());
        this.sectorTypesList.add(this.emptySector);
        this.sectorTypesList.add(this.usedSector);
        this.setSectorTypes();
        this.setGridLayout();
        String name = this.getName();
        if (name.endsWith(".tmp")) {
            name = "tmp.dsk";
        }
        DefaultAppleFileSource afs = new DefaultAppleFileSource(name, new DefaultDataSource(disk), (FormattedDisk)this);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(afs);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.catalogTree = new JTree(treeModel);
        treeModel.setAsksAllowsChildren(true);
        disk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFormattedDisk.this.setSectorTypes();
            }
        });
    }

    protected void setEmptyByte(byte value) {
        this.getDisk().setEmptyByte(value);
        this.setSectorTypes();
    }

    private void setSectorTypes() {
        this.sectorTypes = new SectorType[this.disk.getTotalBlocks()];
        for (DiskAddress da : this.disk) {
            SectorType sectorType = this.sectorTypes[da.getBlockNo()] = this.disk.isBlockEmpty(da) ? this.emptySector : this.usedSector;
        }
        this.setGridLayout();
    }

    private void setGridLayout() {
        Dimension newGridLayout;
        int totalBlocks = this.disk.getTotalBlocks();
        block0 : switch (totalBlocks) {
            case 280: {
                Dimension dimension = new Dimension(8, 35);
                break;
            }
            case 455: {
                Dimension dimension = new Dimension(13, 35);
                break;
            }
            case 560: {
                Dimension dimension = new Dimension(16, 35);
                break;
            }
            case 704: {
                Dimension dimension = new Dimension(16, 44);
                break;
            }
            case 768: {
                Dimension dimension = new Dimension(16, 48);
                break;
            }
            case 800: {
                Dimension dimension = new Dimension(8, 100);
                break;
            }
            case 1600: {
                Dimension dimension;
                if (this.disk.getBlocksPerTrack() == 32) {
                    dimension = new Dimension(32, 50);
                    break;
                }
                dimension = new Dimension(16, 100);
                break;
            }
            case 2048: {
                Dimension dimension = new Dimension(8, 256);
                break;
            }
            case 3200: {
                Dimension dimension = new Dimension(16, 200);
                break;
            }
            default: {
                int[] sizes;
                Dimension dimension;
                int[] nArray = sizes = new int[]{32, 20, 16, 8};
                int n = sizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int size = nArray[n2];
                    if (totalBlocks % size == 0) {
                        dimension = new Dimension(size, totalBlocks / size);
                        break block0;
                    }
                    ++n2;
                }
                dimension = newGridLayout = null;
            }
        }
        if (newGridLayout == null) {
            System.out.println("Unusable total blocks : " + totalBlocks);
        } else {
            this.gridLayout = newGridLayout;
        }
    }

    @Override
    public Dimension getGridLayout() {
        return this.gridLayout;
    }

    @Override
    public Disk getDisk() {
        return this.disk;
    }

    @Override
    public FormattedDisk getParent() {
        return this.parent;
    }

    @Override
    public void setParent(FormattedDisk disk) {
        this.parent = disk;
    }

    @Override
    public void setOriginalPath(Path path) {
        this.originalPath = path;
        DefaultMutableTreeNode root = this.getCatalogTreeRoot();
        if (root.getUserObject() == null) {
            root.setUserObject(new DefaultAppleFileSource(this.getName(), this.disk.toString(), (FormattedDisk)this));
        }
    }

    @Override
    public Path getOriginalPath() {
        return this.originalPath;
    }

    @Override
    public String getAbsolutePath() {
        if (this.originalPath != null) {
            return this.originalPath.toString();
        }
        return this.disk.getFile().getAbsolutePath();
    }

    @Override
    public String getDisplayPath() {
        String path;
        String home = System.getProperty("user.home");
        String string = path = this.originalPath != null ? this.originalPath.toString() : this.disk.getFile().getAbsolutePath();
        if (path.startsWith(home)) {
            return "~" + path.substring(home.length());
        }
        return this.disk.getFile().getAbsolutePath();
    }

    @Override
    public boolean isTempDisk() {
        return this.originalPath != null;
    }

    @Override
    public String getName() {
        Path path;
        if (this.originalPath != null && (path = this.originalPath.getFileName()) != null) {
            return path.toString();
        }
        return this.disk.getFile().getName();
    }

    @Override
    public void writeFile(AbstractFile file) {
        System.out.println("not implemented yet");
    }

    @Override
    public List<AppleFileSource> getCatalogList() {
        return this.fileEntries;
    }

    @Override
    public AppleFileSource getFile(String uniqueName) {
        for (AppleFileSource afs : this.fileEntries) {
            if (!afs.getUniqueName().equals(uniqueName)) continue;
            return afs;
        }
        return null;
    }

    @Override
    public JTree getCatalogTree() {
        return this.catalogTree;
    }

    public DefaultMutableTreeNode getCatalogTreeRoot() {
        return (DefaultMutableTreeNode)this.catalogTree.getModel().getRoot();
    }

    public void makeNodeVisible(DefaultMutableTreeNode node) {
        this.catalogTree.makeVisible(new TreePath(((DefaultTreeModel)this.catalogTree.getModel()).getPathToRoot(node)));
    }

    protected DefaultMutableTreeNode findNode(DefaultMutableTreeNode node, String name) {
        Enumeration<TreeNode> children = node.breadthFirstEnumeration();
        if (children != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                if (childNode.getUserObject().toString().indexOf(name) <= 0) continue;
                return childNode;
            }
        }
        return null;
    }

    @Override
    public SectorType getSectorType(int block) {
        return this.getSectorType(this.disk.getDiskAddress(block));
    }

    @Override
    public SectorType getSectorType(int track, int sector) {
        return this.getSectorType(this.disk.getDiskAddress(track, sector));
    }

    @Override
    public SectorType getSectorType(DiskAddress da) {
        return this.sectorTypes[da.getBlockNo()];
    }

    @Override
    public List<SectorType> getSectorTypeList() {
        return this.sectorTypesList;
    }

    @Override
    public void setSectorType(int block, SectorType type) {
        if (block < this.sectorTypes.length) {
            this.sectorTypes[block] = type;
        } else {
            System.out.println("setSectorType: Invalid block number: " + block);
        }
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        if (da.isZero() && this.bootSector != null) {
            return this.bootSector;
        }
        SectorType sectorType = this.sectorTypes[da.getBlockNo()];
        byte[] buffer = this.disk.readBlock(da);
        String address = String.format("%02X", da.getBlockNo());
        if (sectorType == this.emptySector) {
            return new DefaultSector("Empty sector at " + address, this.disk, buffer, da);
        }
        if (sectorType == this.usedSector) {
            return new DefaultSector("Orphan sector at " + address, this.disk, buffer, da);
        }
        String name = this.getSectorFilename(da);
        if (!name.isEmpty()) {
            name = " : " + name;
        }
        return new DefaultSector("Data sector at " + address + name, this.disk, buffer, da);
    }

    @Override
    public AppleFileSource getCatalog() {
        return new DefaultAppleFileSource(this.disk.toString(), this);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        for (AppleFileSource entry : this.fileEntries) {
            if (!entry.contains(da)) continue;
            return entry.getUniqueName();
        }
        return "";
    }

    @Override
    public int clearOrphans() {
        System.out.println("Not implemented yet");
        return 0;
    }

    @Override
    public boolean isSectorFree(DiskAddress da) {
        return this.freeBlocks.get(da.getBlockNo());
    }

    @Override
    public boolean isSectorFree(int blockNo) {
        return this.freeBlocks.get(blockNo);
    }

    @Override
    public void setSectorFree(int block, boolean free) {
        if (block < 0 || block >= this.freeBlocks.size()) {
            System.out.printf("Block %d not in range : 0-%d%n", block, this.freeBlocks.size() - 1);
            return;
        }
        this.freeBlocks.set(block, free);
    }

    @Override
    public boolean stillAvailable(DiskAddress da) {
        return this.stillAvailable(da.getBlockNo());
    }

    @Override
    public boolean stillAvailable(int blockNo) {
        return this.sectorTypes[blockNo] == this.usedSector || this.sectorTypes[blockNo] == this.emptySector;
    }

    @Override
    public void verify() {
        System.out.println("Sectors to clean :");
        int i = 0;
        int max = this.disk.getTotalBlocks();
        while (i < max) {
            if (this.freeBlocks.get(i)) {
                if (this.sectorTypes[i] == this.usedSector) {
                    System.out.printf("%04X clean%n", i);
                }
            } else if (this.sectorTypes[i] == this.usedSector) {
                System.out.printf("%04X *** error ***%n", i);
            }
            ++i;
        }
    }

    @Override
    public int falsePositiveBlocks() {
        return this.falsePositives;
    }

    @Override
    public int falseNegativeBlocks() {
        return this.falseNegatives;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.add(this.actionListenerList, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.remove(this.actionListenerList, actionListener);
    }

    public void notifyListeners(String text) {
        if (this.actionListenerList != null) {
            this.actionListenerList.actionPerformed(new ActionEvent(this, 1001, text));
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Disk name ............. %s%n", this.getDisplayPath()));
        text.append(String.format("Block size..... %d%n", this.disk.getBlockSize()));
        text.append(String.format("Interleave..... %d", this.disk.getInterleave()));
        return text.toString();
    }
}

