/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.cpm;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.CPMBasicFile;
import com.bytezone.diskbrowser.applefile.CPMTextFile;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.cpm.CPMDisk;
import com.bytezone.diskbrowser.disk.AppleDiskAddress;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.List;

class DirectoryEntry
implements AppleFileSource {
    private final Disk disk;
    private final CPMDisk parent;
    private DataSource appleFile;
    private final int userNumber;
    private final String name;
    private final String type;
    private final int extent;
    private final int s1;
    private final int s2;
    private final int recordsUsed;
    private final byte[] blockList = new byte[16];
    private final List<DirectoryEntry> entries = new ArrayList<DirectoryEntry>();
    private final List<DiskAddress> blocks = new ArrayList<DiskAddress>();
    private final boolean readOnly;
    private final boolean systemFile;

    DirectoryEntry(CPMDisk parent, byte[] buffer, int offset) {
        this.parent = parent;
        this.disk = parent.getDisk();
        this.readOnly = (buffer[offset + 9] & 0x80) != 0;
        this.systemFile = (buffer[offset + 10] & 0x80) != 0;
        byte[] typeBuffer = new byte[]{(byte)(buffer[offset + 9] & 0x7F), (byte)(buffer[offset + 10] & 0x7F), (byte)(buffer[offset + 11] & 0x7F)};
        this.type = new String(typeBuffer).trim();
        this.userNumber = buffer[offset] & 0xFF;
        this.name = this.userNumber == 229 && buffer[offset + 1] == 0 ? "" : new String(buffer, offset + 1, 8).trim();
        this.extent = buffer[offset + 12] & 0xFF;
        this.s2 = buffer[offset + 13] & 0xFF;
        this.s1 = buffer[offset + 14] & 0xFF;
        this.recordsUsed = buffer[offset + 15] & 0xFF;
        System.arraycopy(buffer, offset + 16, this.blockList, 0, 16);
        Disk disk = parent.getDisk();
        byte[] byArray = this.blockList;
        int n = this.blockList.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b == 0) break;
            int blockNumber = (b & 0x80) == 0 ? b * 4 + 48 : (b & 0x7F) * 4;
            int i = 0;
            while (i < 4) {
                this.blocks.add(new AppleDiskAddress(disk, blockNumber + i));
                ++i;
            }
            ++n2;
        }
    }

    String getType() {
        return this.type;
    }

    boolean matches(DirectoryEntry directoryEntry) {
        return this.userNumber == directoryEntry.userNumber && this.name.equals(directoryEntry.name) && this.type.equals(directoryEntry.type);
    }

    void add(DirectoryEntry entry) {
        this.entries.add(entry);
        Disk disk = this.parent.getDisk();
        byte[] byArray = entry.blockList;
        int n = entry.blockList.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b == 0) break;
            int blockNumber = b * 4 + 48;
            int i = 0;
            while (i < 4) {
                this.blocks.add(new AppleDiskAddress(disk, blockNumber + i));
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public boolean contains(DiskAddress da) {
        for (DiskAddress sector : this.blocks) {
            if (!sector.matches(da)) continue;
            return true;
        }
        return false;
    }

    String line() {
        String bytes = HexFormatter.getHexString(this.blockList, 0, 16);
        bytes = bytes.replaceAll("00", "  ");
        char ro = this.readOnly ? (char)'*' : ' ';
        char sf = this.systemFile ? (char)'*' : ' ';
        String text = String.format("%3d   %-8s   %-3s %s %s  %02X   %02X   %02X   %02X   %s", this.userNumber, this.name, this.type, Character.valueOf(ro), Character.valueOf(sf), this.extent, this.s2, this.s1, this.recordsUsed, bytes);
        for (DirectoryEntry entry : this.entries) {
            text = String.valueOf(text) + "\n" + entry.line();
        }
        if (this.extent != 0) {
            text = "                    " + text.substring(20);
        }
        return text;
    }

    String toDetailedString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("User number .... %d%n", this.userNumber));
        text.append(String.format("File name ...... %s%n", String.valueOf(this.name) + "." + this.type));
        text.append(String.format("Extents lo ..... %d%n", this.extent));
        text.append(String.format("Extents hi ..... %d%n", this.s2));
        text.append(String.format("Reserved ....... %d%n", this.s1));
        int blocks = ((this.recordsUsed & 0xF0) >> 3) + ((this.recordsUsed & 0xF) + 7) / 8;
        text.append(String.format("Records ........ %02X  (%d)%n", this.recordsUsed, blocks));
        String bytes = HexFormatter.getHexString(this.blockList, 0, 16);
        text.append(String.format("Allocation ..... %s%n", bytes));
        for (DirectoryEntry entry : this.entries) {
            bytes = HexFormatter.getHexString(entry.blockList, 0, 16);
            text.append(String.format("                 %s%n", bytes));
        }
        return text.toString();
    }

    @Override
    public String getUniqueName() {
        return String.valueOf(this.name) + "." + this.type;
    }

    @Override
    public DataSource getDataSource() {
        if (this.appleFile != null) {
            return this.appleFile;
        }
        byte[] buffer = this.disk.readBlocks(this.blocks);
        if (buffer.length == 0) {
            this.appleFile = new DefaultAppleFile(this.name, buffer);
            return this.appleFile;
        }
        DirectoryEntry entry = this.recordsUsed == 128 ? this.entries.get(this.entries.size() - 1) : this;
        int len = (entry.extent * 128 + entry.recordsUsed) * 128;
        if (len > buffer.length) {
            System.out.println("too big");
            len = buffer.length;
        }
        byte[] exactBuffer = new byte[len];
        System.arraycopy(buffer, 0, exactBuffer, 0, len);
        this.appleFile = "COM".equals(this.type) ? new DefaultAppleFile(this.name, exactBuffer, "COM File") : ("DVR".equals(this.type) ? new DefaultAppleFile(this.name, exactBuffer, "DVR File") : ("ASM".equals(this.type) || "DOC".equals(this.type) || "COB".equals(this.type) || "HLP".equals(this.type) || "TXT".equals(this.type) || "LET".equals(this.type) || "ALX".equals(this.type) || "SRC".equals(this.type) || "H".equals(this.type) || exactBuffer[len - 1] == 26 ? new CPMTextFile(this.name, exactBuffer) : ("BAS".equals(this.type) ? new CPMBasicFile(this.name, exactBuffer) : new DefaultAppleFile(this.name, exactBuffer, "CPM File : " + this.type))));
        return this.appleFile;
    }

    @Override
    public List<DiskAddress> getSectors() {
        return this.blocks;
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.parent;
    }

    public String toString() {
        return String.valueOf(this.name) + "." + this.type;
    }
}

