/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.cpm;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;

class CPMCatalogSector
extends AbstractSector {
    private static int CATALOG_ENTRY_SIZE = 32;

    CPMCatalogSector(Disk disk, byte[] buffer, DiskAddress diskAddress) {
        super(disk, buffer, diskAddress);
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Catalog Sector");
        int i = 0;
        while (i <= 255) {
            String extra;
            String type;
            boolean unknown;
            int userNumber;
            if (this.buffer[i] == -27 && this.buffer[i + 1] == -27 || (userNumber = this.buffer[i] & 0xFF) > 31 && userNumber != -27) break;
            boolean readOnly = (this.buffer[i + 9] & 0x80) != 0;
            boolean systemFile = (this.buffer[i + 10] & 0x80) != 0;
            boolean bl = unknown = (this.buffer[i + 11] & 0x80) != 0;
            if (readOnly || systemFile || unknown) {
                byte[] typeBuffer = new byte[]{(byte)(this.buffer[i + 9] & 0x7F), (byte)(this.buffer[i + 10] & 0x7F), (byte)(this.buffer[i + 11] & 0x7F)};
                type = new String(typeBuffer).trim();
                extra = String.format(" (%s%s%s)", readOnly ? "read only" : "", systemFile ? "system file" : "", unknown ? "unknown" : "");
            } else {
                type = new String(this.buffer, i + 9, 3).trim();
                extra = "";
            }
            if (this.buffer[i] == -27) {
                this.addText(text, this.buffer, i, 1, "Deleted file?");
            } else {
                this.addText(text, this.buffer, i, 1, "User number");
            }
            if (this.buffer[i + 1] == 0) {
                this.addText(text, this.buffer, i + 1, 4, "File name : ");
            } else {
                this.addText(text, this.buffer, i + 1, 4, "File name : " + new String(this.buffer, i + 1, 8));
            }
            this.addText(text, this.buffer, i + 5, 4, "");
            this.addText(text, this.buffer, i + 9, 3, "File type : " + type + extra);
            this.addText(text, this.buffer, i + 12, 1, "Extent counter LO");
            this.addText(text, this.buffer, i + 13, 1, "Reserved");
            this.addText(text, this.buffer, i + 14, 1, "Extent counter HI");
            this.addText(text, this.buffer, i + 15, 1, "Record count");
            int j = 0;
            while (j < 4) {
                this.addText(text, this.buffer, i + 16 + j * 4, 4, "");
                ++j;
            }
            text.append("\n");
            i += CATALOG_ENTRY_SIZE;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

