/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.appleworks.AppleworksADBFile;
import com.bytezone.diskbrowser.utilities.Utility;

abstract class Report {
    static final String line = "------------------------------------------------------------------------------------------\n";
    static final String gap = "                                                                                             ";
    static final String[] testText = new String[]{"", "=", ">", "<", "?4", "?5", "<>", "?7", "?8", "?9", "?10", "?11", "?12", "?13"};
    static final String[] continuationText = new String[]{"", "And", "Or", "Through"};
    protected final AppleworksADBFile parent;
    protected final String name;
    private final char reportFormat;
    private final char spacing;
    protected final int categoriesOnThisReport;
    protected final String titleLine;
    protected final boolean printHeader;
    private final int platenWidth;
    private final int leftMargin;
    private final int rightMargin;
    private final int charsPerInch;
    private final int paperLength;
    private final int topMargin;
    private final int bottomMargin;
    private final int linesPerInch;
    private final int[] selectionRules = new int[3];
    private final int[] testTypes = new int[3];
    private final int[] continuation = new int[3];
    private final String[] comparison = new String[3];
    private final String printerRules;
    private final boolean printDash;
    private String fudgeReason;

    Report(AppleworksADBFile parent, byte[] buffer, int offset) {
        this.parent = parent;
        this.name = this.pascalString(buffer, offset);
        this.categoriesOnThisReport = buffer[offset + 200] & 0xFF;
        this.platenWidth = buffer[offset + 205] & 0xFF;
        this.leftMargin = buffer[offset + 206] & 0xFF;
        this.rightMargin = buffer[offset + 207] & 0xFF;
        this.charsPerInch = buffer[offset + 208] & 0xFF;
        this.paperLength = buffer[offset + 209] & 0xFF;
        this.topMargin = buffer[offset + 210] & 0xFF;
        this.bottomMargin = buffer[offset + 211] & 0xFF;
        this.linesPerInch = buffer[offset + 212] & 0xFF;
        this.reportFormat = (char)buffer[offset + 214];
        this.spacing = (char)buffer[offset + 215];
        this.printHeader = buffer[offset + 216] != 0;
        this.titleLine = this.pascalString(buffer, offset + 220);
        int printerLength = buffer[offset + 464] & 0xFF;
        if (printerLength > 13) {
            System.out.println("*** Dodgy printer rules ***");
        }
        this.printerRules = this.pascalString(buffer, offset + 464);
        this.printDash = buffer[offset + 478] != 0;
        int fudge = 0;
        if (buffer[offset + 480] != 0) {
            fudge = 1;
            this.fudgeReason = "*** Report rules ***";
            if (buffer[offset + 481] != 0) {
                this.fudgeReason = "*** Bollocksed ***";
            }
        } else if (buffer[offset + 464] == 0 && buffer[offset + 465] != 0) {
            this.fudgeReason = "*** Printer codes ***";
            fudge = 1;
        } else if (buffer[offset + 479] != 0 && buffer[offset + 485] == 0) {
            this.fudgeReason = "*** Test codes ***";
            fudge = 1;
        } else {
            this.fudgeReason = "";
        }
        if (buffer[offset + 480 + fudge] == 0) {
            int i = 0;
            while (i < 3) {
                this.selectionRules[i] = Utility.getShort(buffer, offset + 479 + i * 2 + fudge);
                this.testTypes[i] = Utility.getShort(buffer, offset + 485 + i * 2 + fudge);
                this.continuation[i] = Utility.getShort(buffer, offset + 491 + i * 2 + fudge);
                this.comparison[i] = this.pascalString(buffer, offset + 497 + i * 32 + fudge);
                ++i;
            }
        } else {
            System.out.println("*** Invalid value in report rules ***");
        }
    }

    abstract String getText();

    protected String pascalString(byte[] buffer, int ptr) {
        return new String(buffer, ptr + 1, buffer[ptr] & 0xFF);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Report name ........ %s%n", this.name));
        text.append(String.format("Report type ........ %s%n", Character.valueOf(this.reportFormat)));
        text.append(String.format("Spacing ............ %s  (Single/Double/Triple)%n", Character.valueOf(this.spacing)));
        text.append(String.format("Print header ....... %s%n", this.printHeader));
        text.append(String.format("Title .............. %s%n", this.titleLine));
        text.append(String.format("L/R/T/B margin ..... %d/%d/%d/%d%n", this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin));
        text.append(String.format("Categories ......... %s%n", this.categoriesOnThisReport));
        text.append(String.format("Platen width ....... %d%n", this.platenWidth));
        text.append(String.format("Chars per inch ..... %d%n", this.charsPerInch));
        text.append(String.format("Paper length ....... %d%n", this.paperLength));
        text.append(String.format("Lines per inch ..... %d%n", this.linesPerInch));
        text.append(String.format("Print dash ......... %s%n", this.printDash));
        text.append(String.format("Printer rules ...... %s%n", this.printerRules));
        text.append("Report rules ....... ");
        int i = 0;
        while (i < 3) {
            if (this.selectionRules[i] == 0) break;
            int category = this.selectionRules[i] - 1;
            int test = this.testTypes[i];
            int cont = this.continuation[i];
            text.append(String.format("[%s] %s [%s] %s ", this.parent.categoryNames[category], testText[test], this.comparison[i], continuationText[cont]));
            ++i;
        }
        text.append("\n");
        if (!this.fudgeReason.isEmpty()) {
            text.append("Fudge .............. " + this.fudgeReason + "\n");
        }
        return text.toString();
    }
}

