/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.appleworks.Cell;
import com.bytezone.diskbrowser.appleworks.CellFormat;
import com.bytezone.diskbrowser.appleworks.CellFormula;
import com.bytezone.diskbrowser.utilities.Utility;

class CellValue
extends Cell {
    CellFormat format;
    CellFormula formula;
    boolean lastEvalNA;
    boolean lastEvalError;
    double saneDouble;

    CellValue(byte[] buffer, int row, int column, int offset, int length) {
        super(row, column, offset, length);
        this.type = "Value";
        this.format = new CellFormat(buffer[offset]);
        int b1 = buffer[offset + 1] & 0xFF;
        this.lastEvalNA = (b1 & 0x40) != 0;
        this.lastEvalError = (b1 & 0x20) != 0;
        this.saneDouble = Utility.getSANEDouble(buffer, offset + 2);
        this.value = String.format(this.format.mask(), this.saneDouble).trim();
        this.formula = new CellFormula(this, buffer, offset + 10, length - 10);
        this.value = String.format("%-15s %s", this.value, this.formula.value);
    }
}

