/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.appleworks.Cell;
import com.bytezone.diskbrowser.appleworks.CellFormat;
import com.bytezone.diskbrowser.utilities.HexFormatter;

class CellConstant
extends Cell {
    double saneDouble;
    CellFormat format;

    CellConstant(byte[] buffer, int row, int column, int offset, int length) {
        super(row, column, offset, length);
        this.type = "Const";
        if (length != 10) {
            System.out.println("Spreadsheet CellConstant with length != 10");
            System.out.printf("Row %d, Col %d, Length %d %n", row, column, length);
            System.out.println(HexFormatter.format(buffer, offset, length));
            this.type = "*** Invalid Constant ***";
            this.value = "";
        } else {
            long bits = 0L;
            int i = 9;
            while (i >= 2) {
                bits <<= 8;
                bits |= (long)(buffer[offset + i] & 0xFF);
                --i;
            }
            this.saneDouble = Double.longBitsToDouble(bits);
            this.format = new CellFormat(buffer[offset], buffer[offset + 1]);
            this.value = String.format(this.format.mask(), this.saneDouble).trim();
        }
    }
}

