/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.appleworks.Cell;
import com.bytezone.diskbrowser.appleworks.CellConstant;
import com.bytezone.diskbrowser.appleworks.CellFormat;
import com.bytezone.diskbrowser.appleworks.CellLabel;
import com.bytezone.diskbrowser.appleworks.CellValue;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class AppleworksSSFile
extends AbstractFile {
    Header header;
    List<Row> rows = new ArrayList<Row>();

    public AppleworksSSFile(String name, byte[] buffer) {
        super(name, buffer);
        this.header = new Header();
        int ptr = this.header.ssMinVers == 0 ? 300 : 302;
        while (ptr < buffer.length) {
            int length = Utility.getShort(buffer, ptr);
            if (length == 65535) break;
            Row row = new Row(ptr += 2);
            this.rows.add(row);
            ptr += length;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder(this.header.toString());
        for (Row row : this.rows) {
            text.append("\n");
            for (Cell cell : row.cells) {
                text.append(cell);
            }
        }
        return text.toString();
    }

    static String getCellName(int row, int column) {
        char c1 = (char)(65 + column / 26 - 1);
        char c2 = (char)(65 + column % 26);
        return "" + (c1 == '@' ? "" : Character.valueOf(c1)) + c2 + row;
    }

    private class Header {
        private final int[] columnWidths = new int[127];
        private final char calcOrder;
        private final char calcFrequency;
        private final int lastRow;
        private final int lastColumn;
        private final char windowLayout;
        private final boolean windowSynch;
        private final Window currentWindow;
        private final Window secondWindow;
        private final boolean cellProtection;
        private final int platenWidth;
        private final int leftMargin;
        private final int rightMargin;
        private final int charsPerInch;
        private final int paperLength;
        private final int topMargin;
        private final int bottomMargin;
        private final int linesPerInch;
        private final char spacing;
        private final byte[] printerCodes = new byte[14];
        private final boolean printDash;
        private final boolean printHeader;
        private final boolean zoomed;
        private final int ssMinVers;

        public Header() {
            int ptr = 4;
            int i = 0;
            while (i < this.columnWidths.length) {
                this.columnWidths[i] = AppleworksSSFile.this.buffer[ptr++] & 0xFF;
                ++i;
            }
            this.calcOrder = (char)AppleworksSSFile.this.buffer[131];
            this.calcFrequency = (char)AppleworksSSFile.this.buffer[132];
            this.lastRow = Utility.getShort(AppleworksSSFile.this.buffer, 133);
            this.lastColumn = AppleworksSSFile.this.buffer[135] & 0xFF;
            this.windowLayout = (char)AppleworksSSFile.this.buffer[136];
            this.windowSynch = AppleworksSSFile.this.buffer[137] != 0;
            this.currentWindow = new Window(138);
            this.secondWindow = new Window(162);
            this.cellProtection = AppleworksSSFile.this.buffer[213] != 0;
            this.platenWidth = AppleworksSSFile.this.buffer[215] & 0xFF;
            this.leftMargin = AppleworksSSFile.this.buffer[216] & 0xFF;
            this.rightMargin = AppleworksSSFile.this.buffer[217] & 0xFF;
            this.charsPerInch = AppleworksSSFile.this.buffer[218] & 0xFF;
            this.paperLength = AppleworksSSFile.this.buffer[219] & 0xFF;
            this.topMargin = AppleworksSSFile.this.buffer[220] & 0xFF;
            this.bottomMargin = AppleworksSSFile.this.buffer[221] & 0xFF;
            this.linesPerInch = AppleworksSSFile.this.buffer[222] & 0xFF;
            this.spacing = (char)AppleworksSSFile.this.buffer[223];
            System.arraycopy(AppleworksSSFile.this.buffer, 224, this.printerCodes, 0, this.printerCodes.length);
            this.printDash = AppleworksSSFile.this.buffer[238] != 0;
            this.printHeader = AppleworksSSFile.this.buffer[239] != 0;
            this.zoomed = AppleworksSSFile.this.buffer[240] != 0;
            this.ssMinVers = AppleworksSSFile.this.buffer[242];
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Calc order ..... %s %n", Character.valueOf(this.calcOrder)));
            text.append(String.format("Calc freq ...... %s %n", Character.valueOf(this.calcFrequency)));
            text.append(String.format("Last row ....... %d %n", this.lastRow));
            text.append(String.format("Last column .... %d %n", this.lastColumn));
            text.append(String.format("Window layout .. %s %n", Character.valueOf(this.windowLayout)));
            text.append(String.format("Window synch ... %s %n", this.windowSynch));
            text.append(String.format("Min version .... %s %n%n", this.ssMinVers));
            String[] s1 = this.currentWindow.toString().split("\n");
            String[] s2 = this.secondWindow.toString().split("\n");
            int i = 0;
            while (i < s1.length) {
                text.append(String.format("%-30s %-30s%n", s1[i], s2[i]));
                ++i;
            }
            text.append("\n");
            text.append(String.format("Cell protect ... %s %n", this.cellProtection));
            text.append(String.format("Platen width ... %d %n", this.platenWidth));
            text.append(String.format("Left margin .... %d %n", this.leftMargin));
            text.append(String.format("Right margin ... %d %n", this.rightMargin));
            text.append(String.format("Chars per inch . %d %n", this.charsPerInch));
            text.append(String.format("Paper length ... %d %n", this.paperLength));
            text.append(String.format("Top margin ..... %d %n", this.topMargin));
            text.append(String.format("Bottom margin .. %d %n", this.bottomMargin));
            text.append(String.format("Lines per inch . %d %n", this.linesPerInch));
            text.append(String.format("Spacing ........ %s %n", Character.valueOf(this.spacing)));
            String prC = HexFormatter.getHexString(this.printerCodes);
            text.append(String.format("Printer codes .. %s %n", prC));
            text.append(String.format("Print dash ..... %s %n", this.printDash));
            text.append(String.format("Print header ... %s %n", this.printHeader));
            text.append(String.format("Zoomed ......... %s %n", this.zoomed));
            return text.toString();
        }
    }

    private class Row {
        private final int rowNumber;
        private final List<Cell> cells = new ArrayList<Cell>();

        public Row(int ptr) {
            int val;
            this.rowNumber = Utility.getShort(AppleworksSSFile.this.buffer, ptr);
            ptr += 2;
            int column = 0;
            while ((val = AppleworksSSFile.this.buffer[ptr++] & 0xFF) != 255) {
                if (val > 128) {
                    column += val - 128;
                    continue;
                }
                if (ptr >= AppleworksSSFile.this.buffer.length) {
                    System.out.println("too long for buffer");
                    break;
                }
                int b1 = AppleworksSSFile.this.buffer[ptr] & 0xFF;
                if ((b1 & 0xE0) == 0 || (b1 & 0xA0) == 32) {
                    this.cells.add(new CellLabel(AppleworksSSFile.this.buffer, this.rowNumber, column++, ptr, val));
                } else if ((b1 & 0xA0) == 160) {
                    if (val > 0) {
                        this.cells.add(new CellConstant(AppleworksSSFile.this.buffer, this.rowNumber, column++, ptr, val));
                    }
                } else if ((b1 & 0xA0) == 128) {
                    this.cells.add(new CellValue(AppleworksSSFile.this.buffer, this.rowNumber, column++, ptr, val));
                } else {
                    System.out.println("Unknown Cell value : " + val);
                }
                ptr += val;
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Row number ..... %s %n", this.rowNumber));
            for (Cell cell : this.cells) {
                text.append(cell);
                text.append("\n");
            }
            return text.toString();
        }
    }

    private class Window {
        private final int justification;
        private final CellFormat format;
        private final int r1;
        private final int c1;
        private final int r2;
        private final int c2;
        private final int r3;
        private final int c3;
        private final int r4;
        private final int c4;
        private final int r5;
        private final int c5;
        private final int r6;
        private final int c6;
        private final int r7;
        private final int c7;
        private final int bodyRows;
        private final boolean rightColumnNotDisplayed;
        private final boolean topTitleSwitch;
        private final boolean sideTitleSwitch;

        public Window(int offset) {
            this.justification = AppleworksSSFile.this.buffer[offset] & 0xFF;
            this.format = new CellFormat(AppleworksSSFile.this.buffer[offset + 1], AppleworksSSFile.this.buffer[offset + 2]);
            this.r1 = AppleworksSSFile.this.buffer[offset + 3] & 0xFF;
            this.c1 = AppleworksSSFile.this.buffer[offset + 4] & 0xFF;
            this.r2 = Utility.getShort(AppleworksSSFile.this.buffer, offset + 5);
            this.c2 = AppleworksSSFile.this.buffer[offset + 7] & 0xFF;
            this.r3 = Utility.getShort(AppleworksSSFile.this.buffer, offset + 8);
            this.c3 = AppleworksSSFile.this.buffer[offset + 10] & 0xFF;
            this.r4 = Utility.getShort(AppleworksSSFile.this.buffer, offset + 11);
            this.c4 = AppleworksSSFile.this.buffer[offset + 13] & 0xFF;
            this.r5 = AppleworksSSFile.this.buffer[offset + 14] & 0xFF;
            this.c5 = AppleworksSSFile.this.buffer[offset + 15] & 0xFF;
            this.r6 = Utility.getShort(AppleworksSSFile.this.buffer, offset + 16);
            this.c6 = AppleworksSSFile.this.buffer[offset + 18] & 0xFF;
            this.r7 = AppleworksSSFile.this.buffer[offset + 19] & 0xFF;
            this.c7 = AppleworksSSFile.this.buffer[offset + 20] & 0xFF;
            this.bodyRows = AppleworksSSFile.this.buffer[offset + 21] & 0xFF;
            this.rightColumnNotDisplayed = AppleworksSSFile.this.buffer[offset + 21] != 0;
            int flags = AppleworksSSFile.this.buffer[offset + 23] & 0xFF;
            this.topTitleSwitch = (flags & 0x80) != 0;
            this.sideTitleSwitch = (flags & 0x40) != 0;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Justification .. %s %n", this.justification));
            text.append(String.format("Format ......... %s %n", this.format.mask()));
            text.append(String.format("Decimals ....... %s %n", this.format.decimals));
            text.append(String.format("Top line ....... %d %n", this.r1));
            text.append(String.format("Left column .... %d %n", this.c1));
            text.append(String.format("Title top line . %d %n", this.r2));
            text.append(String.format("Title left col . %d %n", this.c2));
            text.append(String.format("Top line ....... %d %n", this.r3));
            text.append(String.format("Left column .... %d %n", this.c3));
            text.append(String.format("Title top line . %d %n", this.r4));
            text.append(String.format("Title left col . %d %n", this.c4));
            text.append(String.format("Title top line . %d %n", this.r5));
            text.append(String.format("Title left col . %d %n", this.c5));
            text.append(String.format("Top line ....... %d %n", this.r6));
            text.append(String.format("Left column .... %d %n", this.c6));
            text.append(String.format("Title top line . %d %n", this.r7));
            text.append(String.format("Title left col . %d %n", this.c7));
            text.append(String.format("Body rows ...... %d %n", this.bodyRows));
            text.append(String.format("Right col hidden %s %n", this.rightColumnNotDisplayed));
            text.append(String.format("Top title sw ... %s %n", this.topTitleSwitch));
            text.append(String.format("Left title sw .. %s %n", this.sideTitleSwitch));
            return text.toString();
        }
    }
}

