/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.BasicFormatter;
import com.bytezone.diskbrowser.applefile.SourceLine;
import com.bytezone.diskbrowser.applefile.SubLine;
import com.bytezone.diskbrowser.gui.BasicPreferences;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class XrefFormatter
extends BasicFormatter {
    private static final String underline = "--------------------------------------------------------------------------------------------------";
    private final Map<Integer, List<Integer>> gotoLines = new TreeMap<Integer, List<Integer>>();
    private final Map<Integer, List<Integer>> gosubLines = new TreeMap<Integer, List<Integer>>();
    private final Map<Integer, List<Integer>> constantsInt = new TreeMap<Integer, List<Integer>>();
    private final Map<Float, List<Integer>> constantsFloat = new TreeMap<Float, List<Integer>>();
    private final Map<String, List<Integer>> callLines = new TreeMap<String, List<Integer>>();
    private final Map<String, List<Integer>> symbolLines = new TreeMap<String, List<Integer>>();
    private final Map<String, List<Integer>> functionLines = new TreeMap<String, List<Integer>>();
    private final Map<String, List<Integer>> arrayLines = new TreeMap<String, List<Integer>>();
    private final Map<String, List<String>> uniqueSymbols = new TreeMap<String, List<String>>();
    private final Map<String, List<String>> uniqueArrays = new TreeMap<String, List<String>>();
    private final List<Integer> stringsLine = new ArrayList<Integer>();
    private final List<String> stringsText = new ArrayList<String>();
    private final String formatLeft;
    private final String formatLineNumber;
    private final String formatRight;
    private final int longestVarName;
    private final int maxDigits;

    public XrefFormatter(ApplesoftBasicProgram program, BasicPreferences basicPreferences) {
        super(program, basicPreferences);
        for (SourceLine sourceLine : program.getSourceLines()) {
            this.checkXref(sourceLine);
        }
        this.longestVarName = this.getLongestName();
        this.maxDigits = this.getMaxDigits();
        this.formatLeft = this.longestVarName > 7 ? "%-" + this.longestVarName + "." + this.longestVarName + "s  " : "%-7.7s  ";
        this.formatRight = this.formatLeft.replace("-", "");
        this.formatLineNumber = "%" + this.maxDigits + "d ";
    }

    void checkXref(SourceLine line) {
        for (SubLine subline : line.sublines) {
            for (String symbol : subline.getVariables()) {
                this.checkVar(symbol, line.lineNumber, this.symbolLines, this.uniqueSymbols);
            }
            for (String symbol : subline.getArrays()) {
                this.checkVar(symbol, line.lineNumber, this.arrayLines, this.uniqueArrays);
            }
            for (String symbol : subline.getFunctions()) {
                this.checkFunction(line.lineNumber, symbol);
            }
            Iterator<Object> iterator = subline.getGosubLines().iterator();
            while (iterator.hasNext()) {
                int targetLine = (Integer)iterator.next();
                this.addNumberInt(line.lineNumber, targetLine, this.gosubLines);
            }
            iterator = subline.getGotoLines().iterator();
            while (iterator.hasNext()) {
                int targetLine = (Integer)iterator.next();
                this.addNumberInt(line.lineNumber, targetLine, this.gotoLines);
            }
            iterator = subline.getConstantsInt().iterator();
            while (iterator.hasNext()) {
                int num = (Integer)iterator.next();
                this.addNumberInt(line.lineNumber, num, this.constantsInt);
            }
            iterator = subline.getConstantsFloat().iterator();
            while (iterator.hasNext()) {
                float num = ((Float)iterator.next()).floatValue();
                this.addNumberFloat(line.lineNumber, Float.valueOf(num), this.constantsFloat);
            }
            if (subline.callTarget != null) {
                this.addString(line.lineNumber, subline.callTarget, this.callLines);
            }
            for (String s : subline.getStringsText()) {
                this.stringsText.add(s);
                this.stringsLine.add(line.lineNumber);
            }
        }
    }

    @Override
    public void append(StringBuilder fullText) {
        if (this.basicPreferences.showSymbols) {
            if (!this.symbolLines.isEmpty()) {
                this.showSymbolsLeft(fullText, this.symbolLines, "Var");
            }
            if (!this.arrayLines.isEmpty()) {
                this.showSymbolsLeft(fullText, this.arrayLines, "Array");
            }
        }
        if (this.basicPreferences.showDuplicateSymbols) {
            if (!this.uniqueSymbols.isEmpty()) {
                this.showDuplicates(fullText, this.uniqueSymbols, "Var");
            }
            if (!this.uniqueArrays.isEmpty()) {
                this.showDuplicates(fullText, this.uniqueArrays, "Array");
            }
        }
        if (this.basicPreferences.showFunctions && !this.functionLines.isEmpty()) {
            this.showSymbolsLeft(fullText, this.functionLines, "Fnction");
        }
        if (this.basicPreferences.showConstants) {
            if (!this.constantsInt.isEmpty()) {
                this.showSymbolsRightInt(fullText, this.constantsInt, "Integer");
            }
            if (!this.constantsFloat.isEmpty()) {
                this.showSymbolsRightFloat(fullText, this.constantsFloat, "Float");
            }
            if (this.stringsLine.size() > 0) {
                this.heading(fullText, this.formatRight, "Line", "String");
                int i = 0;
                while (i < this.stringsLine.size()) {
                    fullText.append(String.format(String.valueOf(this.formatRight) + "%s%n", this.stringsLine.get(i), this.stringsText.get(i)));
                    ++i;
                }
            }
        }
        if (this.basicPreferences.showGosubGoto) {
            if (!this.gosubLines.isEmpty()) {
                this.showSymbolsRight(fullText, this.gosubLines, "GOSUB");
            }
            if (!this.gotoLines.isEmpty()) {
                this.showSymbolsRight(fullText, this.gotoLines, "GOTO");
            }
        }
        if (this.basicPreferences.showCalls && !this.callLines.isEmpty()) {
            this.showSymbolsLeftRight(fullText, this.callLines, "   CALL");
        }
    }

    private int getMaxDigits() {
        if (this.sourceLines.size() == 0) {
            return 4;
        }
        SourceLine lastLine = (SourceLine)this.sourceLines.get(this.sourceLines.size() - 1);
        return String.valueOf(lastLine.lineNumber).length();
    }

    private int getLongestName() {
        int longestName = this.getLongestName(this.symbolLines, 0);
        longestName = this.getLongestName(this.arrayLines, longestName);
        longestName = this.getLongestName(this.functionLines, longestName);
        return longestName;
    }

    private int getLongestName(Map<String, List<Integer>> map, int longestName) {
        for (String symbol : map.keySet()) {
            if (symbol.length() <= longestName) continue;
            longestName = symbol.length();
        }
        return longestName;
    }

    private void heading(StringBuilder fullText, String format, String ... heading) {
        if (fullText.charAt(fullText.length() - 2) != '\n') {
            fullText.append("\n");
        }
        fullText.append(String.format(format, underline));
        fullText.append(underline);
        fullText.append("\n");
        fullText.append(String.format(format, heading[0]));
        if (heading.length == 1) {
            fullText.append("Line numbers");
        } else {
            fullText.append(heading[1]);
        }
        fullText.append("\n");
        fullText.append(String.format(format, underline));
        fullText.append(underline);
        fullText.append("\n");
    }

    private void showDuplicates(StringBuilder fullText, Map<String, List<String>> map, String heading) {
        boolean headingShown = false;
        for (String key : map.keySet()) {
            List<String> usage = map.get(key);
            if (usage.size() <= 1) continue;
            if (!headingShown) {
                headingShown = true;
                this.heading(fullText, this.formatLeft, heading, "Duplicate Names");
            }
            String line = usage.toString();
            line = line.substring(1, line.length() - 1);
            fullText.append(String.format("%-6s   %s%n", key, line));
        }
    }

    private void showSymbolsLeft(StringBuilder fullText, Map<String, List<Integer>> map, String heading) {
        this.heading(fullText, this.formatLeft, heading);
        for (String symbol : map.keySet()) {
            if (symbol.length() <= 7) {
                this.appendLineNumbers(fullText, String.format(this.formatLeft, symbol), map.get(symbol));
                continue;
            }
            this.appendLineNumbers(fullText, String.valueOf(symbol) + "  ", map.get(symbol));
        }
    }

    private void showSymbolsLeftRight(StringBuilder fullText, Map<String, List<Integer>> map, String heading) {
        this.heading(fullText, this.formatLeft, heading);
        for (String symbol : map.keySet()) {
            if (this.isNumeric(symbol)) {
                this.appendLineNumbers(fullText, String.format(this.formatRight, symbol), map.get(symbol));
                continue;
            }
            if (symbol.length() <= 7) {
                this.appendLineNumbers(fullText, String.format(this.formatLeft, symbol), map.get(symbol));
                continue;
            }
            this.appendLineNumbers(fullText, String.valueOf(symbol) + " ", map.get(symbol));
        }
    }

    private void showSymbolsRight(StringBuilder fullText, Map<Integer, List<Integer>> map, String heading) {
        this.heading(fullText, this.formatRight, heading);
        for (Integer symbol : map.keySet()) {
            this.appendLineNumbers(fullText, String.format(this.formatRight, symbol), map.get(symbol));
        }
    }

    private void showSymbolsRightInt(StringBuilder fullText, Map<Integer, List<Integer>> map, String heading) {
        this.heading(fullText, this.formatRight, heading);
        for (int symbol : map.keySet()) {
            this.appendLineNumbers(fullText, String.format(this.formatRight, symbol), map.get(symbol));
        }
    }

    private void showSymbolsRightFloat(StringBuilder fullText, Map<Float, List<Integer>> map, String heading) {
        this.heading(fullText, this.formatRight, heading);
        for (float symbol : map.keySet()) {
            this.appendLineNumbers(fullText, String.format(this.formatRight, Float.valueOf(symbol)), map.get(Float.valueOf(symbol)));
        }
    }

    private boolean isNumeric(String value) {
        int start;
        byte[] bytes = value.getBytes();
        int i = start = value.charAt(0) == '-' ? 1 : 0;
        while (i < bytes.length) {
            if (!Utility.isPossibleNumber(bytes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void appendLineNumbers(StringBuilder fullText, String symbol, List<Integer> lineNumbers) {
        StringBuilder text = new StringBuilder();
        text.append(symbol);
        for (int lineNo : lineNumbers) {
            if (text.length() > underline.length() - this.maxDigits + this.longestVarName) {
                fullText.append((CharSequence)text);
                fullText.append("\n");
                text.setLength(0);
                text.append(String.format(this.formatRight, ""));
            }
            text.append(String.format(this.formatLineNumber, lineNo));
        }
        if (text.length() > this.longestVarName + 3) {
            fullText.append(text + "\n");
        }
    }

    private void checkVar(String var, int lineNumber, Map<String, List<Integer>> map, Map<String, List<String>> unique) {
        List<Integer> lines = map.get(var);
        if (lines == null) {
            lines = new ArrayList<Integer>();
            map.put(var, lines);
        }
        if (lines.size() == 0) {
            lines.add(lineNumber);
        } else {
            int lastLine = lines.get(lines.size() - 1);
            if (lastLine != lineNumber) {
                lines.add(lineNumber);
            }
        }
        this.checkUniqueName(var, unique);
    }

    private void checkFunction(int sourceLine, String var) {
        List<Integer> lines = this.functionLines.get(var);
        if (lines == null) {
            lines = new ArrayList<Integer>();
            this.functionLines.put(var, lines);
        }
        this.addLine(lines, sourceLine);
    }

    private void addNumberInt(int sourceLine, Integer key, Map<Integer, List<Integer>> map) {
        List<Integer> lines = map.get(key);
        if (lines == null) {
            lines = new ArrayList<Integer>();
            map.put(key, lines);
        }
        this.addLine(lines, sourceLine);
    }

    private void addNumberFloat(int sourceLine, Float key, Map<Float, List<Integer>> map) {
        List<Integer> lines = map.get(key);
        if (lines == null) {
            lines = new ArrayList<Integer>();
            map.put(key, lines);
        }
        this.addLine(lines, sourceLine);
    }

    private void addString(int sourceLine, String key, Map<String, List<Integer>> map) {
        List<Integer> lines = map.get(key);
        if (lines == null) {
            lines = new ArrayList<Integer>();
            map.put(key, lines);
        }
        this.addLine(lines, sourceLine);
    }

    private void addLine(List<Integer> lines, int lineNumber) {
        if (lines.size() == 0) {
            lines.add(lineNumber);
        } else {
            int lastLine = lines.get(lines.size() - 1);
            if (lastLine != lineNumber) {
                lines.add(lineNumber);
            }
        }
    }

    private void checkUniqueName(String symbol, Map<String, List<String>> map) {
        String uniqueName = this.getUniqueName(symbol);
        List<String> usage = map.get(uniqueName);
        if (usage == null) {
            usage = new ArrayList<String>();
            map.put(uniqueName, usage);
        }
        if (!usage.contains(symbol)) {
            usage.add(symbol);
        }
    }

    private String getUniqueName(String symbolName) {
        int ptr = symbolName.length() - 1;
        if (symbolName.charAt(ptr) == '$' || symbolName.charAt(ptr) == '%') {
            --ptr;
        }
        return ptr <= 1 ? symbolName : String.valueOf(symbolName.substring(0, 2)) + symbolName.substring(ptr + 1);
    }
}

