/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.Alignment;
import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BasicFormatter;
import com.bytezone.diskbrowser.applefile.SourceLine;
import com.bytezone.diskbrowser.applefile.SubLine;
import com.bytezone.diskbrowser.gui.BasicPreferences;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserBasicFormatter
extends BasicFormatter {
    private static final Pattern dimPattern = Pattern.compile("[A-Z][A-Z0-9]*[$%]?\\([0-9]+(,[0-9]+)*\\)[,:]?");
    private static final int INDENT_SIZE = 2;
    private static final String EIGHT_SPACES = "        ";
    private static final String FOUR_SPACES = "    ";
    private static boolean FORCE = true;
    private static boolean NO_FORCE = false;

    public UserBasicFormatter(ApplesoftBasicProgram program, BasicPreferences basicPreferences) {
        super(program, basicPreferences);
    }

    @Override
    public void append(StringBuilder fullText) {
        boolean insertBlankLine = false;
        int baseOffset = 7;
        Stack<String> loopVariables = new Stack<String>();
        Alignment alignment = new Alignment();
        for (SourceLine line : this.sourceLines) {
            StringBuilder text = new StringBuilder(String.format("%5d", line.lineNumber));
            int indentLevel = loopVariables.size();
            int ifIndent = 0;
            for (SubLine subline : line.sublines) {
                if (subline.isEmpty()) continue;
                if (subline.is((byte)-78) && subline.containsToken()) {
                    int address = this.getLoadAddress() + subline.startPtr + 1;
                    fullText.append(text + String.format("REM - Inline assembler @ $%02X (%d)%n", address, address));
                    String padding = "                         ".substring(0, text.length() + 2);
                    String[] stringArray = this.getRemAssembler(subline);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String asm = stringArray[n2];
                        fullText.append(String.valueOf(padding) + asm + "\n");
                        ++n2;
                    }
                    continue;
                }
                if (subline.is((byte)-78) && this.basicPreferences.formatRem && subline.containsControlChars()) {
                    subline.addFormattedRem(text);
                    fullText.append(text + "\n");
                    continue;
                }
                if (subline.is((byte)-126)) {
                    this.popLoopVariables(loopVariables, subline);
                    indentLevel = Math.max(ifIndent, loopVariables.size());
                }
                if (this.joinableRem(subline)) {
                    fullText.deleteCharAt(fullText.length() - 1);
                    fullText.append(" ");
                } else {
                    if (this.basicPreferences.alignAssign) {
                        this.alignEqualsPosition(subline, alignment);
                    }
                    int column = indentLevel * 2 + baseOffset;
                    while (text.length() < column) {
                        text.append(" ");
                    }
                }
                String lineText = alignment.getAlignedText(subline);
                if (subline.is((byte)-125) && this.basicPreferences.deleteExtraDataSpace) {
                    lineText = lineText.replaceFirst("DATA  +", "DATA ");
                }
                int inset = Math.max(text.length(), Utility.getIndent(fullText)) + 1;
                if (subline.is((byte)-78) && lineText.length() > this.basicPreferences.wrapRemAt) {
                    lines = this.splitLine(lineText, this.basicPreferences.wrapRemAt, ' ', FORCE);
                    this.addSplitLines(lines, text, inset);
                } else if (subline.is((byte)-125) && lineText.length() > this.basicPreferences.wrapDataAt) {
                    lines = this.splitLine(lineText, this.basicPreferences.wrapDataAt, ',', FORCE);
                    this.addSplitLines(lines, text, inset);
                } else if (subline.is((byte)-70) && lineText.length() > this.basicPreferences.wrapPrintAt) {
                    lines = this.splitLine(lineText, this.basicPreferences.wrapDataAt, ';', NO_FORCE);
                    this.addSplitLines(lines, text, inset);
                } else if (subline.is((byte)-122) && this.basicPreferences.splitDim) {
                    lines = this.splitDim(lineText);
                    this.addSplitLines(lines, text, inset);
                } else {
                    text.append(lineText);
                }
                if (subline == alignment.lastSubLine) {
                    alignment.reset();
                }
                fullText.append((CharSequence)text);
                fullText.append("\n");
                text.setLength(0);
                if (subline.is((byte)-83)) {
                    ifIndent = ++indentLevel;
                    continue;
                }
                if (subline.is((byte)-127)) {
                    String latestLoopVar;
                    String string = latestLoopVar = loopVariables.size() > 0 ? loopVariables.peek() : "";
                    if (subline.forVariable.equals(latestLoopVar)) continue;
                    loopVariables.push(subline.forVariable);
                    ++indentLevel;
                    continue;
                }
                if (!this.basicPreferences.blankAfterReturn || !subline.is((byte)-79) || !subline.isFirst()) continue;
                insertBlankLine = true;
            }
            if (!insertBlankLine) continue;
            fullText.append("\n");
            insertBlankLine = false;
        }
    }

    private List<String> splitLine(String line, int wrapLength, char breakChar, boolean force) {
        int spaceAt = 0;
        while (spaceAt < line.length() && line.charAt(spaceAt) != ' ') {
            ++spaceAt;
        }
        String indent = spaceAt < 8 ? EIGHT_SPACES.substring(0, spaceAt + 1) : EIGHT_SPACES;
        ArrayList<String> lines = new ArrayList<String>();
        while (line.length() > wrapLength) {
            int breakAt = wrapLength - 1;
            while (breakAt > spaceAt && line.charAt(breakAt) != breakChar) {
                --breakAt;
            }
            if (breakAt <= spaceAt) break;
            lines.add(line.substring(0, breakAt + 1));
            line = String.valueOf(indent) + line.substring(breakAt + 1).trim();
        }
        if (force) {
            while (line.length() > wrapLength) {
                lines.add(line.substring(0, wrapLength));
                line = String.valueOf(indent) + line.substring(wrapLength);
            }
        }
        lines.add(line);
        return lines;
    }

    private List<String> splitDim(String line) {
        ArrayList<String> lines = new ArrayList<String>();
        Matcher m = dimPattern.matcher(line);
        while (m.find()) {
            lines.add(FOUR_SPACES + m.group());
        }
        if (lines.size() > 0) {
            lines.set(0, "DIM " + ((String)lines.get(0)).trim());
        }
        return lines;
    }

    private void addSplitLines(List<String> lines, StringBuilder text, int indent) {
        boolean first = true;
        for (String line : lines) {
            if (first) {
                first = false;
                text.append(line);
                continue;
            }
            text.append(String.valueOf("\n                                           ".substring(0, indent)) + line);
        }
    }

    private void alignEqualsPosition(SubLine subline, Alignment alignment) {
        if (subline.equalsPosition == 0) {
            alignment.reset();
            return;
        }
        if (alignment.equalsPosition == 0) {
            this.findHighest(subline, alignment);
        }
    }

    private void findHighest(SubLine startSubline, Alignment alignment) {
        boolean started = false;
        alignment.setFirst(startSubline);
        int i = this.sourceLines.indexOf(startSubline.sourceLine);
        block0: while (i < this.sourceLines.size()) {
            boolean precededByIf = false;
            for (SubLine subline : ((SourceLine)this.sourceLines.get((int)i)).sublines) {
                if (started) {
                    if (subline.equalsPosition == 0 && !this.joinableRem(subline)) break block0;
                    if (subline.equalsPosition <= 0) continue;
                    alignment.check(subline);
                    continue;
                }
                if (subline == startSubline) {
                    started = true;
                    continue;
                }
                if (!subline.is((byte)-83)) continue;
                precededByIf = true;
            }
            if (started && precededByIf) break;
            ++i;
        }
    }

    private boolean joinableRem(SubLine subline) {
        return subline.isJoinableRem() && !this.basicPreferences.splitRem;
    }

    private void popLoopVariables(Stack<String> loopVariables, SubLine subline) {
        if (subline.nextVariables.length == 0) {
            if (loopVariables.size() > 0) {
                loopVariables.pop();
            }
        } else {
            String[] stringArray = subline.nextVariables;
            int n = subline.nextVariables.length;
            int n2 = 0;
            while (n2 < n) {
                String variable = stringArray[n2];
                while (loopVariables.size() > 0) {
                    if (this.sameVariable(variable, loopVariables.pop())) break;
                }
                ++n2;
            }
        }
    }

    private boolean sameVariable(String v1, String v2) {
        return this.getUniqueName(v1).equals(this.getUniqueName(v2));
    }

    private String getUniqueName(String symbol) {
        int ptr = symbol.length() - 1;
        if (symbol.charAt(ptr) == '$' || symbol.charAt(ptr) == '%') {
            --ptr;
        }
        return ptr <= 1 ? symbol : String.valueOf(symbol.substring(0, 2)) + symbol.substring(ptr + 1);
    }

    private String[] getRemAssembler(SubLine subline) {
        AssemblerProgram program = new AssemblerProgram("REM assembler", subline.getBuffer(), this.getLoadAddress() + subline.startPtr + 1);
        return program.getAssembler().split("\n");
    }
}

