/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.utilities.HexFormatter;

public class TextBuffer {
    public final byte[] buffer;
    public final int reclen;
    public final int firstRecNo;

    public TextBuffer(byte[] tempBuffer, int reclen, int firstBlock) {
        this.reclen = reclen;
        int firstByte = firstBlock * 512;
        int rem = firstByte % reclen;
        this.firstRecNo = firstByte / reclen + (rem > 0 ? 1 : 0);
        int offset = rem > 0 ? reclen - rem : 0;
        int availableBytes = tempBuffer.length - offset;
        int totalRecords = (availableBytes - 1) / reclen + 1;
        this.buffer = new byte[totalRecords * reclen];
        int copyBytes = Math.min(availableBytes, this.buffer.length);
        if (copyBytes < 0) {
            System.out.printf("offset %d  len %d  copy %d%n", offset, this.buffer.length, copyBytes);
        } else {
            System.arraycopy(tempBuffer, offset, this.buffer, 0, copyBytes);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Record length : " + this.reclen + "\n");
        text.append("Buffer length : " + this.buffer.length + "\n");
        text.append("First record  : " + this.firstRecNo + "\n\n");
        text.append(String.valueOf(HexFormatter.format(this.buffer, 0, this.buffer.length)) + "\n");
        return text.toString();
    }
}

