/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.SourceLine;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class SubLine
implements ApplesoftConstants {
    SourceLine sourceLine;
    byte[] buffer;
    int startPtr;
    int length;
    String[] nextVariables;
    String forVariable = "";
    int equalsPosition;
    int endPosition;
    String functionArgument;
    String functionName;
    String callTarget;
    private final List<Integer> gotoLines = new ArrayList<Integer>();
    private final List<Integer> gosubLines = new ArrayList<Integer>();
    private final List<String> variables = new ArrayList<String>();
    private final List<String> functions = new ArrayList<String>();
    private final List<String> arrays = new ArrayList<String>();
    private final List<Integer> constantsInt = new ArrayList<Integer>();
    private final List<Float> constantsFloat = new ArrayList<Float>();
    private final List<String> stringsText = new ArrayList<String>();

    SubLine(SourceLine sourceLine, int offset, int length) {
        this.sourceLine = sourceLine;
        this.startPtr = offset;
        this.length = length;
        this.buffer = sourceLine.buffer;
        int ptr = this.startPtr;
        byte firstByte = this.buffer[this.startPtr];
        if (this.isToken(firstByte)) {
            this.doToken(firstByte);
            if (this.is((byte)-78) || this.is((byte)-125)) {
                return;
            }
            ptr = this.is((byte)-116) ? this.startPtr + this.callTarget.length() : this.startPtr + 1;
        } else {
            if (Utility.isDigit(firstByte)) {
                this.addXref(this.getLineNumber(this.buffer, this.startPtr), this.gotoLines);
                return;
            }
            if (Utility.isLetter(firstByte)) {
                this.setEqualsPosition();
            } else {
                if (this.isEndOfLine(firstByte)) {
                    return;
                }
                System.out.printf("%s unexpected bytes at line %5d:%n%s%n", sourceLine.program.name, sourceLine.lineNumber, HexFormatter.formatNoHeader(this.buffer, this.startPtr, length));
            }
        }
        String var = "";
        boolean inQuote = false;
        boolean inFunction = false;
        boolean inDefine = false;
        int stringPtr = 0;
        int endOfLine = this.startPtr + length - 1;
        while (this.isEndOfLine(this.buffer[endOfLine])) {
            --endOfLine;
        }
        while (ptr <= endOfLine) {
            byte b = this.buffer[ptr++];
            if (inDefine) {
                if (b != -48) continue;
                inDefine = false;
                continue;
            }
            if (b == -72) {
                inDefine = true;
                continue;
            }
            if (b == -62) {
                assert (!inDefine);
                inFunction = true;
                continue;
            }
            if (inQuote) {
                if (b != 34) continue;
                inQuote = false;
                this.addString(stringPtr, ptr);
                continue;
            }
            if (b == 34) {
                inQuote = true;
                stringPtr = ptr;
                continue;
            }
            if (Utility.isPossibleVariable(b) || Utility.isPossibleNumber(b)) {
                if (var.isEmpty() && Utility.isPossibleNumber(b) && this.buffer[ptr - 2] == -55) {
                    var = "-";
                }
                var = String.valueOf(var) + (char)b;
                if (b != 36 && b != 37 || this.buffer[ptr] == 40) continue;
                this.checkVar(var, b);
                var = "";
                continue;
            }
            if (inFunction) {
                this.checkFunction(var, b);
                inFunction = false;
            } else {
                this.checkVar(var, b);
            }
            var = "";
        }
        if (inQuote) {
            this.addString(stringPtr, ptr);
        } else {
            this.checkVar(var, (byte)0);
        }
    }

    private boolean isEndOfLine(byte b) {
        return b == 0 || b == 58;
    }

    private void addString(int stringPtr, int ptr) {
        this.stringsText.add(new String(this.buffer, stringPtr - 1, ptr - stringPtr + 1));
    }

    private void checkFunction(String var, byte terminator) {
        assert (terminator == 40);
        if (!this.functions.contains(var)) {
            this.functions.add(var);
        }
    }

    private void checkVar(String var, byte terminator) {
        if (var.length() == 0) {
            return;
        }
        if (!Utility.isLetter((byte)var.charAt(0))) {
            if (this.is((byte)-85) || this.is((byte)-80) || this.is((byte)-76) || this.is((byte)-91)) {
                return;
            }
            this.addNumber(var);
            return;
        }
        if (this.is((byte)-72) && (var.equals(this.functionName) || var.equals(this.functionArgument))) {
            return;
        }
        if (terminator == 40) {
            if (!this.arrays.contains(var)) {
                this.arrays.add(var);
            }
        } else if (!this.variables.contains(var)) {
            this.variables.add(var);
        }
    }

    private void doToken(byte b) {
        block0 : switch (b) {
            case -127: {
                int p = this.startPtr + 1;
                while (this.buffer[p] != -48) {
                    this.forVariable = String.valueOf(this.forVariable) + (char)this.buffer[p++];
                }
                break;
            }
            case -126: {
                if (this.length == 2) {
                    this.nextVariables = new String[0];
                    break;
                }
                String varList = new String(this.buffer, this.startPtr + 1, this.length - 2);
                this.nextVariables = varList.split(",");
                break;
            }
            case -86: {
                this.setEqualsPosition();
                break;
            }
            case -85: {
                int targetLine = this.getLineNumber(this.buffer, this.startPtr + 1);
                this.addXref(targetLine, this.gotoLines);
                break;
            }
            case -80: {
                int targetLine = this.getLineNumber(this.buffer, this.startPtr + 1);
                this.addXref(targetLine, this.gosubLines);
                break;
            }
            case -76: {
                int p = this.startPtr + 1;
                int max = this.startPtr + this.length - 1;
                while (p < max && this.buffer[p] != -85 && this.buffer[p] != -80) {
                    ++p;
                }
                switch (this.buffer[p++]) {
                    case -80: {
                        for (int destLine : this.getLineNumbers(this.buffer, p)) {
                            this.addXref(destLine, this.gosubLines);
                        }
                        break block0;
                    }
                    case -85: {
                        for (int destLine : this.getLineNumbers(this.buffer, p)) {
                            this.addXref(destLine, this.gotoLines);
                        }
                        break block0;
                    }
                    default: {
                        System.out.println("GOTO / GOSUB not found");
                        break;
                    }
                }
                break;
            }
            case -91: {
                if (this.buffer[this.startPtr + 1] != -85) break;
                int targetLine = this.getLineNumber(this.buffer, this.startPtr + 2);
                this.addXref(targetLine, this.gotoLines);
                break;
            }
            case -116: {
                this.callTarget = this.getCallTarget();
                break;
            }
            case -72: {
                byte[] lineBuffer = this.getBuffer();
                assert (lineBuffer[0] == -62);
                int leftBracket = this.getPosition(lineBuffer, 1, (byte)40);
                int rightBracket = this.getPosition(lineBuffer, leftBracket + 1, (byte)41);
                this.functionName = new String(lineBuffer, 1, leftBracket - 1);
                this.functionArgument = new String(lineBuffer, leftBracket + 1, rightBracket - leftBracket - 1);
                this.functions.add(this.functionName);
                break;
            }
            case -125: {
                String[] stringArray = new String(this.getBuffer()).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String chunk = stringArray[n2];
                    if (!(chunk = chunk.trim()).isEmpty()) {
                        b = (byte)chunk.charAt(0);
                        if (Utility.isPossibleNumber(b) || b == 45) {
                            if (!this.addNumber(chunk)) {
                                this.stringsText.add(chunk);
                            }
                        } else {
                            this.stringsText.add(chunk);
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
    }

    private boolean addNumber(String var) {
        try {
            if (var.indexOf(46) < 0) {
                int varInt = Integer.parseInt(var);
                if (!this.constantsInt.contains(varInt)) {
                    this.constantsInt.add(varInt);
                }
            } else {
                float varFloat = Float.parseFloat(var);
                if (!this.constantsFloat.contains(Float.valueOf(varFloat))) {
                    this.constantsFloat.add(Float.valueOf(varFloat));
                }
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private String getCallTarget() {
        StringBuilder text = new StringBuilder();
        int ptr = this.startPtr + 1;
        int max = this.startPtr + this.length - 1;
        while (ptr < max) {
            byte b;
            if (this.isToken(b = this.buffer[ptr++])) {
                text.append(tokens[b & 0x7F]);
                continue;
            }
            if (b == 44) break;
            text.append((char)b);
        }
        return text.toString();
    }

    private int getPosition(byte[] buffer, int start, byte value) {
        int i = start;
        while (i < buffer.length) {
            if (buffer[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addXref(int targetLine, List<Integer> list) {
        if (!list.contains(targetLine)) {
            list.add(targetLine);
        }
    }

    private List<Integer> getLineNumbers(byte[] buffer, int ptr) {
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        int start = ptr;
        while (ptr < buffer.length && buffer[ptr] != 0 && buffer[ptr] != 58) {
            ++ptr;
        }
        String s = new String(buffer, start, ptr - start);
        String[] chunks = s.split(",");
        try {
            String[] stringArray = chunks;
            int n = chunks.length;
            int n2 = 0;
            while (n2 < n) {
                String chunk = stringArray[n2];
                lineNumbers.add(Integer.parseInt(chunk));
                ++n2;
            }
        }
        catch (NumberFormatException e) {
            System.out.printf("NFE2: %s%n", s);
        }
        return lineNumbers;
    }

    private int getLineNumber(byte[] buffer, int ptr) {
        int lineNumber = 0;
        while (ptr < buffer.length && Utility.isDigit(buffer[ptr])) {
            lineNumber = lineNumber * 10 + (buffer[ptr++] & 0xFF) - 48;
        }
        return lineNumber;
    }

    boolean isImpliedGoto() {
        return Utility.isDigit(this.buffer[this.startPtr]);
    }

    private void setEqualsPosition() {
        int p = this.startPtr;
        int max = this.startPtr + this.length;
        while (++p < max) {
            if (this.buffer[p] != -48) continue;
            String expandedLine = this.toString();
            this.equalsPosition = expandedLine.indexOf(61);
            this.endPosition = expandedLine.length();
            if (!expandedLine.endsWith(":")) break;
            --this.endPosition;
            break;
        }
    }

    boolean isJoinableRem() {
        return this.is((byte)-78) && this.isNotFirst();
    }

    boolean isFirst() {
        return this.sourceLine.linePtr + 4 == this.startPtr;
    }

    boolean isNotFirst() {
        return !this.isFirst();
    }

    boolean is(byte token) {
        return this.buffer[this.startPtr] == token;
    }

    boolean has(byte token) {
        int ptr = this.startPtr;
        int max = this.startPtr + this.length;
        while (++ptr < max) {
            if (this.buffer[ptr] != token) continue;
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.length == 1 && this.buffer[this.startPtr] == 0;
    }

    boolean containsToken() {
        int p = this.startPtr + 1;
        int max = this.startPtr + this.length;
        while (p < max) {
            if (this.isToken(this.buffer[p])) {
                return true;
            }
            ++p;
        }
        return false;
    }

    boolean containsControlChars() {
        int p = this.startPtr + 1;
        int max = this.startPtr + this.length;
        while (p < max) {
            int c = this.buffer[p] & 0xFF;
            if (c == 0) break;
            if (c < 32) {
                return true;
            }
            ++p;
        }
        return false;
    }

    void addFormattedRem(StringBuilder text) {
        int ptr = this.startPtr + 1;
        int max = this.startPtr + this.length - 1;
        if (this.isFirst()) {
            if (this.containsBackspaces(ptr, max)) {
                text.setLength(0);
                text.append(String.format(" %d  REM ", this.sourceLine.lineNumber));
            } else {
                text.append("  REM ");
            }
        } else {
            text.append("REM ");
        }
        while (ptr < max) {
            switch (this.buffer[ptr]) {
                case 8: {
                    if (text.length() <= 0) break;
                    text.deleteCharAt(text.length() - 1);
                    break;
                }
                case 13: {
                    text.append("\n");
                    break;
                }
                case 10: {
                    int indent = Utility.getIndent(text);
                    text.append("\n");
                    int i = 0;
                    while (i < indent) {
                        text.append(" ");
                        ++i;
                    }
                    break;
                }
                default: {
                    text.append((char)this.buffer[ptr]);
                }
            }
            ++ptr;
        }
    }

    private boolean containsBackspaces(int ptr, int max) {
        while (ptr < max) {
            if (this.buffer[ptr++] != 8) continue;
            return true;
        }
        return false;
    }

    public byte[] getBuffer() {
        int len = this.length - 1;
        if (this.buffer[this.startPtr + len] == 58 || this.buffer[this.startPtr + len] == 0) {
            --len;
        }
        byte[] buffer2 = new byte[len];
        System.arraycopy(this.buffer, this.startPtr + 1, buffer2, 0, buffer2.length);
        return buffer2;
    }

    boolean isToken(byte b) {
        return Utility.isHighBitSet(b);
    }

    List<String> getVariables() {
        return this.variables;
    }

    List<String> getFunctions() {
        return this.functions;
    }

    List<String> getArrays() {
        return this.arrays;
    }

    List<Integer> getGotoLines() {
        return this.gotoLines;
    }

    List<Integer> getGosubLines() {
        return this.gosubLines;
    }

    List<Integer> getConstantsInt() {
        return this.constantsInt;
    }

    List<Float> getConstantsFloat() {
        return this.constantsFloat;
    }

    List<String> getStringsText() {
        return this.stringsText;
    }

    StringBuilder toStringBuilder() {
        StringBuilder line = new StringBuilder();
        int max = this.startPtr + this.length - 1;
        if (this.buffer[max] == 0) {
            --max;
        }
        if (this.isImpliedGoto() && !ApplesoftBasicProgram.basicPreferences.showThen) {
            line.append("GOTO ");
        }
        int p = this.startPtr;
        while (p <= max) {
            byte b = this.buffer[p];
            if (this.isToken(b)) {
                if (line.length() > 0 && line.charAt(line.length() - 1) != ' ') {
                    line.append(' ');
                }
                int val = b & 0x7F;
                if (b != -60 || ApplesoftBasicProgram.basicPreferences.showThen) {
                    line.append(String.valueOf(ApplesoftConstants.tokens[val]) + " ");
                }
            } else if (!Utility.isControlCharacter(b)) {
                line.append((char)b);
            }
            ++p;
        }
        return line;
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }
}

