/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.SubLine;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class SourceLine
implements ApplesoftConstants {
    ApplesoftBasicProgram program;
    int linkField;
    int lineNumber;
    int linePtr;
    int length;
    byte[] buffer;
    List<SubLine> sublines = new ArrayList<SubLine>();

    SourceLine(ApplesoftBasicProgram program, byte[] buffer, int ptr) {
        byte b;
        this.program = program;
        this.buffer = buffer;
        this.linePtr = ptr;
        this.linkField = Utility.getShort(buffer, ptr);
        this.lineNumber = Utility.getShort(buffer, ptr + 2);
        int startPtr = ptr += 4;
        boolean inString = false;
        boolean inRemark = false;
        while (ptr < buffer.length && (b = buffer[ptr++]) != 0) {
            if (inRemark) continue;
            if (inString) {
                if (b != 34) continue;
                inString = false;
                continue;
            }
            switch (b) {
                case -83: {
                    while (buffer[ptr] != -60 && buffer[ptr] != -85 && buffer[ptr] != 0) {
                        ++ptr;
                    }
                    if (buffer[ptr] == -60) {
                        ++ptr;
                    }
                    startPtr = this.addSubLine(startPtr, ptr);
                    break;
                }
                case 58: {
                    startPtr = this.addSubLine(startPtr, ptr);
                    break;
                }
                case -78: {
                    if (ptr == startPtr + 1) {
                        inRemark = true;
                        break;
                    }
                    System.out.printf("%s : %5d mid-line REM token%n", program.name, this.lineNumber);
                    startPtr = this.addSubLine(startPtr, --ptr);
                    break;
                }
                case 34: {
                    inString = true;
                }
            }
        }
        this.length = ptr - this.linePtr;
        this.addSubLine(startPtr, ptr);
    }

    private int addSubLine(int startPtr, int ptr) {
        this.sublines.add(new SubLine(this, startPtr, ptr - startPtr));
        return ptr;
    }
}

