/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.List;

public class SimpleText2
extends AbstractFile {
    List<Integer> lineStarts = new ArrayList<Integer>();
    int loadAddress;
    boolean showByte = false;

    public SimpleText2(String name, byte[] buffer, int loadAddress) {
        super(name, buffer);
        this.loadAddress = loadAddress;
        int ptr = 0;
        while (ptr < buffer.length && buffer[ptr] != -1) {
            int length = buffer[ptr] & 0xFF;
            this.lineStarts.add(ptr);
            ptr += length + 1;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name    : " + this.name + "\n");
        text.append(String.format("Length  : $%04X (%d)%n", this.buffer.length, this.buffer.length));
        text.append(String.format("Load at : $%04X%n%n", this.loadAddress));
        for (Integer i : this.lineStarts) {
            text.append(String.format("%05X  %s%n", i, this.getLine(i)));
        }
        if (text.charAt(text.length() - 1) == '\n') {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder();
        for (Integer i : this.lineStarts) {
            text.append(String.valueOf(HexFormatter.formatNoHeader(this.buffer, i, (this.buffer[i] & 0xFF) + 1)) + "\n");
        }
        text.append(String.valueOf(HexFormatter.formatNoHeader(this.buffer, this.buffer.length - 2, 2)) + "\n");
        return text.toString();
    }

    private String getLine(int ptr) {
        StringBuilder line = new StringBuilder();
        int length = this.buffer[ptr] & 0xFF;
        while (--length > 0) {
            int val;
            if ((val = this.buffer[++ptr] & 0xFF) == 187) {
                while (line.length() < 35) {
                    line.append(' ');
                }
                line.append(';');
                continue;
            }
            if (val >= 128) {
                while (line.length() < 10) {
                    line.append(' ');
                }
                if (val == 220) {
                    line.append(String.format("EQU %02X", val));
                } else if (val == 208) {
                    line.append(String.format("STA %02X", val));
                } else if (val == 210) {
                    line.append(String.format("STY %02X", val));
                } else if (val == 212) {
                    line.append(String.format("LSR %02X", val));
                } else if (val == 213) {
                    line.append(String.format("ROR %02X", val));
                } else if (val == 215) {
                    line.append(String.format("ASL %02X", val));
                } else if (val == 217) {
                    line.append(String.format("EQ  %02X", val));
                } else if (val == 219) {
                    line.append(String.format("TGT %02X", val));
                } else if (val == 218) {
                    line.append(String.format("ORG %02X", val));
                } else if (val == 177) {
                    line.append(String.format("TYA %02X", val));
                } else if (val == 193) {
                    line.append(String.format("AND %02X", val));
                } else if (val == 196) {
                    line.append(String.format("CMP %02X", val));
                } else if (val == 200) {
                    line.append(String.format("EOR %02X", val));
                } else if (val == 202) {
                    line.append(String.format("JMP %02X", val));
                } else if (val == 203) {
                    line.append(String.format("JSR %02X", val));
                } else if (val == 205) {
                    line.append(String.format("LDA %02X", val));
                } else if (val == 206) {
                    line.append(String.format("LDX %02X", val));
                } else if (val == 207) {
                    line.append(String.format("LDY %02X", val));
                } else if (val == 161) {
                    line.append(String.format("PHA %02X", val));
                } else if (val == 162) {
                    line.append(String.format("PLA %02X", val));
                } else if (val == 165) {
                    line.append(String.format("RTS %02X", val));
                } else if (val == 169) {
                    line.append(String.format("SEC %02X", val));
                } else if (val == 173) {
                    line.append(String.format("TAY %02X", val));
                } else if (val == 130) {
                    line.append(String.format("BMI %02X", val));
                } else if (val == 132) {
                    line.append(String.format("BCS %02X", val));
                } else if (val == 133) {
                    line.append(String.format("BPL %02X", val));
                } else if (val == 134) {
                    line.append(String.format("BNE %02X", val));
                } else if (val == 135) {
                    line.append(String.format("BEQ %02X", val));
                } else if (val == 153) {
                    line.append(String.format("CLC %02X", val));
                } else if (val == 156) {
                    line.append(String.format("DEX %02X", val));
                } else if (val == 159) {
                    line.append(String.format("INY %02X", val));
                } else {
                    line.append(String.format(".%02X.", val));
                }
                line.append(' ');
                if (this.buffer[++ptr] >= 32 || !this.showByte) continue;
                val = this.buffer[ptr] & 0xFF;
                line.append(String.format(".%02X. ", val));
                continue;
            }
            line.append((char)val);
        }
        return line.toString();
    }
}

