/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.List;

class Shape {
    private static final int SIZE = 400;
    private final byte[] buffer;
    private final int index;
    int offset;
    int actualLength;
    int minRow;
    int maxRow;
    int minCol;
    int maxCol;
    int startRow = 200;
    int startCol = 200;
    int[][] grid = new int[400][400];
    int[][] displayGrid;
    boolean valid;
    BufferedImage image;

    public Shape(byte[] buffer, int index) {
        this.index = index;
        this.buffer = buffer;
        int row = this.startRow;
        int col = this.startCol;
        int ptr = this.offset = Utility.getShort(buffer, index * 2 + 2);
        while (ptr < buffer.length) {
            int value;
            if ((value = buffer[ptr++] & 0xFF) == 0) break;
            int v1 = value >>> 6;
            int v2 = (value & 0x38) >>> 3;
            int v3 = value & 7;
            if (v3 >= 4 && !this.plot(this.grid, row, col)) {
                return;
            }
            if (v3 == 0 || v3 == 4) {
                --row;
            } else if (v3 == 1 || v3 == 5) {
                ++col;
            } else if (v3 == 2 || v3 == 6) {
                ++row;
            } else {
                --col;
            }
            if (v2 >= 4 && !this.plot(this.grid, row, col)) {
                return;
            }
            if (v2 == 0 && v1 != 0 || v2 == 4) {
                --row;
            } else if (v2 == 1 || v2 == 5) {
                ++col;
            } else if (v2 == 2 || v2 == 6) {
                ++row;
            } else if (v2 == 3 || v2 == 7) {
                --col;
            }
            if (v1 == 1) {
                ++col;
                continue;
            }
            if (v1 == 2) {
                ++row;
                continue;
            }
            if (v1 != 3) continue;
            --col;
        }
        this.actualLength = ptr - this.offset;
        this.minRow = this.startRow;
        this.maxRow = this.startRow;
        row = 1;
        while (row < this.grid.length) {
            if (this.grid[row][0] > 0) {
                this.minRow = Math.min(this.minRow, row);
                this.maxRow = Math.max(this.maxRow, row);
            }
            ++row;
        }
        this.minCol = this.startCol;
        this.maxCol = this.startCol;
        col = 1;
        while (col < this.grid[0].length) {
            if (this.grid[0][col] > 0) {
                this.minCol = Math.min(this.minCol, col);
                this.maxCol = Math.max(this.maxCol, col);
            }
            ++col;
        }
        this.valid = true;
    }

    void convertGrid(int offsetRows, int offsetColumns, int rows, int columns) {
        this.displayGrid = new int[rows][columns];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < columns) {
                this.displayGrid[row][col] = this.grid[offsetRows + row][offsetColumns + col];
                ++col;
            }
            ++row;
        }
        this.grid = null;
        this.image = new BufferedImage(columns, rows, 10);
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int element = 0;
        int row2 = 0;
        while (row2 < rows) {
            int col = 0;
            while (col < columns) {
                dataBuffer.setElem(element++, this.displayGrid[row2][col] == 0 ? 0 : 255);
                ++col;
            }
            ++row2;
        }
        this.startRow -= offsetRows;
        this.startCol -= offsetColumns;
    }

    private boolean plot(int[][] grid, int row, int col) {
        if (row < 0 || row >= 400 || col < 0 || col >= 400) {
            System.out.printf("Shape table out of range: %d, %d%n", row, col);
            return false;
        }
        grid[row][col] = 1;
        int[] nArray = grid[0];
        int n = col;
        nArray[n] = nArray[n] + 1;
        int[] nArray2 = grid[row];
        nArray2[0] = nArray2[0] + 1;
        return true;
    }

    public void drawText(StringBuilder text) {
        text.append(String.format("Shape  : %d%n", this.index));
        text.append(String.format("Size   : %d%n", this.actualLength));
        String bytes = HexFormatter.getHexString(this.buffer, this.offset, this.actualLength);
        int ptr = this.offset;
        for (String s : this.split(bytes)) {
            text.append(String.format("  %04X : %s%n", ptr, s));
            ptr += 16;
        }
        text.append("\n");
        int row = 0;
        while (row < this.displayGrid.length) {
            int col = 0;
            while (col < this.displayGrid[0].length) {
                if (col == this.startCol && row == this.startRow) {
                    text.append(this.displayGrid[row][col] > 0 ? " @" : " .");
                } else if (this.displayGrid[row][col] == 0) {
                    text.append("  ");
                } else {
                    text.append(" X");
                }
                ++col;
            }
            text.append("\n");
            ++row;
        }
        text.append("\n");
    }

    private List<String> split(String line) {
        ArrayList<String> list = new ArrayList<String>();
        while (line.length() > 48) {
            list.add(line.substring(0, 47));
            line = line.substring(48);
        }
        list.add(line);
        return list;
    }

    public String toString() {
        return String.format("%3d  %3d  %3d  %3d  %3d", this.index, this.minRow, this.maxRow, this.minCol, this.maxCol);
    }
}

