/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import java.util.ArrayList;
import java.util.List;

public class Selector
extends AbstractFile {
    int numRunListEntries;
    int numOtherRunListEntries;
    List<Entry> entries = new ArrayList<Entry>();
    List<Path> paths = new ArrayList<Path>();

    public Selector(String name, byte[] buffer) {
        super(name, buffer);
        this.numRunListEntries = buffer[0] & 0xFF;
        this.numOtherRunListEntries = buffer[1] & 0xFF;
        int ptr = 2;
        int i = 0;
        while (i < 24) {
            this.entries.add(new Entry(buffer, ptr));
            ptr += 16;
            ++i;
        }
        ptr = 386;
        i = 0;
        while (i < 24) {
            this.paths.add(new Path(buffer, ptr));
            ptr += 64;
            ++i;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name    : " + this.name + "\n");
        text.append(String.format("Length  : $%04X (%<,d)%n%n", this.buffer.length));
        text.append(String.format("NumRunListEntries ....... %d%n", this.buffer[0]));
        text.append(String.format("NumOtherRunListEntries .. %d%n%n", this.buffer[1]));
        text.append("Name             Copy         Path\n");
        text.append("--------------   ----------   ------------------------------------\n");
        int i = 0;
        while (i < this.entries.size()) {
            Entry entry = this.entries.get(i);
            Path path = this.paths.get(i);
            if (entry.labelLength > 0) {
                text.append(String.format("%-14s   %-10s   %s%n", entry.label, entry.copyText, path.pathName));
            }
            ++i;
        }
        return text.toString();
    }

    class Entry {
        int labelLength;
        String label;
        byte copyFlags;
        String copyText;

        public Entry(byte[] buffer, int ptr) {
            this.labelLength = buffer[ptr] & 0xFF;
            this.label = new String(buffer, ptr + 1, this.labelLength);
            this.copyFlags = buffer[ptr + 15];
            this.copyText = switch (this.copyFlags & 0xFF) {
                case 0 -> "First boot";
                case 128 -> "First use";
                case 192 -> "Never";
                default -> "Unknown";
            };
        }
    }

    class Path {
        int length;
        String pathName;

        public Path(byte[] buffer, int ptr) {
            this.length = buffer[ptr] & 0xFF;
            this.pathName = new String(buffer, ptr + 1, this.length);
        }
    }
}

