/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class SegmentHeader {
    int bytecnt;
    int resspc;
    int length;
    int kind1;
    String kindWhereText;
    boolean kindReload;
    boolean kindAbsoluteBank;
    boolean kindSpecialMemory;
    boolean kindPosIndependent;
    boolean kindPrivate;
    boolean kindStatic;
    int lablen;
    int numlen;
    int version;
    int banksize;
    int kind2;
    int unused;
    int org;
    int align;
    int numsex;
    int lcbank;
    int segnum;
    int entry;
    int dispname;
    int dispdata;
    String loadname;
    String segname;
    boolean debug = false;

    public SegmentHeader(byte[] buffer, int offset) {
        this.bytecnt = Utility.getLong(buffer, offset);
        this.resspc = Utility.getLong(buffer, offset + 4);
        this.length = Utility.getLong(buffer, offset + 8);
        this.kind1 = buffer[offset + 12] & 0xFF;
        this.lablen = buffer[offset + 13] & 0xFF;
        this.numlen = buffer[offset + 14] & 0xFF;
        this.version = buffer[offset + 15] & 0xFF;
        this.banksize = Utility.getLong(buffer, offset + 16);
        this.kind2 = Utility.getShort(buffer, offset + 20);
        this.unused = Utility.getShort(buffer, offset + 22);
        this.org = Utility.getLong(buffer, offset + 24);
        this.align = Utility.getLong(buffer, offset + 28);
        this.numsex = buffer[offset + 32] & 0xFF;
        this.lcbank = buffer[offset + 33] & 0xFF;
        this.segnum = Utility.getShort(buffer, offset + 34);
        this.entry = Utility.getLong(buffer, offset + 36);
        this.dispname = Utility.getShort(buffer, offset + 40);
        this.dispdata = Utility.getShort(buffer, offset + 42);
        this.decodeKind();
        this.loadname = buffer[offset + this.dispname] == 0 ? "" : new String(buffer, offset + this.dispname, 10);
        this.segname = this.lablen == 0 ? HexFormatter.getPascalString(buffer, offset + this.dispname + 10) : "not finished";
        if (this.debug) {
            System.out.println(this);
        }
        int ptr = offset + this.dispdata;
        block25: while (true) {
            int recType;
            if ((recType = buffer[ptr] & 0xFF) > 0 && recType <= 223) {
                if (this.debug) {
                    System.out.printf("Const: %02X%n", recType);
                    System.out.println(HexFormatter.format(buffer, ptr, recType + 1, ptr));
                }
                ptr += recType + 1;
                continue;
            }
            if (this.debug) {
                System.out.printf("%02X ", recType);
            }
            switch (recType) {
                case 0: {
                    if (!this.debug) break block25;
                    System.out.println("END");
                    break block25;
                }
                case 224: {
                    if (!this.debug) break block25;
                    System.out.printf("ALIGN:%n", new Object[0]);
                    break block25;
                }
                case 225: {
                    if (!this.debug) break block25;
                    System.out.printf("ORG:%n", new Object[0]);
                    break block25;
                }
                case 226: {
                    int bytesRelocated = buffer[ptr + 1] & 0xFF;
                    int bitShift = buffer[ptr + 2] & 0xFF;
                    int segmentOffset = Utility.getLong(buffer, ptr + 3);
                    int value = Utility.getLong(buffer, ptr + 7);
                    if (this.debug) {
                        System.out.printf("RELOC: %02X %02X %08X %08X%n", bytesRelocated, bitShift, segmentOffset, value);
                    }
                    ptr += 11;
                    continue block25;
                }
                case 227: {
                    int count1 = buffer[ptr + 1] & 0xFF;
                    int count2 = buffer[ptr + 2] & 0xFF;
                    int operandOffset = Utility.getLong(buffer, ptr + 3);
                    int fileNo = Utility.getShort(buffer, ptr + 7);
                    int segNo = Utility.getShort(buffer, ptr + 9);
                    int subroutineOffset = Utility.getLong(buffer, ptr + 11);
                    if (this.debug) {
                        System.out.printf("INTERSEG: %02X %02X %08X %04X %04X %08X%n", count1, count2, operandOffset, fileNo, segNo, subroutineOffset);
                    }
                    ptr += 15;
                    break block25;
                }
                case 228: {
                    if (!this.debug) break block25;
                    System.out.printf("USING:%n", new Object[0]);
                    break block25;
                }
                case 229: {
                    if (!this.debug) break block25;
                    System.out.printf("STRONG:%n", new Object[0]);
                    break block25;
                }
                case 230: {
                    if (!this.debug) break block25;
                    System.out.printf("GLOBAL:%n", new Object[0]);
                    break block25;
                }
                case 231: {
                    if (!this.debug) break block25;
                    System.out.printf("GEQU:%n", new Object[0]);
                    break block25;
                }
                case 232: {
                    if (!this.debug) break block25;
                    System.out.printf("MEM:%n", new Object[0]);
                    break block25;
                }
                case 235: {
                    if (!this.debug) break block25;
                    System.out.printf("EXPR:%n", new Object[0]);
                    break block25;
                }
                case 236: {
                    if (!this.debug) break block25;
                    System.out.printf("ZEXPR:%n", new Object[0]);
                    break block25;
                }
                case 237: {
                    if (!this.debug) break block25;
                    System.out.printf("BEXPR:%n", new Object[0]);
                    break block25;
                }
                case 238: {
                    if (!this.debug) break block25;
                    System.out.printf("RELEXPR:%n", new Object[0]);
                    break block25;
                }
                case 239: {
                    if (!this.debug) break block25;
                    System.out.printf("LOCAL:%n", new Object[0]);
                    break block25;
                }
                case 240: {
                    String label = HexFormatter.getPascalString(buffer, ptr + 1);
                    if (!this.debug) break block25;
                    System.out.printf("EQU: %s%n", label);
                    break block25;
                }
                case 241: {
                    if (!this.debug) break block25;
                    System.out.printf("DS:%n", new Object[0]);
                    break block25;
                }
                case 242: {
                    int constLength = Utility.getLong(buffer, ptr + 1);
                    if (this.debug) {
                        System.out.printf("Const: %04X%n", constLength);
                    }
                    ptr += constLength + 5;
                    continue block25;
                }
                case 243: {
                    if (!this.debug) break block25;
                    System.out.printf("LEXPR:%n", new Object[0]);
                    break block25;
                }
                case 244: {
                    if (!this.debug) break block25;
                    System.out.printf("ENTRY:%n", new Object[0]);
                    break block25;
                }
                case 245: {
                    int cBytesRelocated = buffer[ptr + 1] & 0xFF;
                    int cBitShift = buffer[ptr + 2] & 0xFF;
                    int cSegmentOffset = Utility.getShort(buffer, ptr + 3);
                    int cValue = Utility.getShort(buffer, ptr + 5);
                    if (this.debug) {
                        System.out.printf("cRELOC: %02X %02X %08X %08X%n", cBytesRelocated, cBitShift, cSegmentOffset, cValue);
                    }
                    ptr += 7;
                    continue block25;
                }
                case 246: {
                    int cCount1 = buffer[ptr + 1] & 0xFF;
                    int cCount2 = buffer[ptr + 2] & 0xFF;
                    int cOperandOffset = Utility.getShort(buffer, ptr + 3);
                    int cSegNo = buffer[ptr + 5] & 0xFF;
                    int cSubroutineOffset = Utility.getShort(buffer, ptr + 6);
                    if (this.debug) {
                        System.out.printf("cINTERSEG: %02X %02X %04X %02X %04X%n", cCount1, cCount2, cOperandOffset, cSegNo, cSubroutineOffset);
                    }
                    ptr += 8;
                    continue block25;
                }
                case 247: {
                    int superLength = Utility.getLong(buffer, ptr + 1);
                    int recordType = buffer[ptr + 5] & 0xFF;
                    if (this.debug) {
                        System.out.printf("Super type %02X%n", recordType);
                    }
                    ptr += superLength + 5;
                    continue block25;
                }
                default: {
                    System.out.printf("Unknown record type: %02X%n", recType);
                }
            }
            break;
        }
        if (this.debug) {
            System.out.println();
        }
    }

    private void decodeKind() {
        int segAttr;
        int segType;
        if (this.version < 2) {
            segType = this.kind1 & 0x1F;
            segAttr = this.kind1 & 0xE0;
        } else {
            segType = this.kind2 & 0x1F;
            segAttr = this.kind2 >>> 8;
        }
        this.kindReload = (segAttr & 4) != 0;
        this.kindAbsoluteBank = (segAttr & 8) != 0;
        this.kindSpecialMemory = (segAttr & 0x10) == 0;
        this.kindPosIndependent = (segAttr & 0x20) != 0;
        this.kindPrivate = (segAttr & 0x40) != 0;
        this.kindStatic = (segAttr & 0x80) == 0;
        this.kindWhereText = switch (segType) {
            case 0 -> "Code Segment";
            case 1 -> "Data Segment";
            case 2 -> "Jump Table Segment";
            case 4 -> "Pathname Segment";
            case 8 -> "Library Dictionary Segment";
            case 16 -> "Initialization Segment";
            case 17 -> "Absolute Bank Segment";
            case 18 -> "Direct Page / Stack Segment";
            default -> "Unknown";
        };
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Byte count ......... %08X%n", this.bytecnt));
        text.append(String.format("Reserved space ..... %08X%n", this.resspc));
        text.append(String.format("Length ............. %08X%n", this.length));
        text.append(String.format("Kind v1 ............ %02X%n", this.kind1));
        if (this.version < 2) {
            text.append(String.format("  Type ............. %s%n", this.kindWhereText));
            text.append(String.format("  Position ind ..... %s%n", this.kindPosIndependent ? "Yes" : "No"));
            text.append(String.format("  Private .......... %s%n", this.kindPrivate ? "Yes" : "No"));
            text.append(String.format("  Static/Dynamic ... %s%n", this.kindStatic ? "Static" : "Dynamic"));
        }
        text.append(String.format("Label length ....... %02X%n", this.lablen));
        text.append(String.format("Number length ...... %02X%n", this.numlen));
        text.append(String.format("Version ............ %02X%n", this.version));
        text.append(String.format("Bank size .......... %08X%n", this.banksize));
        text.append(String.format("Kind v2 ............ %04X%n", this.kind2));
        if (this.version >= 2) {
            text.append(String.format("  Type ............. %s%n", this.kindWhereText));
            text.append(String.format("  Reload ........... %s%n", this.kindReload ? "Yes" : "No"));
            text.append(String.format("  Absolute Bank .... %s%n", this.kindAbsoluteBank ? "Yes" : "No"));
            text.append(String.format("  Special Memory ... %s%n", this.kindSpecialMemory ? "Yes" : "No"));
            text.append(String.format("  Position ind ..... %s%n", this.kindPosIndependent ? "Yes" : "No"));
            text.append(String.format("  Private .......... %s%n", this.kindPrivate ? "Yes" : "No"));
            text.append(String.format("  Static/Dynamic ... %s%n", this.kindStatic ? "Static" : "Dynamic"));
        }
        text.append(String.format("Unused ............. %04X%n", this.unused));
        text.append(String.format("Org ................ %08X%n", this.org));
        text.append(String.format("Align .............. %08X%n", this.align));
        text.append(String.format("Number sex ......... %02X%n", this.numsex));
        text.append(String.format("LC Bank ............ %02X%n", this.lcbank));
        text.append(String.format("Segment number ..... %04X%n", this.segnum));
        text.append(String.format("Entry .............. %08X%n", this.entry));
        text.append(String.format("Disp name .......... %04X%n", this.dispname));
        text.append(String.format("Disp data .......... %04X%n", this.dispdata));
        text.append(String.format("Load name .......... %s%n", this.loadname));
        text.append(String.format("Segment name ....... %s%n", this.segname));
        return text.toString();
    }
}

