/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.List;

public class SHRPictureFile1
extends HiResImage {
    private final List<Block> blocks = new ArrayList<Block>();
    private Main mainBlock;
    private Multipal multipalBlock;
    private final boolean debug = false;

    public SHRPictureFile1(String name, byte[] buffer, int fileType, int auxType, int eof) {
        super(name, buffer, fileType, auxType, eof);
        int ptr = 0;
        while (ptr < buffer.length) {
            int len = Utility.getLong(buffer, ptr);
            if (len == 0 || len > buffer.length) {
                System.out.printf("Block length: %d%n", len);
                break;
            }
            String kind = HexFormatter.getPascalString(buffer, ptr + 4);
            byte[] data = new byte[Math.min(len, buffer.length - ptr)];
            System.arraycopy(buffer, ptr, data, 0, data.length);
            switch (kind) {
                case "MAIN": {
                    this.mainBlock = new Main(kind, data);
                    this.blocks.add(this.mainBlock);
                    break;
                }
                case "MULTIPAL": {
                    this.multipalBlock = new Multipal(kind, data);
                    this.blocks.add(this.multipalBlock);
                    break;
                }
                case "MASK": 
                case "PATS": 
                case "SCIB": 
                case "PALETTES": {
                    this.blocks.add(new Block(kind, data));
                    break;
                }
                case "Platinum Paint": 
                case "SuperConvert": 
                case "SHRConvert": 
                case "816/Paint": 
                case "EOA ": 
                case "NOTE": 
                case "VSDV": 
                case "VSMK": {
                    this.blocks.add(new Block(kind, data));
                    break;
                }
                case "Nseq": {
                    this.blocks.add(new Nseq(kind, data));
                    break;
                }
                default: {
                    this.blocks.add(new Block(kind, data));
                    System.out.println("Unknown block type: " + kind + " in " + name);
                }
            }
            ptr += len;
        }
        this.createImage();
    }

    @Override
    void createMonochromeImage() {
        this.image = new BufferedImage(320, 200, 10);
        DataBuffer db = this.image.getRaster().getDataBuffer();
        int element = 0;
        int ptr = 0;
        int row = 0;
        while (row < 200) {
            int col = 0;
            while (col < 160) {
                int pix1 = (this.buffer[ptr] & 0xF0) >> 4;
                int pix2 = this.buffer[ptr] & 0xF;
                if (pix1 > 0) {
                    db.setElem(element, 255);
                }
                if (pix2 > 0) {
                    db.setElem(element + 1, 255);
                }
                element += 2;
                ++ptr;
                ++col;
            }
            ++row;
        }
    }

    @Override
    void createColourImage() {
        if (this.mainBlock == null) {
            System.out.println("No MAIN block in image file");
            return;
        }
        boolean mode320 = (this.mainBlock.masterMode & 0x80) == 0;
        int imageWidth = this.mainBlock.pixelsPerScanLine;
        if (mode320) {
            imageWidth *= 2;
        }
        this.image = new BufferedImage(imageWidth, this.mainBlock.numScanLines * 2, 1);
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int element = 0;
        int ptr = 0;
        int line = 0;
        while (line < this.mainBlock.numScanLines) {
            boolean fillMode;
            HiResImage.DirEntry dirEntry = this.mainBlock.scanLineDirectory[line];
            int hi = dirEntry.mode & 0xFF00;
            int lo = dirEntry.mode & 0xFF;
            boolean bl = fillMode = (dirEntry.mode & 0x20) != 0;
            if (hi != 0) {
                System.out.println("hi not zero");
            }
            HiResImage.ColorTable colorTable = this.multipalBlock != null ? this.multipalBlock.colorTables[line] : this.mainBlock.colorTables[lo & 0xF];
            int dataWidth = this.mainBlock.pixelsPerScanLine / (mode320 ? 2 : 4);
            ptr = mode320 ? this.mode320Line(ptr, element, dataWidth, colorTable, dataBuffer, imageWidth) : this.mode640Line(ptr, element, dataWidth, colorTable, dataBuffer, imageWidth);
            element += imageWidth * 2;
            ++line;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder(super.getText());
        if (this.mainBlock == null) {
            text.append("\nFailure    : No MAIN block\n");
        }
        text.append("\n\n");
        for (Block block : this.blocks) {
            text.append(block);
            text.append("\n\n");
        }
        text.deleteCharAt(text.length() - 1);
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private class Block {
        String kind;
        byte[] data;
        int size;

        public Block(String kind, byte[] data) {
            this.kind = kind;
            this.data = data;
            this.size = Utility.getLong(data, 0);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Block ..... %s%n", this.kind));
            text.append(String.format("Size ...... %04X  %<d%n%n", this.size));
            int headerSize = 5 + this.kind.length();
            text.append(HexFormatter.format(this.data, headerSize, this.data.length - headerSize));
            return text.toString();
        }
    }

    private class Main
    extends Block {
        int masterMode;
        int pixelsPerScanLine;
        int numColorTables;
        HiResImage.ColorTable[] colorTables;
        int numScanLines;
        HiResImage.DirEntry[] scanLineDirectory;
        byte[][] packedScanLines;
        boolean mode640;
        int dataWidth;

        public Main(String kind, byte[] data) {
            super(kind, data);
            int ptr = 5 + kind.length();
            this.masterMode = Utility.getShort(data, ptr);
            this.pixelsPerScanLine = Utility.getShort(data, ptr + 2);
            this.numColorTables = Utility.getShort(data, ptr + 4);
            this.mode640 = (this.masterMode & 0x80) != 0;
            ptr += 6;
            this.colorTables = new HiResImage.ColorTable[this.numColorTables];
            int i = 0;
            while (i < this.numColorTables) {
                this.colorTables[i] = new HiResImage.ColorTable(i, data, ptr);
                ptr += 32;
                ++i;
            }
            this.numScanLines = Utility.getShort(data, ptr);
            ptr += 2;
            this.scanLineDirectory = new HiResImage.DirEntry[this.numScanLines];
            this.packedScanLines = new byte[this.numScanLines][];
            int line = 0;
            while (line < this.numScanLines) {
                HiResImage.DirEntry dirEntry;
                this.scanLineDirectory[line] = dirEntry = new HiResImage.DirEntry(data, ptr);
                this.packedScanLines[line] = new byte[dirEntry.numBytes];
                ptr += 4;
                ++line;
            }
            line = 0;
            while (line < this.numScanLines) {
                int numBytes = this.scanLineDirectory[line].numBytes;
                if (ptr + numBytes > data.length) {
                    System.out.println("breaking early");
                    break;
                }
                System.arraycopy(data, ptr, this.packedScanLines[line], 0, numBytes);
                ptr += numBytes;
                ++line;
            }
            this.dataWidth = this.pixelsPerScanLine / (this.mode640 ? 4 : 2);
            byte[] unpackedBuffer = new byte[this.numScanLines * this.dataWidth];
            ptr = 0;
            int line2 = 0;
            while (line2 < this.numScanLines) {
                int bytesUnpacked = SHRPictureFile1.this.unpack(this.packedScanLines[line2], 0, this.packedScanLines[line2].length, unpackedBuffer, ptr);
                ptr += this.dataWidth;
                ++line2;
            }
            SHRPictureFile1.this.buffer = unpackedBuffer;
        }

        @Override
        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Kind ................. %s%n", this.kind));
            text.append(String.format("MasterMode ........... %04X%n", this.masterMode));
            text.append(String.format("PixelsPerScanLine .... %d / %d = %d bytes%n", this.pixelsPerScanLine, this.mode640 ? 4 : 2, this.dataWidth));
            text.append(String.format("NumColorTables ....... %d%n", this.numColorTables));
            text.append(String.format("NumScanLines ......... %d%n%n", this.numScanLines));
            text.append("Color Tables\n");
            text.append("------------\n\n");
            text.append(" # ");
            int i = 0;
            while (i < 16) {
                text.append(String.format("  %02X  ", i));
                ++i;
            }
            text.deleteCharAt(text.length() - 1);
            text.deleteCharAt(text.length() - 1);
            text.append("\n---");
            i = 0;
            while (i < 16) {
                text.append(" ---- ");
                ++i;
            }
            text.deleteCharAt(text.length() - 1);
            text.append("\n");
            HiResImage.ColorTable[] colorTableArray = this.colorTables;
            int n = this.colorTables.length;
            int n2 = 0;
            while (n2 < n) {
                HiResImage.ColorTable colorTable = colorTableArray[n2];
                text.append(colorTable.toLine());
                text.append("\n");
                ++n2;
            }
            text.append("\nScan Lines\n");
            text.append("----------\n\n");
            text.append(" #   Mode  Len       Packed Data\n");
            text.append("---  ----  ---   ---------------------------------------");
            text.append("--------------------------------\n");
            int lineSize = 24;
            int i2 = 0;
            while (i2 < this.scanLineDirectory.length) {
                HiResImage.DirEntry dirEntry = this.scanLineDirectory[i2];
                byte[] packedScanLine = this.packedScanLines[i2];
                text.append(String.format("%3d  %04X  %3d   ", i2, dirEntry.mode, packedScanLine.length));
                int ptr = 0;
                while (true) {
                    String hex = HexFormatter.getHexString(packedScanLine, ptr, lineSize);
                    text.append(hex);
                    if (ptr == 0 && hex.length() < 71) {
                        text.append("                                                                       ".substring(hex.length()));
                    }
                    if ((ptr += lineSize) >= packedScanLine.length) break;
                    text.append("\n                 ");
                }
                text.append("\n");
                text.append("\n");
                text.append(SHRPictureFile1.this.debug(packedScanLine, 0, packedScanLine.length));
                text.append("\n");
                ++i2;
            }
            return text.toString();
        }
    }

    private class Multipal
    extends Block {
        int numColorTables;
        HiResImage.ColorTable[] colorTables;

        public Multipal(String kind, byte[] data) {
            super(kind, data);
            int ptr = 5 + kind.length();
            this.numColorTables = Utility.getShort(data, ptr);
            ptr += 2;
            this.colorTables = new HiResImage.ColorTable[this.numColorTables];
            int i = 0;
            while (i < this.numColorTables) {
                this.colorTables[i] = ptr < data.length - 32 ? new HiResImage.ColorTable(i, data, ptr) : new HiResImage.ColorTable(i, 0);
                ptr += 32;
                ++i;
            }
        }

        @Override
        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Kind ................. %s%n", this.kind));
            text.append(String.format("NumColorTables ....... %d%n%n", this.numColorTables));
            int line = 0;
            while (line < this.numColorTables) {
                text.append(this.colorTables[line]);
                text.append("\n\n");
                ++line;
            }
            return text.toString();
        }
    }

    private class Nseq
    extends Block {
        public Nseq(String kind, byte[] data) {
            super(kind, data);
        }

        @Override
        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Block ..... %s%n", this.kind));
            text.append(String.format("Size ...... %04X  %<d%n%n", this.size));
            int ptr = 5 + this.kind.length();
            while (ptr < this.data.length) {
                text.append(String.valueOf(HexFormatter.format(this.data, ptr, 4)) + "\n");
                ptr += 4;
            }
            text.deleteCharAt(text.length() - 1);
            return text.toString();
        }
    }
}

