/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.CharacterList;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class QuickDrawFont
extends CharacterList {
    Map<Integer, QuickDrawCharacter> qdCharacters = new HashMap<Integer, QuickDrawCharacter>();
    private boolean corrupt;
    private final int fileType;
    private final int auxType;
    private final String fontName;
    private final int headerSize;
    private final int fontSize;
    private final int fontFamily;
    private final int fontStyle;
    private final int versionMajor;
    private final int versionMinor;
    private final int extent;
    private final int fontType;
    private final int firstChar;
    private final int lastChar;
    private final int widMax;
    private final int kernMax;
    private final int nDescent;
    private final int fRectWidth;
    private final int fRectHeight;
    private final int owTLoc;
    private final int ascent;
    private final int descent;
    private final int leading;
    private final int rowWords;
    private final int totalCharacters;
    private final int fontDefinitionOffset;
    private final int bitImageOffset;
    private final int locationTableOffset;
    private final int offsetWidthTableOffset;
    private int offsetWidthTableSize;
    private BitSet[] strike;

    public QuickDrawFont(String name, byte[] buffer, int fileType, int auxType) {
        super(name, buffer);
        assert (fileType == 200);
        this.fileType = fileType;
        this.auxType = auxType;
        if (auxType != 0) {
            System.out.printf("Font aux: %04X%n", auxType);
        }
        this.fontName = HexFormatter.getPascalString(buffer, 0);
        int nameLength = buffer[0] & 0xFF;
        int ptr = nameLength + 1;
        this.headerSize = Utility.getShort(buffer, ptr);
        this.fontDefinitionOffset = nameLength + 1 + this.headerSize * 2;
        this.fontFamily = Utility.getShort(buffer, ptr + 2);
        this.fontStyle = Utility.getShort(buffer, ptr + 4);
        this.fontSize = Utility.getShort(buffer, ptr + 6);
        this.versionMajor = buffer[ptr + 8] & 0xFF;
        this.versionMinor = buffer[ptr + 9] & 0xFF;
        this.extent = Utility.getShort(buffer, ptr + 10);
        ptr = this.fontDefinitionOffset;
        this.fontType = Utility.getShort(buffer, ptr);
        this.firstChar = Utility.getShort(buffer, ptr + 2);
        this.lastChar = Utility.getShort(buffer, ptr + 4);
        this.widMax = Utility.getShort(buffer, ptr + 6);
        this.kernMax = Utility.signedShort(buffer, ptr + 8);
        this.nDescent = Utility.signedShort(buffer, ptr + 10);
        this.fRectWidth = Utility.getShort(buffer, ptr + 12);
        this.fRectHeight = Utility.getShort(buffer, ptr + 14);
        this.owTLoc = Utility.getShort(buffer, ptr + 16);
        this.offsetWidthTableOffset = ptr + 16 + this.owTLoc * 2;
        this.locationTableOffset = this.offsetWidthTableOffset - (this.lastChar - this.firstChar + 3) * 2;
        this.bitImageOffset = ptr + 26;
        this.ascent = Utility.getShort(buffer, ptr + 18);
        this.descent = Utility.getShort(buffer, ptr + 20);
        this.leading = Utility.getShort(buffer, ptr + 22);
        this.rowWords = Utility.getShort(buffer, ptr + 24);
        this.totalCharacters = this.lastChar - this.firstChar + 2;
        this.offsetWidthTableSize = (this.totalCharacters + 1) * 2;
        if (this.offsetWidthTableOffset + this.offsetWidthTableSize > buffer.length) {
            System.out.println("*********** Bad ow length");
            this.strike = null;
            this.corrupt = true;
            return;
        }
        this.createStrike();
        this.createCharacters();
        this.buildImage(10, 10, 5, 5, this.widMax, this.fRectHeight, (int)(Math.sqrt(this.totalCharacters) + 0.5));
    }

    private void createStrike() {
        this.strike = new BitSet[this.fRectHeight];
        int i = 0;
        while (i < this.fRectHeight) {
            this.strike[i] = new BitSet(this.rowWords * 16);
            ++i;
        }
        int rowLenBits = this.rowWords * 16;
        int rowLenBytes = this.rowWords * 2;
        int row = 0;
        while (row < this.fRectHeight) {
            int bit = 0;
            while (bit < rowLenBits) {
                byte b = this.buffer[this.bitImageOffset + row * rowLenBytes + bit / 8];
                this.strike[row].set(bit, (b & 128 >>> bit % 8) != 0);
                ++bit;
            }
            ++row;
        }
    }

    private void createCharacters() {
        int i = 0;
        int max = this.totalCharacters + 1;
        while (i < max) {
            int nextLocation;
            int pixelWidth;
            int location = Utility.getShort(this.buffer, this.locationTableOffset + i * 2);
            int j = i + 1;
            if (j < max && (pixelWidth = (nextLocation = Utility.getShort(this.buffer, this.locationTableOffset + j * 2)) - location) > 0) {
                QuickDrawCharacter c = new QuickDrawCharacter(location, pixelWidth);
                this.qdCharacters.put(i, c);
                this.characters.add(c);
            }
            ++i;
        }
    }

    private void buildDisplay() {
        int inset = 10;
        int spacing = 5;
        int charsWide = (int)(Math.sqrt(this.totalCharacters) + 0.5);
        int charsHigh = (this.totalCharacters - 1) / charsWide + 1;
        this.image = new BufferedImage(charsWide * (this.widMax + spacing) + inset * 2, charsHigh * (this.fRectHeight + spacing) + inset * 2, 10);
        Graphics2D g2d = this.image.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        int x = inset;
        int y = inset;
        int count = 0;
        int i = 0;
        while (i < this.totalCharacters + 1) {
            int pos = this.qdCharacters.containsKey(i) ? i : this.lastChar + 1;
            QuickDrawCharacter character = this.qdCharacters.get(pos);
            if (character != null) {
                g2d.drawImage((Image)character.image, x, y, null);
            }
            x += this.widMax + spacing;
            if (++count % charsWide == 0) {
                x = inset;
                y += this.fRectHeight + spacing;
            }
            ++i;
        }
        g2d.dispose();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Name : " + this.name + "\n\n");
        text.append("File type : Font\n");
        String auxTypeText = this.auxType == 0 ? "QuickDraw Font File" : (this.auxType == 1 ? "XX" : "??");
        text.append(String.format("Aux type  : %04X  (%s)%n%n", this.auxType, auxTypeText));
        text.append(String.format("Font name    : %s%n", this.fontName));
        text.append(String.format("Font family  : %d%n", this.fontFamily));
        text.append(String.format("File type    : %d%n", this.fileType));
        text.append(String.format("Font style   : %d%n", this.fontStyle));
        text.append(String.format("Font size    : %d%n", this.fontSize));
        text.append(String.format("Font version : %d.%d%n", this.versionMajor, this.versionMinor));
        text.append(String.format("Font extent  : %d%n%n", this.extent));
        text.append(String.format("Font type    : %d%n", this.fontType));
        text.append(String.format("First char   : %d%n", this.firstChar));
        text.append(String.format("Last char    : %d%n", this.lastChar));
        text.append(String.format("Max width    : %d%n", this.widMax));
        text.append(String.format("Max kern     : %d%n", this.kernMax));
        text.append(String.format("Neg descent  : %d%n", this.nDescent));
        text.append(String.format("Width        : %d%n", this.fRectWidth));
        text.append(String.format("Height       : %d%n", this.fRectHeight));
        text.append(String.format("O/W Offset   : %04X%n", this.owTLoc));
        text.append(String.format("Ascent       : %d%n", this.ascent));
        text.append(String.format("Descent      : %d%n", this.descent));
        text.append(String.format("Leading      : %d%n", this.leading));
        text.append(String.format("Row words    : %d%n%n", this.rowWords));
        if (this.corrupt) {
            text.append("\nCannot interpret Font file");
            return text.toString();
        }
        int i = 0;
        while (i < this.totalCharacters) {
            int offset = this.buffer[this.offsetWidthTableOffset + i * 2 + 1] & 0xFF;
            int width = this.buffer[this.offsetWidthTableOffset + i * 2] & 0xFF;
            if (offset != 255 || width != 255) {
                int location = Utility.getShort(this.buffer, this.locationTableOffset + i * 2);
                int nextLocation = Utility.getShort(this.buffer, this.locationTableOffset + (i + 1) * 2);
                int pixelWidth = nextLocation - location;
                text.append(String.format("Char %3d, location %,5d, pixelWidth %2d. offset %,5d, width %,5d%n", i, location, pixelWidth, offset, width));
            }
            ++i;
        }
        return text.toString();
    }

    class QuickDrawCharacter
    extends CharacterList.Character {
        public QuickDrawCharacter(int strikeOffset, int strikeWidth) {
            super(strikeWidth, QuickDrawFont.this.fRectHeight);
            DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
            int element = 0;
            int row = 0;
            while (row < QuickDrawFont.this.fRectHeight) {
                int j = strikeOffset;
                while (j < strikeOffset + strikeWidth) {
                    dataBuffer.setElem(element++, QuickDrawFont.this.strike[row].get(j) ? 255 : 0);
                    ++j;
                }
                ++row;
            }
        }
    }
}

