/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.PascalCodeStatement;
import com.bytezone.diskbrowser.applefile.PascalConstants;
import com.bytezone.diskbrowser.applefile.PascalProcedure;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class PascalSegment
extends AbstractFile
implements PascalConstants {
    private static final int BLOCK_SIZE = 512;
    final int segmentNoHeader;
    private int segmentNoBody;
    boolean debug = false;
    public int blockNo;
    public final int size;
    private final int segKind;
    private final int textAddress;
    private final int machineType;
    private final int version;
    private final int intrinsSegs1;
    private final int intrinsSegs2;
    private final int slot;
    private int totalProcedures;
    private List<PascalProcedure> procedures;

    public PascalSegment(String name, byte[] fullBuffer, int seq, int blockOffset) {
        super(name, fullBuffer);
        this.slot = seq;
        this.blockNo = Utility.getShort(fullBuffer, seq * 4);
        this.size = Utility.getShort(fullBuffer, seq * 4 + 2);
        this.segKind = Utility.getShort(fullBuffer, 192 + seq * 2);
        this.textAddress = Utility.getShort(fullBuffer, 224 + seq * 2);
        this.segmentNoHeader = fullBuffer[256 + seq * 2] & 0xFF;
        int flags = fullBuffer[257 + seq * 2] & 0xFF;
        this.machineType = flags & 0xF;
        this.version = (flags & 0xD0) >> 5;
        this.intrinsSegs1 = Utility.getShort(fullBuffer, 288 + seq * 4);
        this.intrinsSegs2 = Utility.getShort(fullBuffer, 288 + seq * 4 + 2);
        int offset = this.blockNo * 512;
        if (offset < 0) {
            this.buffer = new byte[0];
        } else if (offset + this.size < fullBuffer.length) {
            this.buffer = new byte[this.size];
            System.arraycopy(fullBuffer, offset, this.buffer, 0, this.size);
            this.totalProcedures = this.buffer[this.size - 1] & 0xFF;
            this.segmentNoBody = this.buffer[this.size - 2] & 0xFF;
            if (this.debug) {
                if (this.segmentNoHeader == 0) {
                    System.out.printf("Zero segment header in %s seq %d%n", name, seq);
                } else if (this.segmentNoBody != this.segmentNoHeader) {
                    System.out.println("Segment number mismatch : " + this.segmentNoBody + " / " + this.segmentNoHeader);
                }
            }
        } else {
            throw new FileFormatException("Error in PascalSegment");
        }
    }

    private void buildProcedureList() {
        this.procedures = new ArrayList<PascalProcedure>(this.totalProcedures);
        int i = 1;
        while (i <= this.totalProcedures) {
            this.procedures.add(new PascalProcedure(this.buffer, i));
            ++i;
        }
    }

    public String toText() {
        int sizeInBlocks = (this.size - 1) / 512 + 1;
        return String.format(" %2d   %02X   %02X  %04X  %-8s  %-15s%3d   %02X  %d   %d   %d   %d  %s", this.slot, this.blockNo, sizeInBlocks, this.size, this.name, SegmentKind[this.segKind], this.textAddress, this.segmentNoHeader, this.machineType, this.version, this.intrinsSegs1, this.intrinsSegs2, this.getMultiDiskAddresses());
    }

    @Override
    public String getText() {
        if (this.procedures == null) {
            this.buildProcedureList();
        }
        StringBuilder text = new StringBuilder();
        String title = "Segment - " + this.name;
        text.append(String.valueOf(title) + "\n" + "===============================".substring(0, title.length()) + "\n\n");
        String warning = this.segmentNoBody == this.segmentNoHeader ? "" : String.format(" (%02X in routine)", this.segmentNoBody);
        text.append(String.format("Address........ %02X%n", this.blockNo));
        text.append(String.format("Multi disk .... %s%n", this.getMultiDiskAddresses()));
        text.append(String.format("Length......... %04X%n", this.buffer.length));
        text.append(String.format("Machine type... %d%n", this.machineType));
        text.append(String.format("Version........ %d%n", this.version));
        text.append(String.format("Segment........ %02X%s%n", this.segmentNoHeader, warning));
        text.append(String.format("Total procs.... %d%n", this.procedures.size()));
        text.append("\nProcedure Dictionary\n====================\n\n");
        int len = this.procedures.size() * 2 + 2;
        text.append("Proc  Offset  Lvl  Entry   Exit   Parm   Data   Proc header\n");
        text.append("----  ------  ---  -----   ----   ----   ----   --------------------\n");
        for (PascalProcedure procedure : this.procedures) {
            if (procedure.valid) {
                int address = this.size - procedure.slot * 2 - 2;
                text.append(String.format(" %3d   %04X   %3d   %04X   %04X   %04X   %04X   (%04X - %04X = %04X)%n", procedure.procedureNo, procedure.offset, procedure.procLevel, procedure.codeStart, procedure.codeEnd, procedure.parmSize, procedure.dataSize, address, procedure.offset, procedure.procOffset));
                continue;
            }
            text.append(String.format(" %3d   %04X%n", procedure.slot, procedure.offset));
        }
        text.append("\nStrings\n=======\n");
        for (PascalProcedure pp : this.procedures) {
            List<PascalCodeStatement> strings = pp.extractStrings();
            for (PascalCodeStatement cs : strings) {
                text.append(String.format(" %2d   %04X   %s%n", pp.procedureNo, cs.ptr, cs.text));
            }
        }
        for (PascalProcedure procedure : this.procedures) {
            if (!procedure.valid) continue;
            text.append(procedure);
        }
        return text.toString();
    }

    private String getMultiDiskAddresses() {
        String multiDiskAddressText = "";
        return multiDiskAddressText;
    }
}

